/*
 * Decompiled with CFR 0.152.
 */
package cloud.tianai.captcha.generator.impl;

import cloud.tianai.captcha.generator.AbstractImageCaptchaGenerator;
import cloud.tianai.captcha.generator.ImageTransform;
import cloud.tianai.captcha.generator.common.model.dto.CaptchaExchange;
import cloud.tianai.captcha.generator.common.model.dto.CustomData;
import cloud.tianai.captcha.generator.common.model.dto.GenerateParam;
import cloud.tianai.captcha.generator.common.model.dto.ImageCaptchaInfo;
import cloud.tianai.captcha.generator.common.model.dto.ImageTransformData;
import cloud.tianai.captcha.generator.common.model.dto.RotateImageCaptchaInfo;
import cloud.tianai.captcha.generator.common.util.CaptchaImageUtils;
import cloud.tianai.captcha.interceptor.CaptchaInterceptor;
import cloud.tianai.captcha.resource.ImageCaptchaResourceManager;
import cloud.tianai.captcha.resource.common.model.dto.Resource;
import cloud.tianai.captcha.resource.common.model.dto.ResourceMap;
import java.awt.image.BufferedImage;
import java.util.Optional;

public class StandardRotateImageCaptchaGenerator
extends AbstractImageCaptchaGenerator {
    public static String TEMPLATE_ACTIVE_IMAGE_NAME = "active.png";
    public static String TEMPLATE_FIXED_IMAGE_NAME = "fixed.png";
    public static String TEMPLATE_MASK_IMAGE_NAME = "mask.png";

    public StandardRotateImageCaptchaGenerator(ImageCaptchaResourceManager imageCaptchaResourceManager) {
        super(imageCaptchaResourceManager);
    }

    public StandardRotateImageCaptchaGenerator(ImageCaptchaResourceManager imageCaptchaResourceManager, ImageTransform imageTransform) {
        super(imageCaptchaResourceManager);
        this.setImageTransform(imageTransform);
    }

    public StandardRotateImageCaptchaGenerator(ImageCaptchaResourceManager imageCaptchaResourceManager, ImageTransform imageTransform, CaptchaInterceptor interceptor) {
        super(imageCaptchaResourceManager);
        this.setImageTransform(imageTransform);
        this.setInterceptor(interceptor);
    }

    @Override
    protected void doInit() {
    }

    @Override
    public void doGenerateCaptchaImage(CaptchaExchange captchaExchange) {
        GenerateParam param = captchaExchange.getParam();
        CustomData data = new CustomData();
        ResourceMap templateResource = this.requiredRandomGetTemplate(param.getType(), param.getTemplateImageTag());
        Resource resourceImage = this.requiredRandomGetResource(param.getType(), param.getBackgroundImageTag());
        BufferedImage background = this.getResourceImage(resourceImage);
        BufferedImage fixedTemplate = this.getTemplateImage(templateResource, TEMPLATE_FIXED_IMAGE_NAME);
        BufferedImage activeTemplate = this.getTemplateImage(templateResource, TEMPLATE_ACTIVE_IMAGE_NAME);
        BufferedImage maskTemplate = fixedTemplate;
        Optional<BufferedImage> maskTemplateOptional = this.getTemplateImageOfOptional(templateResource, TEMPLATE_MASK_IMAGE_NAME);
        if (maskTemplateOptional.isPresent()) {
            maskTemplate = maskTemplateOptional.get();
        }
        int x = background.getWidth() / 2 - fixedTemplate.getWidth() / 2;
        int y = background.getHeight() / 2 - fixedTemplate.getHeight() / 2;
        BufferedImage cutImage = CaptchaImageUtils.cutImage(background, maskTemplate, x, y);
        BufferedImage rotateFixed = fixedTemplate;
        BufferedImage rotateActive = activeTemplate;
        if (param.getObfuscate().booleanValue()) {
            int randomDegree = this.randomInt(10, 350);
            rotateFixed = CaptchaImageUtils.rotateImage(fixedTemplate, randomDegree);
            randomDegree = this.randomInt(10, 350);
            rotateActive = CaptchaImageUtils.rotateImage(activeTemplate, randomDegree);
        }
        CaptchaImageUtils.overlayImage(background, rotateFixed, x, y);
        CaptchaImageUtils.overlayImage(cutImage, rotateActive, 0, 0);
        int randomX = this.randomInt(fixedTemplate.getWidth() + 10, background.getWidth() - 10);
        double degree = 360.0 - (double)randomX / ((double)background.getWidth() / 360.0);
        BufferedImage matrixTemplate = CaptchaImageUtils.createTransparentImage(cutImage.getWidth(), background.getHeight());
        CaptchaImageUtils.centerOverlayAndRotateImage(matrixTemplate, cutImage, degree);
        RotateData rotateData = new RotateData();
        rotateData.degree = degree;
        rotateData.randomX = randomX;
        captchaExchange.setTransferData(rotateData);
        captchaExchange.setBackgroundImage(background);
        captchaExchange.setTemplateImage(matrixTemplate);
        captchaExchange.setTemplateResource(templateResource);
        captchaExchange.setResourceImage(resourceImage);
    }

    private String getObfuscateTag(String templateTag) {
        if (templateTag == null) {
            return "obfuscate";
        }
        return templateTag + "_obfuscate";
    }

    @Override
    public ImageCaptchaInfo doWrapImageCaptchaInfo(CaptchaExchange captchaExchange) {
        GenerateParam param = captchaExchange.getParam();
        BufferedImage backgroundImage = captchaExchange.getBackgroundImage();
        BufferedImage sliderImage = captchaExchange.getTemplateImage();
        Resource resourceImage = captchaExchange.getResourceImage();
        ResourceMap templateResource = captchaExchange.getTemplateResource();
        CustomData data = captchaExchange.getCustomData();
        RotateData rotateData = (RotateData)captchaExchange.getTransferData();
        ImageTransformData transform = this.getImageTransform().transform(param, backgroundImage, sliderImage, resourceImage, templateResource, data);
        RotateImageCaptchaInfo imageCaptchaInfo = RotateImageCaptchaInfo.of(rotateData.degree, rotateData.randomX, transform.getBackgroundImageUrl(), transform.getTemplateImageUrl(), resourceImage.getTag(), templateResource.getTag(), (Integer)backgroundImage.getWidth(), (Integer)backgroundImage.getHeight(), (Integer)sliderImage.getWidth(), sliderImage.getHeight());
        imageCaptchaInfo.setData(data);
        return imageCaptchaInfo;
    }

    public static class RotateData {
        double degree;
        int randomX;
    }
}

