/*
 * Decompiled with CFR 0.152.
 */
package cloud.tianai.captcha.resource;

import cloud.tianai.captcha.resource.ResourceProvider;
import cloud.tianai.captcha.resource.common.model.dto.Resource;
import cloud.tianai.captcha.resource.impl.provider.ClassPathResourceProvider;
import cloud.tianai.captcha.resource.impl.provider.FileResourceProvider;
import cloud.tianai.captcha.resource.impl.provider.URLResourceProvider;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ResourceProviders {
    private final List<ResourceProvider> resourceProviderList = new ArrayList<ResourceProvider>(8);

    public ResourceProviders() {
        this.registerResourceProvider(new URLResourceProvider());
        this.registerResourceProvider(new ClassPathResourceProvider());
        this.registerResourceProvider(new FileResourceProvider());
    }

    public void registerResourceProvider(ResourceProvider resourceProvider) {
        this.deleteResourceProviderByName(resourceProvider.getName());
        this.resourceProviderList.add(resourceProvider);
    }

    public boolean deleteResourceProviderByName(String name) {
        return this.resourceProviderList.removeIf(r -> r.getName().equals(name));
    }

    public List<ResourceProvider> listResourceProviders() {
        return Collections.unmodifiableList(this.resourceProviderList);
    }

    public InputStream getResourceInputStream(Resource resource) {
        for (ResourceProvider resourceProvider : this.resourceProviderList) {
            if (!resourceProvider.supported(resource)) continue;
            InputStream resourceInputStream = resourceProvider.getResourceInputStream(resource);
            if (resourceInputStream == null) {
                throw new IllegalArgumentException("\u6ed1\u5757\u9a8c\u8bc1\u7801 ResourceProvider \u8bfb\u5230\u7684\u56fe\u7247\u8d44\u6e90\u4e3a\u7a7a,providerName=[" + resourceProvider.getName() + "], resource=[" + resource + "]");
            }
            return resourceInputStream;
        }
        throw new IllegalStateException("\u6ca1\u6709\u627e\u5230Resource [" + resource.getType() + "]\u5bf9\u5e94\u7684\u8d44\u6e90\u63d0\u4f9b\u8005");
    }
}

