/*
 * Decompiled with CFR 0.152.
 */
package cloud.tianai.captcha.resource.impl;

import cloud.tianai.captcha.common.util.CollectionUtils;
import cloud.tianai.captcha.common.util.ObjectUtils;
import cloud.tianai.captcha.resource.CrudResourceStore;
import cloud.tianai.captcha.resource.ImageCaptchaResourceManager;
import cloud.tianai.captcha.resource.common.model.dto.Resource;
import cloud.tianai.captcha.resource.common.model.dto.ResourceMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;

public class LocalMemoryResourceStore
implements CrudResourceStore {
    private final Map<String, Map<String, List<ResourceMap>>> templateResourceTagMap = new HashMap<String, Map<String, List<ResourceMap>>>(2);
    private final Map<String, Map<String, List<Resource>>> resourceTagMap = new HashMap<String, Map<String, List<Resource>>>(2);

    private void ensureTypeTagMapExists(Map<String, Map<String, List<Resource>>> map, String type, String tag) {
        map.computeIfAbsent(type, k -> new HashMap()).computeIfAbsent(tag, k -> new ArrayList(20));
    }

    private void ensureTypeTagMapExistsForTemplate(Map<String, Map<String, List<ResourceMap>>> map, String type, String tag) {
        map.computeIfAbsent(type, k -> new HashMap()).computeIfAbsent(tag, k -> new ArrayList(2));
    }

    @Override
    public void addResource(String type, Resource resource) {
        if (ObjectUtils.isEmpty(resource.getTag())) {
            resource.setTag("default");
        }
        this.ensureTypeTagMapExists(this.resourceTagMap, type, resource.getTag());
        this.resourceTagMap.get(type).get(resource.getTag()).add(resource);
    }

    @Override
    public void addTemplate(String type, ResourceMap template) {
        if (ObjectUtils.isEmpty(template.getTag())) {
            template.setTag("default");
        }
        this.ensureTypeTagMapExistsForTemplate(this.templateResourceTagMap, type, template.getTag());
        this.templateResourceTagMap.get(type).get(template.getTag()).add(template);
    }

    @Override
    public Resource deleteResource(String type, String id) {
        Map<String, List<Resource>> tagMap = this.resourceTagMap.get(type);
        if (tagMap == null) {
            return null;
        }
        for (List<Resource> resources : tagMap.values()) {
            Iterator<Resource> iterator = resources.iterator();
            while (iterator.hasNext()) {
                Resource res = iterator.next();
                if (!res.getId().equals(id)) continue;
                iterator.remove();
                return res;
            }
        }
        return null;
    }

    @Override
    public ResourceMap deleteTemplate(String type, String id) {
        Map<String, List<ResourceMap>> tagMap = this.templateResourceTagMap.get(type);
        if (tagMap == null) {
            return null;
        }
        for (List<ResourceMap> templates : tagMap.values()) {
            Iterator<ResourceMap> iterator = templates.iterator();
            while (iterator.hasNext()) {
                ResourceMap temp = iterator.next();
                if (!temp.getId().equals(id)) continue;
                iterator.remove();
                return temp;
            }
        }
        return null;
    }

    @Override
    public List<Resource> listResourcesByTypeAndTag(String type, String tag) {
        if (!ObjectUtils.isEmpty(tag)) {
            Map<String, List<Resource>> tagMap = this.resourceTagMap.get(type);
            return tagMap == null ? Collections.emptyList() : tagMap.getOrDefault(tag, Collections.emptyList());
        }
        ArrayList<Resource> result = new ArrayList<Resource>();
        Map<String, List<Resource>> tagMap = this.resourceTagMap.get(type);
        if (tagMap != null) {
            for (List<Resource> list : tagMap.values()) {
                result.addAll(list);
            }
        }
        return result;
    }

    @Override
    public List<ResourceMap> listTemplatesByTypeAndTag(String type, String tag) {
        if (!ObjectUtils.isEmpty(tag)) {
            Map<String, List<ResourceMap>> tagMap = this.templateResourceTagMap.get(type);
            return tagMap == null ? Collections.emptyList() : tagMap.getOrDefault(tag, Collections.emptyList());
        }
        ArrayList<ResourceMap> result = new ArrayList<ResourceMap>();
        Map<String, List<ResourceMap>> tagMap = this.templateResourceTagMap.get(type);
        if (tagMap != null) {
            for (List<ResourceMap> list : tagMap.values()) {
                result.addAll(list);
            }
        }
        return result;
    }

    @Override
    public void init(ImageCaptchaResourceManager resourceManager) {
    }

    @Override
    public List<Resource> randomGetResourceByTypeAndTag(String type, String tag, Integer quantity) {
        List<Resource> resources = this.listResourcesByTypeAndTag(type, tag);
        if (CollectionUtils.isEmpty(resources)) {
            throw new IllegalStateException("\u968f\u673a\u83b7\u53d6\u8d44\u6e90\u9519\u8bef\uff0cstore\u4e2d\u8d44\u6e90\u4e3a\u7a7a, type:" + type + ",tag:" + tag);
        }
        int size = resources.size();
        if (quantity > size) {
            throw new IllegalArgumentException("\u8bf7\u6c42\u7684\u8d44\u6e90\u6570\u91cf\u8d85\u8fc7\u53ef\u7528\u8d44\u6e90\u603b\u6570");
        }
        HashSet<Integer> indexes = new HashSet<Integer>(quantity);
        while (indexes.size() < quantity) {
            indexes.add(ThreadLocalRandom.current().nextInt(size));
        }
        ArrayList<Resource> result = new ArrayList<Resource>(quantity);
        Iterator iterator = indexes.iterator();
        while (iterator.hasNext()) {
            int index = (Integer)iterator.next();
            result.add(resources.get(index));
        }
        return result;
    }

    @Override
    public List<ResourceMap> randomGetTemplateByTypeAndTag(String type, String tag, Integer quantity) {
        List<ResourceMap> templates = this.listTemplatesByTypeAndTag(type, tag);
        if (CollectionUtils.isEmpty(templates)) {
            throw new IllegalStateException("\u968f\u673a\u83b7\u53d6\u6a21\u677f\u9519\u8bef\uff0cstore\u4e2d\u6a21\u677f\u4e3a\u7a7a, type:" + type + ",tag:" + tag);
        }
        int size = templates.size();
        if (quantity > size) {
            throw new IllegalArgumentException("\u8bf7\u6c42\u7684\u6a21\u677f\u6570\u91cf\u8d85\u8fc7\u53ef\u7528\u6a21\u677f\u603b\u6570");
        }
        HashSet<Integer> indexes = new HashSet<Integer>(quantity);
        while (indexes.size() < quantity) {
            indexes.add(ThreadLocalRandom.current().nextInt(size));
        }
        ArrayList<ResourceMap> result = new ArrayList<ResourceMap>(quantity);
        Iterator iterator = indexes.iterator();
        while (iterator.hasNext()) {
            int index = (Integer)iterator.next();
            result.add(templates.get(index));
        }
        return result;
    }

    @Override
    public void clearAllResources() {
        this.resourceTagMap.clear();
    }

    @Override
    public void clearAllTemplates() {
        this.templateResourceTagMap.clear();
    }
}

