/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.spring.data.connection;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.redisson.client.handler.State;
import org.redisson.client.protocol.decoder.MultiDecoder;
import org.springframework.data.geo.Distance;
import org.springframework.data.geo.GeoResult;
import org.springframework.data.geo.GeoResults;
import org.springframework.data.geo.Metric;
import org.springframework.data.geo.Point;
import org.springframework.data.redis.connection.RedisGeoCommands;

public class ByteBufferGeoResultsDecoder
implements MultiDecoder<GeoResults<RedisGeoCommands.GeoLocation<ByteBuffer>>> {
    private final Metric metric;

    public ByteBufferGeoResultsDecoder() {
        this(null);
    }

    public ByteBufferGeoResultsDecoder(Metric metric) {
        this.metric = metric;
    }

    @Override
    public GeoResults<RedisGeoCommands.GeoLocation<ByteBuffer>> decode(List<Object> parts, State state) {
        ArrayList<GeoResult<RedisGeoCommands.GeoLocation<ByteBuffer>>> result = new ArrayList<GeoResult<RedisGeoCommands.GeoLocation<ByteBuffer>>>();
        for (Object object : parts) {
            if (object instanceof List) {
                RedisGeoCommands.GeoLocation<ByteBuffer> location;
                List vals = (List)object;
                if (this.metric != null) {
                    location = new RedisGeoCommands.GeoLocation<ByteBuffer>(ByteBuffer.wrap((byte[])vals.get(0)), null);
                    result.add(new GeoResult<RedisGeoCommands.GeoLocation<ByteBuffer>>(location, new Distance((Double)vals.get(1), this.metric)));
                    continue;
                }
                location = new RedisGeoCommands.GeoLocation<ByteBuffer>(ByteBuffer.wrap((byte[])vals.get(0)), (Point)vals.get(1));
                result.add(new GeoResult<RedisGeoCommands.GeoLocation<ByteBuffer>>(location, null));
                continue;
            }
            RedisGeoCommands.GeoLocation<ByteBuffer> location = new RedisGeoCommands.GeoLocation<ByteBuffer>(ByteBuffer.wrap((byte[])object), null);
            result.add(new GeoResult<RedisGeoCommands.GeoLocation<ByteBuffer>>(location, new Distance(0.0)));
        }
        return new GeoResults<RedisGeoCommands.GeoLocation<ByteBuffer>>(result);
    }
}

