/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.spring.data.connection;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.reactivestreams.Publisher;
import org.redisson.ScanResult;
import org.redisson.api.RFuture;
import org.redisson.client.RedisClient;
import org.redisson.client.codec.ByteArrayCodec;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.StringCodec;
import org.redisson.client.handler.State;
import org.redisson.client.protocol.RedisCommand;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.client.protocol.RedisStrictCommand;
import org.redisson.client.protocol.decoder.MultiDecoder;
import org.redisson.reactive.CommandReactiveExecutor;
import org.redisson.reactive.MapReactiveIterator;
import org.redisson.spring.data.connection.RedissonBaseReactive;
import org.springframework.data.redis.connection.ReactiveHashCommands;
import org.springframework.data.redis.connection.ReactiveRedisConnection;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class RedissonReactiveHashCommands
extends RedissonBaseReactive
implements ReactiveHashCommands {
    private static final RedisCommand<String> HMSET = new RedisCommand("HMSET");
    private static final RedisCommand<List<Object>> HMGET = new RedisCommand<List<Object>>("HMGET", new MultiDecoder<List<Object>>(){

        @Override
        public List<Object> decode(List<Object> parts, State state) {
            List list = parts.stream().filter(e -> e != null).collect(Collectors.toList());
            if (list.isEmpty()) {
                return null;
            }
            return parts;
        }
    });
    private static final RedisCommand<Long> HSTRLEN = new RedisCommand("HSTRLEN");

    RedissonReactiveHashCommands(CommandReactiveExecutor executorService) {
        super(executorService);
    }

    @Override
    public Flux<ReactiveRedisConnection.BooleanResponse<ReactiveHashCommands.HSetCommand>> hSet(Publisher<ReactiveHashCommands.HSetCommand> commands) {
        return this.execute(commands, command -> {
            Assert.notNull((Object)command.getKey(), "Key must not be null!");
            Assert.notNull(command.getFieldValueMap(), "FieldValueMap must not be null!");
            byte[] keyBuf = RedissonReactiveHashCommands.toByteArray(command.getKey());
            if (command.getFieldValueMap().size() == 1) {
                Map.Entry<ByteBuffer, ByteBuffer> entry = command.getFieldValueMap().entrySet().iterator().next();
                byte[] mapKeyBuf = RedissonReactiveHashCommands.toByteArray(entry.getKey());
                byte[] mapValueBuf = RedissonReactiveHashCommands.toByteArray(entry.getValue());
                RedisStrictCommand<Boolean> cmd = RedisCommands.HSETNX;
                if (command.isUpsert()) {
                    cmd = RedisCommands.HSET;
                }
                Mono<Boolean> m = this.write(keyBuf, StringCodec.INSTANCE, cmd, keyBuf, mapKeyBuf, mapValueBuf);
                return m.map(v -> new ReactiveRedisConnection.BooleanResponse<ReactiveHashCommands.HSetCommand>((ReactiveHashCommands.HSetCommand)command, (Boolean)v));
            }
            ArrayList<byte[]> params = new ArrayList<byte[]>(command.getFieldValueMap().size() * 2 + 1);
            params.add(keyBuf);
            for (Map.Entry<ByteBuffer, ByteBuffer> entry : command.getFieldValueMap().entrySet()) {
                params.add(RedissonReactiveHashCommands.toByteArray(entry.getKey()));
                params.add(RedissonReactiveHashCommands.toByteArray(entry.getValue()));
            }
            Mono<String> m = this.write(keyBuf, StringCodec.INSTANCE, HMSET, params.toArray());
            return m.map(v -> new ReactiveRedisConnection.BooleanResponse<ReactiveHashCommands.HSetCommand>((ReactiveHashCommands.HSetCommand)command, true));
        });
    }

    @Override
    public Flux<ReactiveRedisConnection.MultiValueResponse<ReactiveHashCommands.HGetCommand, ByteBuffer>> hMGet(Publisher<ReactiveHashCommands.HGetCommand> commands) {
        return this.execute(commands, command -> {
            Assert.notNull((Object)command.getKey(), "Key must not be null!");
            Assert.notNull(command.getFields(), "Fields must not be null!");
            byte[] keyBuf = RedissonReactiveHashCommands.toByteArray(command.getKey());
            ArrayList<byte[]> args = new ArrayList<byte[]>(command.getFields().size() + 1);
            args.add(keyBuf);
            args.addAll(command.getFields().stream().map(buf -> RedissonReactiveHashCommands.toByteArray(buf)).collect(Collectors.toList()));
            Mono<List> m = this.read(keyBuf, ByteArrayCodec.INSTANCE, HMGET, args.toArray());
            return m.map(v -> {
                List values = v.stream().map(array -> {
                    if (array != null) {
                        return ByteBuffer.wrap(array);
                    }
                    return null;
                }).collect(Collectors.toList());
                return new ReactiveRedisConnection.MultiValueResponse((ReactiveHashCommands.HGetCommand)command, values);
            });
        });
    }

    @Override
    public Flux<ReactiveRedisConnection.BooleanResponse<ReactiveHashCommands.HExistsCommand>> hExists(Publisher<ReactiveHashCommands.HExistsCommand> commands) {
        return this.execute(commands, command -> {
            Assert.notNull((Object)command.getKey(), "Key must not be null!");
            Assert.notNull((Object)command.getField(), "Field must not be null!");
            byte[] keyBuf = RedissonReactiveHashCommands.toByteArray(command.getKey());
            byte[] fieldBuf = RedissonReactiveHashCommands.toByteArray(command.getField());
            Mono<Boolean> m = this.read(keyBuf, StringCodec.INSTANCE, RedisCommands.HEXISTS, keyBuf, fieldBuf);
            return m.map(v -> new ReactiveRedisConnection.BooleanResponse<ReactiveHashCommands.HExistsCommand>((ReactiveHashCommands.HExistsCommand)command, (Boolean)v));
        });
    }

    @Override
    public Flux<ReactiveRedisConnection.NumericResponse<ReactiveHashCommands.HDelCommand, Long>> hDel(Publisher<ReactiveHashCommands.HDelCommand> commands) {
        return this.execute(commands, command -> {
            Assert.notNull((Object)command.getKey(), "Key must not be null!");
            Assert.notNull(command.getFields(), "Fields must not be null!");
            ArrayList<byte[]> args = new ArrayList<byte[]>(command.getFields().size() + 1);
            args.add(RedissonReactiveHashCommands.toByteArray(command.getKey()));
            args.addAll(command.getFields().stream().map(v -> RedissonReactiveHashCommands.toByteArray(v)).collect(Collectors.toList()));
            Mono<Long> m = this.write((byte[])args.get(0), StringCodec.INSTANCE, RedisCommands.HDEL, args.toArray());
            return m.map(v -> new ReactiveRedisConnection.NumericResponse<ReactiveHashCommands.HDelCommand, Long>((ReactiveHashCommands.HDelCommand)command, (Long)v));
        });
    }

    @Override
    public Flux<ReactiveRedisConnection.NumericResponse<ReactiveRedisConnection.KeyCommand, Long>> hLen(Publisher<ReactiveRedisConnection.KeyCommand> commands) {
        return this.execute(commands, command -> {
            Assert.notNull((Object)command.getKey(), "Key must not be null!");
            byte[] keyBuf = RedissonReactiveHashCommands.toByteArray(command.getKey());
            Mono<Long> m = this.read(keyBuf, StringCodec.INSTANCE, RedisCommands.HLEN_LONG, new Object[]{keyBuf});
            return m.map(v -> new ReactiveRedisConnection.NumericResponse<ReactiveRedisConnection.KeyCommand, Long>((ReactiveRedisConnection.KeyCommand)command, (Long)v));
        });
    }

    @Override
    public Flux<ReactiveRedisConnection.CommandResponse<ReactiveRedisConnection.KeyCommand, Flux<ByteBuffer>>> hKeys(Publisher<ReactiveRedisConnection.KeyCommand> commands) {
        return this.execute(commands, command -> {
            Assert.notNull((Object)command.getKey(), "Key must not be null!");
            byte[] keyBuf = RedissonReactiveHashCommands.toByteArray(command.getKey());
            Mono<Set> m = this.read(keyBuf, ByteArrayCodec.INSTANCE, RedisCommands.HKEYS, new Object[]{keyBuf});
            return m.map(v -> new ReactiveRedisConnection.CommandResponse<ReactiveRedisConnection.KeyCommand, Flux<ByteBuffer>>((ReactiveRedisConnection.KeyCommand)command, Flux.fromIterable(v).map(e -> ByteBuffer.wrap(e))));
        });
    }

    @Override
    public Flux<ReactiveRedisConnection.CommandResponse<ReactiveRedisConnection.KeyCommand, Flux<ByteBuffer>>> hVals(Publisher<ReactiveRedisConnection.KeyCommand> commands) {
        return this.execute(commands, command -> {
            Assert.notNull((Object)command.getKey(), "Key must not be null!");
            byte[] keyBuf = RedissonReactiveHashCommands.toByteArray(command.getKey());
            Mono<List> m = this.read(keyBuf, ByteArrayCodec.INSTANCE, RedisCommands.HVALS, new Object[]{keyBuf});
            return m.map(v -> new ReactiveRedisConnection.CommandResponse<ReactiveRedisConnection.KeyCommand, Flux<ByteBuffer>>((ReactiveRedisConnection.KeyCommand)command, Flux.fromIterable(v).map(e -> ByteBuffer.wrap(e))));
        });
    }

    @Override
    public Flux<ReactiveRedisConnection.CommandResponse<ReactiveRedisConnection.KeyCommand, Flux<Map.Entry<ByteBuffer, ByteBuffer>>>> hGetAll(Publisher<ReactiveRedisConnection.KeyCommand> commands) {
        return this.execute(commands, command -> {
            Assert.notNull((Object)command.getKey(), "Key must not be null!");
            byte[] keyBuf = RedissonReactiveHashCommands.toByteArray(command.getKey());
            Mono<Map> m = this.read(keyBuf, ByteArrayCodec.INSTANCE, RedisCommands.HGETALL, new Object[]{keyBuf});
            Mono<Map> f = m.map(v -> v.entrySet().stream().collect(Collectors.toMap(e -> ByteBuffer.wrap((byte[])e.getKey()), e -> ByteBuffer.wrap((byte[])e.getValue()))));
            return f.map(v -> new ReactiveRedisConnection.CommandResponse((ReactiveRedisConnection.KeyCommand)command, Flux.fromIterable(v.entrySet())));
        });
    }

    @Override
    public Flux<ReactiveRedisConnection.CommandResponse<ReactiveRedisConnection.KeyCommand, Flux<Map.Entry<ByteBuffer, ByteBuffer>>>> hScan(Publisher<ReactiveRedisConnection.KeyScanCommand> commands) {
        return this.execute(commands, command -> {
            Assert.notNull((Object)command.getKey(), "Key must not be null!");
            Assert.notNull((Object)command.getOptions(), "ScanOptions must not be null!");
            final byte[] keyBuf = RedissonReactiveHashCommands.toByteArray(command.getKey());
            Flux<Map.Entry<Object, Object>> flux = Flux.create(new MapReactiveIterator<Object, Object, Map.Entry<Object, Object>>(null, null, 0){

                @Override
                public RFuture<ScanResult<Object>> scanIterator(RedisClient client, String nextIterPos) {
                    if (command.getOptions().getPattern() == null) {
                        return RedissonReactiveHashCommands.this.executorService.readAsync(client, keyBuf, (Codec)ByteArrayCodec.INSTANCE, RedisCommands.HSCAN, keyBuf, nextIterPos, "COUNT", Optional.ofNullable(command.getOptions().getCount()).orElse(10L));
                    }
                    return RedissonReactiveHashCommands.this.executorService.readAsync(client, keyBuf, (Codec)ByteArrayCodec.INSTANCE, RedisCommands.HSCAN, keyBuf, nextIterPos, "MATCH", command.getOptions().getPattern(), "COUNT", Optional.ofNullable(command.getOptions().getCount()).orElse(10L));
                }
            });
            Flux<Map.Entry> f = flux.map(v -> Collections.singletonMap(ByteBuffer.wrap((byte[])v.getKey()), ByteBuffer.wrap((byte[])v.getValue())).entrySet().iterator().next());
            return Mono.just(new ReactiveRedisConnection.CommandResponse<ReactiveRedisConnection.KeyScanCommand, Flux<Map.Entry>>((ReactiveRedisConnection.KeyScanCommand)command, f));
        });
    }

    @Override
    public Flux<ReactiveRedisConnection.NumericResponse<ReactiveHashCommands.HStrLenCommand, Long>> hStrLen(Publisher<ReactiveHashCommands.HStrLenCommand> commands) {
        return this.execute(commands, command -> {
            Assert.notNull((Object)command.getKey(), "Key must not be null!");
            Assert.notNull((Object)command.getField(), "Field must not be null!");
            byte[] keyBuf = RedissonReactiveHashCommands.toByteArray(command.getKey());
            byte[] fieldBuf = RedissonReactiveHashCommands.toByteArray(command.getField());
            Mono<Long> m = this.read(keyBuf, StringCodec.INSTANCE, HSTRLEN, keyBuf, fieldBuf);
            return m.map(v -> new ReactiveRedisConnection.NumericResponse<ReactiveHashCommands.HStrLenCommand, Long>((ReactiveHashCommands.HStrLenCommand)command, (Long)v));
        });
    }

    @Override
    public Flux<ReactiveRedisConnection.CommandResponse<ReactiveHashCommands.HRandFieldCommand, Flux<ByteBuffer>>> hRandField(Publisher<ReactiveHashCommands.HRandFieldCommand> commands) {
        return this.execute(commands, command -> {
            Assert.notNull((Object)command.getKey(), "Key must not be null!");
            byte[] keyBuf = RedissonReactiveHashCommands.toByteArray(command.getKey());
            Mono<Set<Object>> m = command.getCount() > 0L ? this.read(keyBuf, ByteArrayCodec.INSTANCE, RedisCommands.HRANDFIELD_KEYS, keyBuf, command.getCount()) : this.read(keyBuf, ByteArrayCodec.INSTANCE, RedisCommands.HRANDFIELD_KEYS, new Object[]{keyBuf});
            return m.map(v -> new ReactiveRedisConnection.CommandResponse<ReactiveHashCommands.HRandFieldCommand, Flux<ByteBuffer>>((ReactiveHashCommands.HRandFieldCommand)command, Flux.fromIterable(v).map(e -> ByteBuffer.wrap(e))));
        });
    }

    @Override
    public Flux<ReactiveRedisConnection.CommandResponse<ReactiveHashCommands.HRandFieldCommand, Flux<Map.Entry<ByteBuffer, ByteBuffer>>>> hRandFieldWithValues(Publisher<ReactiveHashCommands.HRandFieldCommand> commands) {
        return this.execute(commands, command -> {
            Assert.notNull((Object)command.getKey(), "Key must not be null!");
            byte[] keyBuf = RedissonReactiveHashCommands.toByteArray(command.getKey());
            Mono m = command.getCount() > 0L ? this.read(keyBuf, ByteArrayCodec.INSTANCE, this.executorService.getServiceManager().getHRandomFieldCommand(), keyBuf, command.getCount()) : this.read(keyBuf, ByteArrayCodec.INSTANCE, this.executorService.getServiceManager().getHRandomFieldCommand(), new Object[]{keyBuf});
            Mono<Map> f = m.map(v -> v.entrySet().stream().collect(Collectors.toMap(e -> ByteBuffer.wrap((byte[])e.getKey()), e -> ByteBuffer.wrap((byte[])e.getValue()))));
            return f.map(v -> new ReactiveRedisConnection.CommandResponse((ReactiveHashCommands.HRandFieldCommand)command, Flux.fromIterable(v.entrySet())));
        });
    }
}

