/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.spring.data.connection;

import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.redisson.api.StreamInfo;
import org.redisson.api.StreamMessageId;
import org.redisson.client.codec.ByteArrayCodec;
import org.redisson.client.codec.StringCodec;
import org.redisson.client.handler.State;
import org.redisson.client.protocol.RedisCommand;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.client.protocol.RedisStrictCommand;
import org.redisson.client.protocol.convertor.EmptyMapConvertor;
import org.redisson.client.protocol.convertor.StreamIdConvertor;
import org.redisson.client.protocol.decoder.CodecDecoder;
import org.redisson.client.protocol.decoder.ListMultiDecoder2;
import org.redisson.client.protocol.decoder.MapEntriesDecoder;
import org.redisson.client.protocol.decoder.MultiDecoder;
import org.redisson.client.protocol.decoder.ObjectDecoder;
import org.redisson.client.protocol.decoder.ObjectListReplayDecoder;
import org.redisson.client.protocol.decoder.ObjectMapDecoder;
import org.redisson.client.protocol.decoder.ObjectMapReplayDecoder;
import org.redisson.client.protocol.decoder.StreamIdDecoder;
import org.redisson.client.protocol.decoder.StreamObjectMapReplayDecoder;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.spring.data.connection.RedissonConnection;
import org.springframework.data.domain.Range;
import org.springframework.data.redis.connection.Limit;
import org.springframework.data.redis.connection.RedisStreamCommands;
import org.springframework.data.redis.connection.stream.ByteRecord;
import org.springframework.data.redis.connection.stream.Consumer;
import org.springframework.data.redis.connection.stream.MapRecord;
import org.springframework.data.redis.connection.stream.PendingMessage;
import org.springframework.data.redis.connection.stream.PendingMessages;
import org.springframework.data.redis.connection.stream.PendingMessagesSummary;
import org.springframework.data.redis.connection.stream.ReadOffset;
import org.springframework.data.redis.connection.stream.RecordId;
import org.springframework.data.redis.connection.stream.StreamInfo;
import org.springframework.data.redis.connection.stream.StreamOffset;
import org.springframework.data.redis.connection.stream.StreamReadOptions;
import org.springframework.data.redis.connection.stream.StreamRecords;
import org.springframework.util.Assert;

public class RedissonStreamCommands
implements RedisStreamCommands {
    private final RedissonConnection connection;
    private final CommandAsyncExecutor executor;
    private static final RedisStrictCommand<RecordId> XCLAIM_JUSTID = new RedisStrictCommand<RecordId>("XCLAIM", obj -> RecordId.of(obj.toString()));
    private static final RedisCommand<StreamInfo<Object, Object>> XINFO_STREAM = new RedisCommand<Object>("XINFO", "STREAM", new ListMultiDecoder2(new XInfoStreamReplayDecoder(), new CodecDecoder(), new ObjectMapDecoder(false)));
    RedisCommand<StreamInfo.XInfoGroups> XINFO_GROUPS = new RedisCommand<Object>("XINFO", "GROUPS", new ListMultiDecoder2(new XInfoGroupsReplayDecoder(), new ObjectListReplayDecoder(), new ObjectListReplayDecoder()));
    private static final RedisStrictCommand<RecordId> XADD = new RedisStrictCommand<RecordId>("XADD", obj -> RecordId.of(obj.toString()));
    private static final RedisStrictCommand<String> XGROUP_STRING = new RedisStrictCommand("XGROUP");
    private static final RedisStrictCommand<Boolean> XGROUP_BOOLEAN = new RedisStrictCommand<Boolean>("XGROUP", obj -> (Long)obj > 0L);
    private static final RedisCommand<List<ByteRecord>> XREAD = new RedisCommand<Object>("XREAD", new ListMultiDecoder2(new ByteRecordReplayDecoder2(), new ObjectDecoder<Object>(StringCodec.INSTANCE.getValueDecoder()), new ObjectDecoder<Object>(new StreamIdDecoder()), new ObjectDecoder<Object>(new StreamIdDecoder()), new MapEntriesDecoder(new StreamObjectMapReplayDecoder())));
    private static final RedisCommand<List<ByteRecord>> XREAD_BLOCKING = new RedisCommand<List<ByteRecord>>("XREAD", XREAD.getReplayMultiDecoder());
    private static final RedisCommand<List<ByteRecord>> XREADGROUP = new RedisCommand<List<ByteRecord>>("XREADGROUP", XREAD.getReplayMultiDecoder());
    private static final RedisCommand<List<ByteRecord>> XREADGROUP_BLOCKING = new RedisCommand<List<ByteRecord>>("XREADGROUP", XREADGROUP.getReplayMultiDecoder());
    private static final RedisCommand<List<ByteRecord>> XREAD_V2 = new RedisCommand<Object>("XREAD", new ListMultiDecoder2(new ByteRecordReplayDecoder2_V2(), new CodecDecoder(), new ObjectDecoder<Object>(new StreamIdDecoder()), new StreamObjectMapReplayDecoder()), new EmptyMapConvertor());
    private static final RedisCommand<List<ByteRecord>> XREAD_BLOCKING_V2 = new RedisCommand<List<ByteRecord>>("XREAD", XREAD_V2.getReplayMultiDecoder());
    private static final RedisCommand<List<ByteRecord>> XREADGROUP_V2 = new RedisCommand<List<ByteRecord>>("XREADGROUP", XREAD_V2.getReplayMultiDecoder());
    private static final RedisCommand<List<ByteRecord>> XREADGROUP_BLOCKING_V2 = new RedisCommand<List<ByteRecord>>("XREADGROUP", XREADGROUP_V2.getReplayMultiDecoder());

    public RedissonStreamCommands(RedissonConnection connection, CommandAsyncExecutor executor) {
        this.connection = connection;
        this.executor = executor;
    }

    private static List<String> toStringList(RecordId ... recordIds) {
        if (recordIds.length == 1) {
            return Arrays.asList(recordIds[0].getValue());
        }
        return Arrays.stream(recordIds).map(RecordId::getValue).collect(Collectors.toList());
    }

    @Override
    public RecordId xAdd(MapRecord<byte[], byte[], byte[]> record) {
        return this.xAdd(record, RedisStreamCommands.XAddOptions.none());
    }

    @Override
    public List<RecordId> xClaimJustId(byte[] key, String group, String newOwner, RedisStreamCommands.XClaimOptions options) {
        Assert.notNull((Object)key, "Key must not be null!");
        Assert.notNull((Object)group, "Group name must not be null!");
        Assert.notNull((Object)newOwner, "NewOwner must not be null!");
        Assert.notEmpty(options.getIds(), "Ids collection must not be empty!");
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(key);
        params.add(group);
        params.add(newOwner);
        params.add(Objects.requireNonNull(options.getIdleTime()).toMillis());
        params.addAll(Arrays.asList(options.getIdsAsStringArray()));
        params.add("JUSTID");
        return (List)this.connection.write(key, StringCodec.INSTANCE, XCLAIM_JUSTID, params.toArray());
    }

    @Override
    public List<ByteRecord> xClaim(byte[] key, String group, String newOwner, RedisStreamCommands.XClaimOptions options) {
        Assert.notNull((Object)key, "Key must not be null!");
        Assert.notNull((Object)group, "Group name must not be null!");
        Assert.notNull((Object)newOwner, "NewOwner must not be null!");
        Assert.notEmpty(options.getIds(), "Ids collection must not be empty!");
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(key);
        params.add(group);
        params.add(newOwner);
        params.add(Objects.requireNonNull(options.getIdleTime()).toMillis());
        params.addAll(Arrays.asList(options.getIdsAsStringArray()));
        return (List)this.connection.write(key, ByteArrayCodec.INSTANCE, new RedisCommand<Object>("XCLAIM", new ListMultiDecoder2(new ByteRecordReplayDecoder(key), new ObjectDecoder<Object>(new StreamIdDecoder()), new MapEntriesDecoder(new StreamObjectMapReplayDecoder()))), params.toArray());
    }

    @Override
    public String xGroupCreate(byte[] key, String groupName, ReadOffset readOffset, boolean mkStream) {
        Assert.notNull((Object)key, "Key must not be null!");
        Assert.notNull((Object)groupName, "GroupName must not be null!");
        Assert.notNull((Object)readOffset, "ReadOffset must not be null!");
        ArrayList<Object> params = new ArrayList<Object>();
        params.add("CREATE");
        params.add(key);
        params.add(groupName);
        params.add(readOffset.getOffset());
        if (mkStream) {
            params.add("MKSTREAM");
        }
        return (String)this.connection.write(key, StringCodec.INSTANCE, XGROUP_STRING, params.toArray());
    }

    @Override
    public StreamInfo.XInfoStream xInfo(byte[] key) {
        Assert.notNull((Object)key, "Key must not be null!");
        return (StreamInfo.XInfoStream)this.connection.write(key, StringCodec.INSTANCE, XINFO_STREAM, new Object[]{key});
    }

    @Override
    public StreamInfo.XInfoGroups xInfoGroups(byte[] key) {
        return (StreamInfo.XInfoGroups)this.connection.write(key, StringCodec.INSTANCE, this.XINFO_GROUPS, new Object[]{key});
    }

    @Override
    public StreamInfo.XInfoConsumers xInfoConsumers(byte[] key, String groupName) {
        return (StreamInfo.XInfoConsumers)this.connection.write(key, StringCodec.INSTANCE, new RedisCommand<Object>("XINFO", "CONSUMERS", new ListMultiDecoder2(new XInfoConsumersReplayDecoder(groupName), new ObjectListReplayDecoder(), new ObjectListReplayDecoder())), key, groupName);
    }

    @Override
    public PendingMessagesSummary xPending(byte[] key, String groupName) {
        Assert.notNull((Object)key, "Key must not be null!");
        Assert.notNull((Object)groupName, "Group name must not be null!");
        return (PendingMessagesSummary)this.connection.write(key, StringCodec.INSTANCE, new RedisCommand<Object>("XPENDING", new ListMultiDecoder2(new PendingMessagesSummaryReplayDecoder(groupName), new ObjectListReplayDecoder(), new ObjectListReplayDecoder())), key, groupName);
    }

    @Override
    public PendingMessages xPending(byte[] key, String groupName, RedisStreamCommands.XPendingOptions options) {
        Assert.notNull((Object)key, "Key must not be null!");
        Assert.notNull((Object)groupName, "Group name must not be null!");
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(key);
        params.add(groupName);
        params.add(options.getRange().getLowerBound().getValue().orElse("-"));
        params.add(options.getRange().getUpperBound().getValue().orElse("+"));
        if (options.getCount() != null) {
            params.add(options.getCount());
        } else {
            params.add(10);
        }
        if (options.getConsumerName() != null) {
            params.add(options.getConsumerName());
        }
        return (PendingMessages)this.connection.write(key, StringCodec.INSTANCE, new RedisCommand<Object>("XPENDING", new ListMultiDecoder2(new PendingMessagesReplayDecoder(groupName, options.getRange()), new PendingMessageReplayDecoder(groupName))), params.toArray());
    }

    @Override
    public Long xAck(byte[] key, String group, RecordId ... recordIds) {
        Assert.notNull((Object)key, "Key must not be null!");
        Assert.notNull((Object)group, "Group must not be null!");
        Assert.notNull((Object)recordIds, "recordIds must not be null!");
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(key);
        params.add(group);
        params.addAll(RedissonStreamCommands.toStringList(recordIds));
        return (Long)this.connection.write(key, StringCodec.INSTANCE, RedisCommands.XACK, params.toArray());
    }

    @Override
    public RecordId xAdd(MapRecord<byte[], byte[], byte[]> record, RedisStreamCommands.XAddOptions options) {
        Assert.notNull(record, "record must not be null!");
        LinkedList<Object> params = new LinkedList<Object>();
        params.add(record.getStream());
        if (options.getMaxlen() != null) {
            params.add("MAXLEN");
            params.add(options.getMaxlen());
        }
        if (!record.getId().shouldBeAutoGenerated()) {
            params.add(record.getId().getValue());
        } else {
            params.add("*");
        }
        ((Map)record.getValue()).forEach((key, value) -> {
            params.add(key);
            params.add(value);
        });
        return (RecordId)this.connection.write((byte[])record.getStream(), StringCodec.INSTANCE, XADD, params.toArray());
    }

    @Override
    public Long xDel(byte[] key, RecordId ... recordIds) {
        Assert.notNull((Object)key, "Key must not be null!");
        Assert.notNull((Object)recordIds, "recordIds must not be null!");
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(key);
        params.addAll(RedissonStreamCommands.toStringList(recordIds));
        return (Long)this.connection.write(key, StringCodec.INSTANCE, RedisCommands.XDEL, params.toArray());
    }

    @Override
    public String xGroupCreate(byte[] key, String groupName, ReadOffset readOffset) {
        return this.xGroupCreate(key, groupName, readOffset, false);
    }

    @Override
    public Boolean xGroupDelConsumer(byte[] key, Consumer consumer) {
        Assert.notNull((Object)key, "Key must not be null!");
        Assert.notNull((Object)consumer, "Consumer must not be null!");
        Assert.notNull((Object)consumer.getName(), "Consumer name must not be null!");
        Assert.notNull((Object)consumer.getGroup(), "Consumer group must not be null!");
        return (Boolean)this.connection.write(key, StringCodec.INSTANCE, XGROUP_BOOLEAN, "DELCONSUMER", key, consumer.getGroup(), consumer.getName());
    }

    @Override
    public Boolean xGroupDestroy(byte[] key, String groupName) {
        Assert.notNull((Object)key, "Key must not be null!");
        Assert.notNull((Object)groupName, "GroupName must not be null!");
        return (Boolean)this.connection.write(key, StringCodec.INSTANCE, XGROUP_BOOLEAN, "DESTROY", key, groupName);
    }

    @Override
    public Long xLen(byte[] key) {
        Assert.notNull((Object)key, "Key must not be null!");
        return (Long)this.connection.write(key, StringCodec.INSTANCE, RedisCommands.XLEN, new Object[]{key});
    }

    private List<ByteRecord> range(RedisCommand<?> rangeCommand, byte[] key, Range<String> range, Limit limit) {
        Assert.notNull((Object)key, "Key must not be null!");
        Assert.notNull(range, "Range must not be null!");
        Assert.notNull((Object)limit, "Limit must not be null!");
        LinkedList<Object> params = new LinkedList<Object>();
        params.add(key);
        if (rangeCommand.getName().equals(RedisCommands.XRANGE.getName())) {
            params.add(range.getLowerBound().getValue().orElse("-"));
            params.add(range.getUpperBound().getValue().orElse("+"));
        } else {
            params.add(range.getUpperBound().getValue().orElse("+"));
            params.add(range.getLowerBound().getValue().orElse("-"));
        }
        if (limit.getCount() > 0) {
            params.add("COUNT");
            params.add(limit.getCount());
        }
        return (List)this.connection.write(key, ByteArrayCodec.INSTANCE, rangeCommand, params.toArray());
    }

    public List<ByteRecord> xRange(byte[] key, Range<String> range, Limit limit) {
        return this.range(new RedisCommand<Object>("XRANGE", new ListMultiDecoder2(new ByteRecordReplayDecoder(key), new ObjectDecoder<Object>(new StreamIdDecoder()), new MapEntriesDecoder(new StreamObjectMapReplayDecoder()))), key, range, limit);
    }

    @Override
    public List<ByteRecord> xRead(StreamReadOptions readOptions, StreamOffset<byte[]> ... streams) {
        Assert.notNull((Object)readOptions, "ReadOptions must not be null!");
        Assert.notNull(streams, "StreamOffsets must not be null!");
        ArrayList<Object> params = new ArrayList<Object>();
        if (readOptions.getCount() != null && readOptions.getCount() > 0L) {
            params.add("COUNT");
            params.add(readOptions.getCount());
        }
        if (readOptions.getBlock() != null && readOptions.getBlock() > 0L) {
            params.add("BLOCK");
            params.add(readOptions.getBlock());
        }
        params.add("STREAMS");
        for (StreamOffset<byte[]> streamOffset : streams) {
            params.add(streamOffset.getKey());
        }
        for (StreamOffset<byte[]> streamOffset : streams) {
            params.add(streamOffset.getOffset().getOffset());
        }
        if (this.executor.getServiceManager().isResp3()) {
            if (readOptions.getBlock() != null && readOptions.getBlock() > 0L) {
                return (List)this.connection.read(streams[0].getKey(), ByteArrayCodec.INSTANCE, XREAD_BLOCKING_V2, params.toArray());
            }
            return (List)this.connection.read(streams[0].getKey(), ByteArrayCodec.INSTANCE, XREAD_V2, params.toArray());
        }
        if (readOptions.getBlock() != null && readOptions.getBlock() > 0L) {
            return (List)this.connection.read(streams[0].getKey(), ByteArrayCodec.INSTANCE, XREAD_BLOCKING, params.toArray());
        }
        return (List)this.connection.read(streams[0].getKey(), ByteArrayCodec.INSTANCE, XREAD, params.toArray());
    }

    @Override
    public List<ByteRecord> xReadGroup(Consumer consumer, StreamReadOptions readOptions, StreamOffset<byte[]> ... streams) {
        Assert.notNull((Object)readOptions, "Consumer must not be null!");
        Assert.notNull((Object)readOptions, "ReadOptions must not be null!");
        Assert.notNull(streams, "StreamOffsets must not be null!");
        ArrayList<Object> params = new ArrayList<Object>();
        params.add("GROUP");
        params.add(consumer.getGroup());
        params.add(consumer.getName());
        if (readOptions.getCount() != null && readOptions.getCount() > 0L) {
            params.add("COUNT");
            params.add(readOptions.getCount());
        }
        if (readOptions.getBlock() != null && readOptions.getBlock() > 0L) {
            params.add("BLOCK");
            params.add(readOptions.getBlock());
        }
        if (readOptions.isNoack()) {
            params.add("NOACK");
        }
        params.add("STREAMS");
        for (StreamOffset<byte[]> streamOffset : streams) {
            params.add(streamOffset.getKey());
        }
        for (StreamOffset<byte[]> streamOffset : streams) {
            params.add(streamOffset.getOffset().getOffset());
        }
        if (this.executor.getServiceManager().isResp3()) {
            if (readOptions.getBlock() != null && readOptions.getBlock() > 0L) {
                return (List)this.connection.write(streams[0].getKey(), ByteArrayCodec.INSTANCE, XREADGROUP_BLOCKING_V2, params.toArray());
            }
            return (List)this.connection.write(streams[0].getKey(), ByteArrayCodec.INSTANCE, XREADGROUP_V2, params.toArray());
        }
        if (readOptions.getBlock() != null && readOptions.getBlock() > 0L) {
            return (List)this.connection.write(streams[0].getKey(), ByteArrayCodec.INSTANCE, XREADGROUP_BLOCKING, params.toArray());
        }
        return (List)this.connection.write(streams[0].getKey(), ByteArrayCodec.INSTANCE, XREADGROUP, params.toArray());
    }

    public List<ByteRecord> xRevRange(byte[] key, Range<String> range, Limit limit) {
        return this.range(new RedisCommand<Object>("XREVRANGE", new ListMultiDecoder2(new ByteRecordReplayDecoder(key), new ObjectDecoder<Object>(new StreamIdDecoder()), new MapEntriesDecoder(new StreamObjectMapReplayDecoder()))), key, range, limit);
    }

    @Override
    public Long xTrim(byte[] key, long count) {
        return this.xTrim(key, count, false);
    }

    @Override
    public Long xTrim(byte[] key, long count, boolean approximateTrimming) {
        Assert.notNull((Object)key, "Key must not be null!");
        Assert.notNull((Object)count, "Count must not be null!");
        ArrayList<Object> params = new ArrayList<Object>(4);
        params.add(key);
        params.add("MAXLEN");
        if (approximateTrimming) {
            params.add("~");
        }
        params.add(count);
        return (Long)this.connection.write(key, StringCodec.INSTANCE, RedisCommands.XTRIM, params.toArray());
    }

    static {
        RedisCommands.BLOCKING_COMMANDS.add(XREAD_BLOCKING);
        RedisCommands.BLOCKING_COMMANDS.add(XREADGROUP_BLOCKING);
        RedisCommands.BLOCKING_COMMANDS.add(XREAD_BLOCKING_V2);
        RedisCommands.BLOCKING_COMMANDS.add(XREADGROUP_BLOCKING_V2);
    }

    private static class XInfoGroupsReplayDecoder
    implements MultiDecoder<StreamInfo.XInfoGroups> {
        private XInfoGroupsReplayDecoder() {
        }

        @Override
        public StreamInfo.XInfoGroups decode(List<Object> parts, State state) {
            ArrayList<Object> result = new ArrayList<Object>();
            for (List list : parts) {
                HashMap res = new HashMap();
                res.put("name", list.get(1));
                res.put("consumers", list.get(3));
                res.put("pending", list.get(5));
                res.put("last-delivered-id", list.get(7));
                List list2 = res.entrySet().stream().flatMap(e -> Stream.of(e.getKey(), e.getValue())).collect(Collectors.toList());
                result.add(list2);
            }
            return StreamInfo.XInfoGroups.fromList(result);
        }
    }

    private static class ByteRecordReplayDecoder
    implements MultiDecoder<List<ByteRecord>> {
        private final byte[] key;

        ByteRecordReplayDecoder(byte[] key) {
            this.key = key;
        }

        @Override
        public List<ByteRecord> decode(List<Object> parts, State state) {
            List<Object> list = parts;
            ArrayList<ByteRecord> result = new ArrayList<ByteRecord>(parts.size() / 2);
            for (List list2 : list) {
                ByteRecord record = StreamRecords.newRecord().in(this.key).withId(RecordId.of(list2.get(0).toString())).ofBytes((Map)list2.get(1));
                result.add(record);
            }
            return result;
        }
    }

    private static class XInfoConsumersReplayDecoder
    implements MultiDecoder<StreamInfo.XInfoConsumers> {
        private final String groupName;

        public XInfoConsumersReplayDecoder(String groupName) {
            this.groupName = groupName;
        }

        @Override
        public StreamInfo.XInfoConsumers decode(List<Object> parts, State state) {
            ArrayList<Object> result = new ArrayList<Object>();
            for (List list : parts) {
                HashMap res = new HashMap();
                res.put("name", list.get(1));
                res.put("pending", list.get(3));
                res.put("idle", list.get(5));
                List list2 = res.entrySet().stream().flatMap(e -> Stream.of(e.getKey(), e.getValue())).collect(Collectors.toList());
                result.add(list2);
            }
            return StreamInfo.XInfoConsumers.fromList(this.groupName, result);
        }
    }

    private static class PendingMessagesSummaryReplayDecoder
    implements MultiDecoder<PendingMessagesSummary> {
        private final String groupName;

        public PendingMessagesSummaryReplayDecoder(String groupName) {
            this.groupName = groupName;
        }

        @Override
        public PendingMessagesSummary decode(List<Object> parts, State state) {
            if (parts.isEmpty()) {
                return null;
            }
            List customerParts = (List)parts.get(3);
            if (customerParts.isEmpty()) {
                return new PendingMessagesSummary(this.groupName, 0L, Range.unbounded(), Collections.emptyMap());
            }
            Map map = customerParts.stream().collect(Collectors.toMap(e -> (String)e.get(0), e -> Long.valueOf((String)e.get(1)), (u, v) -> {
                throw new IllegalStateException("Duplicate key: " + u);
            }, LinkedHashMap::new));
            Range<String> range = Range.open(parts.get(1).toString(), parts.get(2).toString());
            return new PendingMessagesSummary(this.groupName, (Long)parts.get(0), range, map);
        }
    }

    private static class PendingMessagesReplayDecoder
    implements MultiDecoder<PendingMessages> {
        private final String groupName;
        private final Range<?> range;

        public PendingMessagesReplayDecoder(String groupName, Range<?> range) {
            this.groupName = groupName;
            this.range = range;
        }

        @Override
        public PendingMessages decode(List<Object> parts, State state) {
            List<Object> pendingMessages = parts;
            return new PendingMessages(this.groupName, this.range, pendingMessages);
        }
    }

    private static class PendingMessageReplayDecoder
    implements MultiDecoder<PendingMessage> {
        private String groupName;

        public PendingMessageReplayDecoder(String groupName) {
            this.groupName = groupName;
        }

        @Override
        public PendingMessage decode(List<Object> parts, State state) {
            PendingMessage pm = new PendingMessage(RecordId.of(parts.get(0).toString()), Consumer.from(this.groupName, parts.get(1).toString()), Duration.of(Long.valueOf(parts.get(2).toString()), ChronoUnit.MILLIS), Long.valueOf(parts.get(3).toString()));
            return pm;
        }
    }

    private static class XInfoStreamReplayDecoder
    implements MultiDecoder<StreamInfo.XInfoStream> {
        private final ObjectMapReplayDecoder<Object, Object> decoder = new ObjectMapReplayDecoder();

        private XInfoStreamReplayDecoder() {
        }

        @Override
        public StreamInfo.XInfoStream decode(List<Object> parts, State state) {
            List lastEntry;
            Object map = this.decoder.decode((List)parts, state);
            List firstEntry = (List)map.get("first-entry");
            if (firstEntry != null) {
                StreamMessageId firstId = StreamIdConvertor.INSTANCE.convert(firstEntry.get(0));
                Map firstData = (Map)firstEntry.get(1);
                map.put("first-entry", firstData);
            }
            if ((lastEntry = (List)map.get("last-entry")) != null) {
                StreamMessageId lastId = StreamIdConvertor.INSTANCE.convert(lastEntry.get(0));
                Map lastData = (Map)lastEntry.get(1);
                map.put("last-entry", lastData);
            }
            List<Object> list = map.entrySet().stream().flatMap(e -> Stream.of(e.getKey(), e.getValue())).collect(Collectors.toList());
            return StreamInfo.XInfoStream.fromList(list);
        }
    }

    private static class ByteRecordReplayDecoder2
    implements MultiDecoder<List<ByteRecord>> {
        private ByteRecordReplayDecoder2() {
        }

        @Override
        public List<ByteRecord> decode(List<Object> parts, State state) {
            List<Object> list = parts;
            ArrayList<ByteRecord> result = new ArrayList<ByteRecord>(parts.size() / 2);
            for (List list2 : list) {
                List streamEntries = (List)list2.get(1);
                if (streamEntries.isEmpty()) continue;
                String name = (String)list2.get(0);
                for (List se : streamEntries) {
                    ByteRecord record = StreamRecords.newRecord().in(name.getBytes()).withId(RecordId.of(se.get(0).toString())).ofBytes((Map)se.get(1));
                    result.add(record);
                }
            }
            return result;
        }
    }

    private static class ByteRecordReplayDecoder2_V2
    implements MultiDecoder<List<ByteRecord>> {
        private ByteRecordReplayDecoder2_V2() {
        }

        @Override
        public List<ByteRecord> decode(List<Object> parts, State state) {
            List<Object> list = parts;
            ArrayList<ByteRecord> result = new ArrayList<ByteRecord>(parts.size() / 2);
            for (int i = 0; i < list.size(); i += 2) {
                List streamEntries = (List)list.get(i + 1);
                if (streamEntries.isEmpty()) continue;
                byte[] name = (byte[])list.get(0);
                for (List se : streamEntries) {
                    ByteRecord record = StreamRecords.newRecord().in(name).withId(RecordId.of(se.get(0).toString())).ofBytes((Map)se.get(1));
                    result.add(record);
                }
            }
            return result;
        }
    }
}

