/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.spring.support;

import java.util.List;
import org.redisson.Redisson;
import org.redisson.config.Config;
import org.redisson.spring.support.RedissonNamespaceParserSupport;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.parsing.BeanComponentDefinition;
import org.springframework.beans.factory.parsing.CompositeComponentDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.core.Conventions;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public final class RedissonDefinitionParser
implements BeanDefinitionParser {
    public static final String ID_ATTRIBUTE = "id";
    public static final String NAME_ATTRIBUTE = "name";
    private static final String REF_SUFFIX = "-ref";
    private static final String REDISSON_REF = "redisson-ref";
    private final RedissonNamespaceParserSupport helper;

    RedissonDefinitionParser(RedissonNamespaceParserSupport helper) {
        this.helper = helper;
    }

    private void parseChildElements(Element element, String parentId, String redissonRef, BeanDefinitionBuilder redissonDef, ParserContext parserContext) {
        if (element.hasChildNodes()) {
            CompositeComponentDefinition compositeDef = new CompositeComponentDefinition(parentId, parserContext.extractSource(element));
            parserContext.pushContainingComponent(compositeDef);
            List<Element> childElts = DomUtils.getChildElements(element);
            for (Element elt : childElts) {
                if ("qualifier".equals(elt.getLocalName())) continue;
                String localName = parserContext.getDelegate().getLocalName(elt);
                if (ConfigType.contains(localName = Conventions.attributeNameToPropertyName(localName))) {
                    this.parseConfigTypes(elt, localName, redissonDef, parserContext);
                    continue;
                }
                if (AddressType.contains(localName)) {
                    this.parseAddressTypes(elt, localName, redissonDef, parserContext);
                    continue;
                }
                if (!this.helper.isRedissonNS(elt)) continue;
                elt.setAttribute(REDISSON_REF, redissonRef);
                parserContext.getDelegate().parseCustomElement(elt);
            }
            parserContext.popContainingComponent();
        }
    }

    private void parseConfigTypes(Element element, String configType, BeanDefinitionBuilder redissonDef, ParserContext parserContext) {
        BeanDefinitionBuilder builder = this.helper.createBeanDefinitionBuilder(element, parserContext, null);
        AbstractBeanDefinition bd = builder.getRawBeanDefinition();
        bd.setFactoryMethodName("use" + StringUtils.capitalize(configType));
        bd.setFactoryBeanName(parserContext.getContainingComponent().getName());
        String id = parserContext.getReaderContext().generateBeanName(bd);
        this.helper.registerBeanDefinition(builder, id, this.helper.parseAliase(element), parserContext);
        this.helper.parseAttributes(element, parserContext, builder);
        redissonDef.addDependsOn(id);
        this.parseChildElements(element, id, null, redissonDef, parserContext);
        parserContext.getDelegate().parseQualifierElements(element, bd);
    }

    private void parseAddressTypes(Element element, String addressType, BeanDefinitionBuilder redissonDef, ParserContext parserContext) {
        BeanComponentDefinition invoker = this.helper.invoker(element, parserContext.getContainingComponent().getName(), "add" + StringUtils.capitalize(addressType), (Object[])new String[]{element.getAttribute("value")}, parserContext);
        String id = invoker.getName();
        redissonDef.addDependsOn(id);
    }

    @Override
    public BeanDefinition parse(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder configBuilder = this.helper.createBeanDefinitionBuilder(element, parserContext, Config.class);
        String configId = this.helper.getId(null, configBuilder, parserContext);
        this.helper.parseAttributes(element, parserContext, configBuilder);
        this.helper.registerBeanDefinition(configBuilder, configId, null, parserContext);
        BeanDefinitionBuilder builder = this.helper.createBeanDefinitionBuilder(element, parserContext, Redisson.class);
        builder.setFactoryMethod("create");
        builder.setDestroyMethodName("shutdown");
        builder.addConstructorArgReference(configId);
        parserContext.getDelegate().parseQualifierElements(element, builder.getRawBeanDefinition());
        String id = this.helper.getId(element, builder, parserContext);
        this.helper.parseAttributes(element, parserContext, configBuilder);
        this.parseChildElements(element, configId, id, builder, parserContext);
        this.helper.registerBeanDefinition(builder, id, this.helper.parseAliase(element), parserContext);
        return builder.getBeanDefinition();
    }

    static enum ConfigType {
        singleServer,
        sentinelServers,
        replicatedServers,
        masterSlaveServers,
        clusterServers;


        public static boolean contains(String type) {
            try {
                ConfigType.valueOf(type);
                return true;
            }
            catch (IllegalArgumentException e) {
                return false;
            }
        }
    }

    static enum AddressType {
        slaveAddress,
        sentinelAddress,
        nodeAddress;


        public static boolean contains(String type) {
            try {
                AddressType.valueOf(type);
                return true;
            }
            catch (IllegalArgumentException e) {
                return false;
            }
        }
    }
}

