/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.spring.support;

import org.redisson.spring.support.RedissonNamespaceDecorator;
import org.redisson.spring.support.RedissonNamespaceParserSupport;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class RedissonNestedElementAwareDecorator
implements RedissonNamespaceDecorator {
    private final String[] nestedElements;
    private final String referenceAttribute;

    public RedissonNestedElementAwareDecorator(String[] nestedElements, String referenceAttribute) {
        this.nestedElements = nestedElements;
        this.referenceAttribute = referenceAttribute;
    }

    @Override
    public void decorate(Element element, ParserContext parserContext, BeanDefinitionBuilder builder, RedissonNamespaceParserSupport helper) {
        for (String nestedElement : this.nestedElements) {
            this.parseNested(element, nestedElement, parserContext, builder, helper);
        }
    }

    private void parseNested(Element element, String eltType, ParserContext parserContext, BeanDefinitionBuilder builder, RedissonNamespaceParserSupport helper) {
        NodeList list = element.getElementsByTagNameNS("http://redisson.org/schema/redisson", eltType);
        if (list.getLength() == 1) {
            Element elt = (Element)list.item(0);
            if (StringUtils.hasText(this.referenceAttribute)) {
                helper.setAttribute(elt, this.referenceAttribute, helper.getAttribute(element, "id"));
                helper.setAttribute(elt, "redisson-ref", helper.getAttribute(element, "redisson-ref"));
            }
            parserContext.getDelegate().parseCustomElement(elt, builder.getRawBeanDefinition());
        }
    }
}

