/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.transaction;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.redisson.RedissonObject;
import org.redisson.RedissonSet;
import org.redisson.ScanResult;
import org.redisson.api.RCollectionAsync;
import org.redisson.api.RFuture;
import org.redisson.api.RLock;
import org.redisson.api.RObject;
import org.redisson.api.SortOrder;
import org.redisson.client.RedisClient;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.misc.CompletableFutureWrapper;
import org.redisson.misc.Hash;
import org.redisson.misc.HashValue;
import org.redisson.transaction.BaseTransactionalObject;
import org.redisson.transaction.RedissonTransactionalLock;
import org.redisson.transaction.operation.ClearExpireOperation;
import org.redisson.transaction.operation.DeleteOperation;
import org.redisson.transaction.operation.ExpireAtOperation;
import org.redisson.transaction.operation.ExpireOperation;
import org.redisson.transaction.operation.TouchOperation;
import org.redisson.transaction.operation.TransactionalOperation;
import org.redisson.transaction.operation.UnlinkOperation;
import org.redisson.transaction.operation.set.MoveOperation;

public abstract class BaseTransactionalSet<V>
extends BaseTransactionalObject {
    static final Object NULL = new Object();
    private final long timeout;
    final Map<HashValue, Object> state = new HashMap<HashValue, Object>();
    final List<TransactionalOperation> operations;
    final RCollectionAsync<V> set;
    final RObject object;
    final String name;
    Boolean deleted;
    boolean hasExpiration;

    public BaseTransactionalSet(CommandAsyncExecutor commandExecutor, long timeout, List<TransactionalOperation> operations, RCollectionAsync<V> set, String transactionId) {
        super(transactionId, BaseTransactionalSet.getLockName(((RObject)((Object)set)).getName()), commandExecutor);
        this.timeout = timeout;
        this.operations = operations;
        this.set = set;
        this.object = (RObject)((Object)set);
        this.name = this.object.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HashValue toHash(Object value) {
        ByteBuf state = ((RedissonObject)((Object)this.set)).encode(value);
        try {
            HashValue hashValue = new HashValue(Hash.hash128(state));
            return hashValue;
        }
        finally {
            state.release();
        }
    }

    public RFuture<Boolean> isExistsAsync() {
        if (this.deleted != null) {
            return new CompletableFutureWrapper<Boolean>(this.deleted == false);
        }
        return this.set.isExistsAsync();
    }

    public RFuture<Boolean> unlinkAsync() {
        long currentThreadId = Thread.currentThread().getId();
        return this.deleteAsync(new UnlinkOperation(this.name, null, this.lockName, currentThreadId, this.transactionId));
    }

    public RFuture<Boolean> touchAsync() {
        long currentThreadId = Thread.currentThread().getId();
        return this.executeLocked(this.timeout, () -> {
            if (this.deleted != null && this.deleted.booleanValue()) {
                this.operations.add(new TouchOperation(this.name, null, this.lockName, currentThreadId, this.transactionId));
                return new CompletableFutureWrapper<Boolean>(false);
            }
            return this.set.isExistsAsync().thenApply(exists -> {
                this.operations.add(new TouchOperation(this.name, null, this.lockName, currentThreadId, this.transactionId));
                if (!exists.booleanValue()) {
                    return this.isExists();
                }
                return true;
            });
        }, this.getWriteLock());
    }

    public RFuture<Boolean> deleteAsync() {
        long currentThreadId = Thread.currentThread().getId();
        return this.deleteAsync(new DeleteOperation(this.name, null, this.lockName, this.transactionId, currentThreadId));
    }

    protected RFuture<Boolean> deleteAsync(TransactionalOperation operation) {
        return this.executeLocked(this.timeout, () -> {
            if (this.deleted != null) {
                this.operations.add(operation);
                CompletableFuture<Boolean> result = new CompletableFuture<Boolean>();
                result.complete(this.deleted == false);
                this.deleted = true;
                return result;
            }
            return this.set.isExistsAsync().thenApply(res -> {
                this.operations.add(operation);
                this.state.replaceAll((k, v) -> NULL);
                this.deleted = true;
                return res;
            });
        }, this.getWriteLock());
    }

    public RFuture<Boolean> containsAsync(Object value) {
        for (Object val : this.state.values()) {
            if (val == NULL || !this.isEqual(val, value)) continue;
            return new CompletableFutureWrapper<Boolean>(true);
        }
        return this.set.containsAsync(value);
    }

    protected abstract ScanResult<Object> scanIteratorSource(String var1, RedisClient var2, String var3, String var4, int var5);

    protected ScanResult<Object> scanIterator(String name, RedisClient client, String startPos, String pattern, int count) {
        ScanResult<Object> res = this.scanIteratorSource(name, client, startPos, pattern, count);
        HashMap<HashValue, Object> newstate = new HashMap<HashValue, Object>(this.state);
        Iterator<Object> iterator = res.getValues().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Object value = newstate.remove(this.toHash(entry));
            if (value != NULL) continue;
            iterator.remove();
        }
        if ("0".equals(startPos)) {
            for (Map.Entry entry : newstate.entrySet()) {
                if (entry.getValue() == NULL) continue;
                res.getValues().add(entry.getValue());
            }
        }
        return res;
    }

    protected abstract RFuture<Set<V>> readAllAsyncSource();

    public RFuture<Set<V>> readAllAsync() {
        RFuture<Set<V>> future = this.readAllAsyncSource();
        CompletionStage<Set> f = future.thenApply(res -> {
            HashMap<HashValue, Object> newstate = new HashMap<HashValue, Object>(this.state);
            Iterator iterator = res.iterator();
            while (iterator.hasNext()) {
                Object key = iterator.next();
                Object value = newstate.remove(this.toHash(key));
                if (value != NULL) continue;
                iterator.remove();
            }
            for (Object value : newstate.values()) {
                if (value == NULL) continue;
                res.add(value);
            }
            return res;
        });
        return new CompletableFutureWrapper<Set<V>>(f);
    }

    public RFuture<Boolean> addAsync(V value) {
        long threadId = Thread.currentThread().getId();
        TransactionalOperation operation = this.createAddOperation(value, threadId);
        return this.addAsync(value, operation);
    }

    public RFuture<Boolean> addAsync(V value, TransactionalOperation operation) {
        return this.executeLocked(value, () -> {
            HashValue keyHash = this.toHash(value);
            Object entry = this.state.get(keyHash);
            if (entry != null) {
                this.operations.add(operation);
                this.state.put(keyHash, value);
                if (this.deleted != null) {
                    this.deleted = false;
                }
                return CompletableFuture.completedFuture(entry == NULL);
            }
            return this.set.containsAsync(value).thenApply(res -> {
                this.operations.add(operation);
                this.state.put(keyHash, value);
                if (this.deleted != null) {
                    this.deleted = false;
                }
                return res == false;
            });
        });
    }

    protected abstract TransactionalOperation createAddOperation(V var1, long var2);

    public RFuture<V> removeRandomAsync() {
        throw new UnsupportedOperationException();
    }

    public RFuture<Set<V>> removeRandomAsync(int amount) {
        throw new UnsupportedOperationException();
    }

    public RFuture<Boolean> moveAsync(String destination, V value) {
        RedissonSet destinationSet = new RedissonSet(this.object.getCodec(), this.commandExecutor, destination, null);
        RLock destinationLock = this.getLock(destinationSet, value);
        RLock lock = this.getLock(this.set, value);
        List<RLock> locks = Arrays.asList(destinationLock, lock);
        long threadId = Thread.currentThread().getId();
        return this.executeLocked(this.timeout, () -> {
            HashValue keyHash = this.toHash(value);
            Object currentValue = this.state.get(keyHash);
            if (currentValue != null) {
                this.operations.add(this.createMoveOperation(destination, value, threadId));
                if (currentValue == NULL) {
                    return CompletableFuture.completedFuture(false);
                }
                this.state.put(keyHash, NULL);
                return CompletableFuture.completedFuture(true);
            }
            return this.set.containsAsync(value).thenApply(r -> {
                this.operations.add(this.createMoveOperation(destination, value, threadId));
                if (r.booleanValue()) {
                    this.state.put(keyHash, NULL);
                }
                return r;
            });
        }, locks);
    }

    protected abstract MoveOperation createMoveOperation(String var1, V var2, long var3);

    private RLock getLock(RCollectionAsync<V> set, V value) {
        String lockName = ((RedissonObject)((Object)set)).getLockByValue(value, "lock");
        return new RedissonTransactionalLock(this.commandExecutor, lockName, this.transactionId);
    }

    public RFuture<Boolean> removeAsync(Object value) {
        long threadId = Thread.currentThread().getId();
        return this.executeLocked(value, () -> {
            HashValue keyHash = this.toHash(value);
            Object currentValue = this.state.get(keyHash);
            if (currentValue != null) {
                this.operations.add(this.createRemoveOperation(value, threadId));
                if (currentValue == NULL) {
                    return CompletableFuture.completedFuture(false);
                }
                this.state.put(keyHash, NULL);
                return CompletableFuture.completedFuture(true);
            }
            return this.set.containsAsync(value).thenApply(res -> {
                this.operations.add(this.createRemoveOperation(value, threadId));
                if (res.booleanValue()) {
                    this.state.put(keyHash, NULL);
                }
                return res;
            });
        });
    }

    protected abstract TransactionalOperation createRemoveOperation(Object var1, long var2);

    public RFuture<Boolean> containsAllAsync(Collection<?> c) {
        ArrayList coll = new ArrayList(c);
        Iterator iterator = coll.iterator();
        block0: while (iterator.hasNext()) {
            Object value = iterator.next();
            for (Object val : this.state.values()) {
                if (val == NULL || !this.isEqual(val, value)) continue;
                iterator.remove();
                continue block0;
            }
        }
        return this.set.containsAllAsync(coll);
    }

    public RFuture<Boolean> addAllAsync(Collection<? extends V> c) {
        long threadId = Thread.currentThread().getId();
        return this.executeLocked(() -> this.containsAllAsync(c).thenApply(res -> {
            for (Object value : c) {
                this.operations.add(this.createAddOperation(value, threadId));
                HashValue keyHash = this.toHash(value);
                this.state.put(keyHash, value);
            }
            if (this.deleted != null) {
                this.deleted = false;
            }
            return res == false;
        }), c);
    }

    public RFuture<Boolean> retainAllAsync(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    public RFuture<Boolean> removeAllAsync(Collection<?> c) {
        long threadId = Thread.currentThread().getId();
        return this.executeLocked(() -> this.containsAllAsync(c).thenApply(res -> {
            for (Object value : c) {
                this.operations.add(this.createRemoveOperation(value, threadId));
                HashValue keyHash = this.toHash(value);
                this.state.put(keyHash, NULL);
            }
            return res == false;
        }), c);
    }

    public RFuture<Integer> unionAsync(String ... names) {
        throw new UnsupportedOperationException();
    }

    public RFuture<Integer> diffAsync(String ... names) {
        throw new UnsupportedOperationException();
    }

    public RFuture<Integer> intersectionAsync(String ... names) {
        throw new UnsupportedOperationException();
    }

    public RFuture<Set<V>> readSortAsync(SortOrder order) {
        throw new UnsupportedOperationException();
    }

    public RFuture<Set<V>> readSortAsync(SortOrder order, int offset, int count) {
        throw new UnsupportedOperationException();
    }

    public RFuture<Set<V>> readSortAsync(String byPattern, SortOrder order) {
        throw new UnsupportedOperationException();
    }

    public <T> RFuture<Collection<T>> readSortAsync(String byPattern, List<String> getPatterns, SortOrder order, int offset, int count) {
        throw new UnsupportedOperationException();
    }

    public RFuture<Set<V>> readSortAlphaAsync(SortOrder order) {
        throw new UnsupportedOperationException();
    }

    public RFuture<Set<V>> readSortAlphaAsync(SortOrder order, int offset, int count) {
        throw new UnsupportedOperationException();
    }

    public RFuture<Set<V>> readSortAlphaAsync(String byPattern, SortOrder order) {
        throw new UnsupportedOperationException();
    }

    public RFuture<Set<V>> readSortAlphaAsync(String byPattern, SortOrder order, int offset, int count) {
        throw new UnsupportedOperationException();
    }

    public <T> RFuture<Collection<T>> readSortAlphaAsync(String byPattern, List<String> getPatterns, SortOrder order) {
        throw new UnsupportedOperationException();
    }

    public <T> RFuture<Collection<T>> readSortAlphaAsync(String byPattern, List<String> getPatterns, SortOrder order, int offset, int count) {
        throw new UnsupportedOperationException();
    }

    public RFuture<Integer> sortToAsync(String destName, String byPattern, List<String> getPatterns, SortOrder order, int offset, int count) {
        throw new UnsupportedOperationException();
    }

    public RFuture<Set<V>> readUnionAsync(String ... names) {
        throw new UnsupportedOperationException();
    }

    public RFuture<Set<V>> readDiffAsync(String ... names) {
        throw new UnsupportedOperationException();
    }

    public RFuture<Set<V>> readIntersectionAsync(String ... names) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isEqual(Object value, Object oldValue) {
        ByteBuf valueBuf = ((RedissonObject)((Object)this.set)).encode(value);
        ByteBuf oldValueBuf = ((RedissonObject)((Object)this.set)).encode(oldValue);
        try {
            boolean bl = valueBuf.equals(oldValueBuf);
            return bl;
        }
        finally {
            valueBuf.readableBytes();
            oldValueBuf.readableBytes();
        }
    }

    protected <R> RFuture<R> executeLocked(Object value, Supplier<CompletionStage<R>> runnable) {
        RLock lock = this.getLock(this.set, value);
        long threadId = Thread.currentThread().getId();
        return this.executeLocked(threadId, this.timeout, () -> this.executeLocked(threadId, this.timeout, runnable, lock), this.getReadLock());
    }

    protected <R> RFuture<R> executeLocked(Supplier<CompletionStage<R>> runnable, Collection<?> values) {
        ArrayList<RLock> locks = new ArrayList<RLock>(values.size());
        for (Object value : values) {
            RLock lock = this.getLock(this.set, value);
            locks.add(lock);
        }
        return this.executeLocked(this.timeout, runnable, locks);
    }

    public RFuture<Boolean> clearExpireAsync() {
        long currentThreadId = Thread.currentThread().getId();
        return this.executeLocked(this.timeout, () -> {
            if (this.hasExpiration) {
                this.operations.add(new ClearExpireOperation(this.name, null, this.lockName, currentThreadId, this.transactionId));
                this.hasExpiration = false;
                return CompletableFuture.completedFuture(true);
            }
            return this.set.remainTimeToLiveAsync().thenApply(res -> {
                this.operations.add(new ClearExpireOperation(this.name, null, this.lockName, currentThreadId, this.transactionId));
                this.hasExpiration = false;
                return res > 0L;
            });
        }, this.getWriteLock());
    }

    private boolean isExists() {
        boolean notExists = this.state.values().stream().noneMatch(v -> v != NULL);
        return !notExists;
    }

    public RFuture<Boolean> expireAsync(long timeToLive, TimeUnit timeUnit, String param, String ... keys) {
        long currentThreadId = Thread.currentThread().getId();
        return this.executeLocked(this.timeout, () -> {
            if (this.isExists()) {
                this.operations.add(new ExpireOperation(this.name, null, this.lockName, currentThreadId, this.transactionId, timeToLive, timeUnit, param, keys));
                this.hasExpiration = true;
                return CompletableFuture.completedFuture(true);
            }
            return this.isExistsAsync().thenApply(res -> {
                this.operations.add(new ExpireOperation(this.name, null, this.lockName, currentThreadId, this.transactionId, timeToLive, timeUnit, param, keys));
                this.hasExpiration = res;
                return res;
            });
        }, this.getWriteLock());
    }

    public RFuture<Boolean> expireAtAsync(long timestamp, String param, String ... keys) {
        long currentThreadId = Thread.currentThread().getId();
        return this.executeLocked(this.timeout, () -> {
            if (this.isExists()) {
                this.operations.add(new ExpireAtOperation(this.name, null, this.lockName, currentThreadId, this.transactionId, timestamp, param, keys));
                this.hasExpiration = true;
                return CompletableFuture.completedFuture(true);
            }
            return this.isExistsAsync().thenApply(res -> {
                this.operations.add(new ExpireAtOperation(this.name, null, this.lockName, currentThreadId, this.transactionId, timestamp, param, keys));
                this.hasExpiration = res;
                return res;
            });
        }, this.getWriteLock());
    }
}

