/*
 * Decompiled with CFR 0.152.
 */
package cn.bugstack.wrench.rate.limiter.aop;

import cn.bugstack.wrench.dynamic.config.center.types.annotations.DCCValue;
import cn.bugstack.wrench.rate.limiter.types.annotations.RateLimiterAccessInterceptor;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.util.concurrent.RateLimiter;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Aspect
public class RateLimiterAOP {
    private final Logger log = LoggerFactory.getLogger(RateLimiterAOP.class);
    @DCCValue(value="rateLimiterSwitch:open")
    private String rateLimiterSwitch;
    private final Cache<String, RateLimiter> loginRecord = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.MINUTES).build();
    private final Cache<String, Long> blacklist = CacheBuilder.newBuilder().expireAfterWrite(24L, TimeUnit.HOURS).build();

    @Pointcut(value="@annotation(cn.bugstack.wrench.rate.limiter.types.annotations.RateLimiterAccessInterceptor)")
    public void aopPoint() {
    }

    @Around(value="aopPoint() && @annotation(rateLimiterAccessInterceptor)")
    public Object doRouter(ProceedingJoinPoint jp, RateLimiterAccessInterceptor rateLimiterAccessInterceptor) throws Throwable {
        if (StringUtils.isBlank(this.rateLimiterSwitch) || "close".equals(this.rateLimiterSwitch)) {
            return jp.proceed();
        }
        String key = rateLimiterAccessInterceptor.key();
        if (StringUtils.isBlank(key)) {
            throw new RuntimeException("annotation RateLimiter uId is null\uff01");
        }
        String keyAttr = this.getAttrValue(key, jp.getArgs());
        this.log.info("aop attr {}", (Object)keyAttr);
        if (!"all".equals(keyAttr) && rateLimiterAccessInterceptor.blacklistCount() != 0.0 && null != this.blacklist.getIfPresent(keyAttr) && (double)this.blacklist.getIfPresent(keyAttr).longValue() > rateLimiterAccessInterceptor.blacklistCount()) {
            this.log.info("\u9650\u6d41-\u9ed1\u540d\u5355\u62e6\u622a(24h)\uff1a{}", (Object)keyAttr);
            return this.fallbackMethodResult(jp, rateLimiterAccessInterceptor.fallbackMethod());
        }
        RateLimiter rateLimiter = this.loginRecord.getIfPresent(keyAttr);
        if (null == rateLimiter) {
            rateLimiter = RateLimiter.create(rateLimiterAccessInterceptor.permitsPerSecond());
            this.loginRecord.put(keyAttr, rateLimiter);
        }
        if (!rateLimiter.tryAcquire()) {
            if (rateLimiterAccessInterceptor.blacklistCount() != 0.0) {
                if (null == this.blacklist.getIfPresent(keyAttr)) {
                    this.blacklist.put(keyAttr, 1L);
                } else {
                    this.blacklist.put(keyAttr, this.blacklist.getIfPresent(keyAttr) + 1L);
                }
            }
            this.log.info("\u9650\u6d41-\u8d85\u9891\u6b21\u62e6\u622a\uff1a{}", (Object)keyAttr);
            return this.fallbackMethodResult(jp, rateLimiterAccessInterceptor.fallbackMethod());
        }
        return jp.proceed();
    }

    private Object fallbackMethodResult(JoinPoint jp, String fallbackMethod) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Signature sig = jp.getSignature();
        MethodSignature methodSignature = (MethodSignature)sig;
        Method method = jp.getTarget().getClass().getMethod(fallbackMethod, methodSignature.getParameterTypes());
        return method.invoke(jp.getThis(), jp.getArgs());
    }

    public String getAttrValue(String attr, Object[] args) {
        if (args[0] instanceof String) {
            return args[0].toString();
        }
        String filedValue = null;
        for (Object arg : args) {
            try {
                if (StringUtils.isNotBlank(filedValue)) break;
                filedValue = String.valueOf(this.getValueByName(arg, attr));
            }
            catch (Exception e) {
                this.log.error("\u83b7\u53d6\u8def\u7531\u5c5e\u6027\u503c\u5931\u8d25 attr\uff1a{}", (Object)attr, (Object)e);
            }
        }
        return filedValue;
    }

    private Object getValueByName(Object item, String name) {
        try {
            Field field = this.getFieldByName(item, name);
            if (field == null) {
                return null;
            }
            field.setAccessible(true);
            Object o = field.get(item);
            field.setAccessible(false);
            return o;
        }
        catch (IllegalAccessException e) {
            return null;
        }
    }

    private Field getFieldByName(Object item, String name) {
        try {
            Field field;
            try {
                field = item.getClass().getDeclaredField(name);
            }
            catch (NoSuchFieldException e) {
                field = item.getClass().getSuperclass().getDeclaredField(name);
            }
            return field;
        }
        catch (NoSuchFieldException e) {
            return null;
        }
    }
}

