/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.captcha.generator;

import cn.hutool.captcha.generator.CodeGenerator;
import cn.hutool.core.math.Calculator;
import cn.hutool.core.util.RandomUtil;
import cn.hutool.core.util.StrUtil;

public class MathGenerator
implements CodeGenerator {
    private static final long serialVersionUID = -5514819971774091076L;
    private static final String operators = "+-*";
    private final int numberLength;

    public MathGenerator() {
        this(2);
    }

    public MathGenerator(int numberLength) {
        this.numberLength = numberLength;
    }

    @Override
    public String generate() {
        int limit = this.getLimit();
        String number1 = Integer.toString(RandomUtil.randomInt((int)limit));
        String number2 = Integer.toString(RandomUtil.randomInt((int)limit));
        number1 = StrUtil.padAfter((CharSequence)number1, (int)this.numberLength, (char)' ');
        number2 = StrUtil.padAfter((CharSequence)number2, (int)this.numberLength, (char)' ');
        return StrUtil.builder().append(number1).append(RandomUtil.randomChar((String)operators)).append(number2).append('=').toString();
    }

    @Override
    public boolean verify(String code, String userInputCode) {
        int result;
        try {
            result = Integer.parseInt(userInputCode);
        }
        catch (NumberFormatException e) {
            return false;
        }
        int calculateResult = (int)Calculator.conversion((String)code);
        return result == calculateResult;
    }

    public int getLength() {
        return this.numberLength * 2 + 2;
    }

    private int getLimit() {
        return Integer.parseInt("1" + StrUtil.repeat((char)'0', (int)this.numberLength));
    }
}

