/*
 * Decompiled with CFR 0.152.
 */
package cn.idev.excel.metadata.property;

import cn.idev.excel.enums.HeadKindEnum;
import cn.idev.excel.metadata.ConfigurationHolder;
import cn.idev.excel.metadata.FieldCache;
import cn.idev.excel.metadata.FieldWrapper;
import cn.idev.excel.metadata.Head;
import cn.idev.excel.util.ClassUtils;
import cn.idev.excel.util.StringUtils;
import cn.idev.excel.write.metadata.holder.AbstractWriteHolder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcelHeadProperty {
    private static final Logger log = LoggerFactory.getLogger(ExcelHeadProperty.class);
    private Class<?> headClazz;
    private HeadKindEnum headKind;
    private int headRowNumber;
    private Map<Integer, Head> headMap;

    public ExcelHeadProperty(ConfigurationHolder configurationHolder, Class<?> headClazz, List<List<String>> head) {
        this.headClazz = headClazz;
        this.headMap = new TreeMap<Integer, Head>();
        this.headKind = HeadKindEnum.NONE;
        this.headRowNumber = 0;
        if (head != null && !head.isEmpty()) {
            int headIndex = 0;
            for (int i = 0; i < head.size(); ++i) {
                if (configurationHolder instanceof AbstractWriteHolder && ((AbstractWriteHolder)configurationHolder).ignore(null, i)) continue;
                this.headMap.put(headIndex, new Head(headIndex, null, null, head.get(i), Boolean.FALSE, Boolean.TRUE));
                ++headIndex;
            }
            this.headKind = HeadKindEnum.STRING;
        }
        this.initColumnProperties(configurationHolder);
        this.initHeadRowNumber();
        if (log.isDebugEnabled()) {
            log.debug("The initialization sheet/table 'ExcelHeadProperty' is complete , head kind is {}", (Object)this.headKind);
        }
    }

    private void initHeadRowNumber() {
        List<String> list;
        this.headRowNumber = 0;
        for (Head head : this.headMap.values()) {
            list = head.getHeadNameList();
            if (list == null || list.size() <= this.headRowNumber) continue;
            this.headRowNumber = list.size();
        }
        for (Head head : this.headMap.values()) {
            list = head.getHeadNameList();
            if (list == null || list.isEmpty() || list.size() >= this.headRowNumber) continue;
            int lack = this.headRowNumber - list.size();
            int last = list.size() - 1;
            for (int i = 0; i < lack; ++i) {
                list.add(list.get(last));
            }
        }
    }

    private void initColumnProperties(ConfigurationHolder configurationHolder) {
        if (this.headClazz == null) {
            return;
        }
        FieldCache fieldCache = ClassUtils.declaredFields(this.headClazz, configurationHolder);
        for (Map.Entry<Integer, FieldWrapper> entry : fieldCache.getSortedFieldMap().entrySet()) {
            this.initOneColumnProperty(entry.getKey(), entry.getValue(), fieldCache.getIndexFieldMap().containsKey(entry.getKey()));
        }
        this.headKind = HeadKindEnum.CLASS;
    }

    private void initOneColumnProperty(int index, FieldWrapper field, Boolean forceIndex) {
        boolean notForceName;
        ArrayList<String> tmpHeadList = new ArrayList<String>();
        boolean bl = notForceName = field.getHeads() == null || field.getHeads().length == 0 || field.getHeads().length == 1 && StringUtils.isEmpty(field.getHeads()[0]);
        if (this.headMap.containsKey(index)) {
            tmpHeadList.addAll(this.headMap.get(index).getHeadNameList());
        } else if (notForceName) {
            tmpHeadList.add(field.getFieldName());
        } else {
            Collections.addAll(tmpHeadList, field.getHeads());
        }
        Head head = new Head(index, field.getField(), field.getFieldName(), tmpHeadList, forceIndex, !notForceName);
        this.headMap.put(index, head);
    }

    public boolean hasHead() {
        return this.headKind != HeadKindEnum.NONE;
    }

    public Class<?> getHeadClazz() {
        return this.headClazz;
    }

    public HeadKindEnum getHeadKind() {
        return this.headKind;
    }

    public int getHeadRowNumber() {
        return this.headRowNumber;
    }

    public Map<Integer, Head> getHeadMap() {
        return this.headMap;
    }

    public void setHeadClazz(Class<?> headClazz) {
        this.headClazz = headClazz;
    }

    public void setHeadKind(HeadKindEnum headKind) {
        this.headKind = headKind;
    }

    public void setHeadRowNumber(int headRowNumber) {
        this.headRowNumber = headRowNumber;
    }

    public void setHeadMap(Map<Integer, Head> headMap) {
        this.headMap = headMap;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExcelHeadProperty)) {
            return false;
        }
        ExcelHeadProperty other = (ExcelHeadProperty)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getHeadRowNumber() != other.getHeadRowNumber()) {
            return false;
        }
        Class<?> this$headClazz = this.getHeadClazz();
        Class<?> other$headClazz = other.getHeadClazz();
        if (this$headClazz == null ? other$headClazz != null : !this$headClazz.equals(other$headClazz)) {
            return false;
        }
        HeadKindEnum this$headKind = this.getHeadKind();
        HeadKindEnum other$headKind = other.getHeadKind();
        if (this$headKind == null ? other$headKind != null : !((Object)((Object)this$headKind)).equals((Object)other$headKind)) {
            return false;
        }
        Map<Integer, Head> this$headMap = this.getHeadMap();
        Map<Integer, Head> other$headMap = other.getHeadMap();
        return !(this$headMap == null ? other$headMap != null : !((Object)this$headMap).equals(other$headMap));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ExcelHeadProperty;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getHeadRowNumber();
        Class<?> $headClazz = this.getHeadClazz();
        result = result * 59 + ($headClazz == null ? 43 : $headClazz.hashCode());
        HeadKindEnum $headKind = this.getHeadKind();
        result = result * 59 + ($headKind == null ? 43 : ((Object)((Object)$headKind)).hashCode());
        Map<Integer, Head> $headMap = this.getHeadMap();
        result = result * 59 + ($headMap == null ? 43 : ((Object)$headMap).hashCode());
        return result;
    }
}

