/*
 * Decompiled with CFR 0.152.
 */
package cn.jpush.api;

import cn.jpush.api.common.DeviceEnum;
import cn.jpush.api.push.CustomMessageParams;
import cn.jpush.api.push.MessageResult;
import cn.jpush.api.push.NotificationParams;
import cn.jpush.api.push.PushClient;
import cn.jpush.api.push.ReceiverTypeEnum;
import cn.jpush.api.report.ReceivedsResult;
import cn.jpush.api.report.ReportClient;
import java.util.Map;

public class JPushClient {
    private PushClient _pushClient;
    private ReportClient _reportClient;

    public JPushClient(String masterSecret, String appKey) {
        this(masterSecret, appKey, -1L, null, true);
    }

    public JPushClient(String masterSecret, String appKey, long timeToLive, DeviceEnum device, boolean apnsProduction) {
        this._pushClient = new PushClient(masterSecret, appKey, timeToLive, device, apnsProduction);
        this._reportClient = new ReportClient(masterSecret, appKey);
    }

    public MessageResult sendNotification(String notificationContent, NotificationParams params, Map<String, Object> extras) {
        return this._pushClient.sendNotification(notificationContent, params, extras);
    }

    public MessageResult sendCustomMessage(String msgTitle, String msgContent, CustomMessageParams params, Map<String, Object> extras) {
        return this._pushClient.sendCustomMessage(msgTitle, msgContent, params, extras);
    }

    public MessageResult sendCustomMessageAll(String msgTitle, String msgContent) {
        CustomMessageParams params = new CustomMessageParams();
        params.setReceiverType(ReceiverTypeEnum.APP_KEY);
        return this._pushClient.sendCustomMessage(msgTitle, msgContent, params, null);
    }

    public MessageResult sendNotificationAll(String notificationContent) {
        NotificationParams params = new NotificationParams();
        params.setReceiverType(ReceiverTypeEnum.APP_KEY);
        return this._pushClient.sendNotification(notificationContent, params, null);
    }

    public ReceivedsResult getReportReceiveds(String msgIds) {
        return this._reportClient.getReceiveds(msgIds);
    }
}

