/*
 * Decompiled with CFR 0.152.
 */
package cn.jpush.api.report;

import cn.jpush.api.common.BaseHttpClient;
import cn.jpush.api.common.ResponseResult;
import cn.jpush.api.common.ValidateRequestParams;
import cn.jpush.api.report.ReceivedsResult;
import cn.jpush.api.utils.StringUtils;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.List;

public class ReportClient
extends BaseHttpClient {
    private static final String REPORT_HOST_NAME = "https://report.jpush.cn";
    private static final String REPORT_RECEIVE_PATH = "/v2/received";
    private static Gson _gson = new Gson();
    private String _appKey;
    private String _masterSecret;

    public ReportClient(String masterSecret, String appKey) {
        this._masterSecret = masterSecret;
        this._appKey = appKey;
    }

    public ReceivedsResult getReceiveds(String[] msgIdArray) {
        return this.getReceiveds(StringUtils.arrayToString(msgIdArray));
    }

    public ReceivedsResult getReceiveds(String msgIds) {
        String authCode = ReportClient.getAuthorizationBase64(this._appKey, this._masterSecret);
        return this.getResportReceived(msgIds, authCode);
    }

    public ReceivedsResult getResportReceived(String msgIds, String authCode) {
        ValidateRequestParams.checkReportParams(this._appKey, this._masterSecret, msgIds);
        String url = "https://report.jpush.cn/v2/received?msg_ids=" + msgIds;
        ResponseResult result = this.sendGet(url, true, null, authCode);
        ReceivedsResult receivedsResult = new ReceivedsResult();
        if (result.responseCode == 200) {
            Type listType = new TypeToken<List<ReceivedsResult.Received>>(){}.getType();
            receivedsResult.receivedList = (List)_gson.fromJson(result.responseContent, listType);
        }
        receivedsResult.responseResult = result;
        return receivedsResult;
    }
}

