/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.io.serialization;

import co.paralleluniverse.io.serialization.ByteArraySerializer;
import co.paralleluniverse.io.serialization.IOStreamSerializer;
import co.paralleluniverse.io.serialization.WriteReplace;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public final class JDKSerializer
implements ByteArraySerializer,
IOStreamSerializer {
    private final List<WriteReplaceEntry> writeReplace = new CopyOnWriteArrayList<WriteReplaceEntry>();

    public void registerWriteReplace(Class<?> clazz, WriteReplace wr) {
        this.writeReplace.add(new WriteReplaceEntry(clazz, wr));
    }

    @Override
    public byte[] write(Object object) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(this.writeReplace(object));
            oos.close();
            return baos.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private Object writeReplace(Object object) {
        for (WriteReplaceEntry entry : this.writeReplace) {
            if (!entry.clazz.isInstance(object)) continue;
            return entry.writeReplace.writeReplace(object);
        }
        return object;
    }

    @Override
    public Object read(byte[] buf) {
        return this.read(buf, 0);
    }

    @Override
    public Object read(byte[] buf, int offset) {
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(buf, offset, buf.length - offset);
            ObjectInputStream ois = new ObjectInputStream(bais);
            Object obj = ois.readObject();
            return obj;
        }
        catch (IOException | ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void write(OutputStream os, Object object) throws IOException {
        ObjectOutput oo = JDKSerializer.toObjectOutput(os);
        oo.writeObject(object);
    }

    @Override
    public Object read(InputStream is) throws IOException {
        try {
            ObjectInput oi = JDKSerializer.toObjectInput(is);
            return oi.readObject();
        }
        catch (ClassNotFoundException e) {
            throw new IOException(e);
        }
    }

    public static DataOutput toDataOutput(OutputStream os) {
        if (os instanceof DataOutput) {
            return (DataOutput)((Object)os);
        }
        return new DataOutputStream(os);
    }

    public static ObjectOutput toObjectOutput(OutputStream os) throws IOException {
        if (os instanceof ObjectOutput) {
            return (ObjectOutput)((Object)os);
        }
        return new ObjectOutputStream(os);
    }

    public static DataInput toDataInput(InputStream is) {
        if (is instanceof DataInput) {
            return (DataInput)((Object)is);
        }
        return new DataInputStream(is);
    }

    public static ObjectInput toObjectInput(InputStream is) throws IOException {
        if (is instanceof ObjectInput) {
            return (ObjectInput)((Object)is);
        }
        return new ObjectInputStream(is);
    }

    static class WriteReplaceEntry {
        final Class<?> clazz;
        final WriteReplace writeReplace;

        public WriteReplaceEntry(Class<?> clazz, WriteReplace writeReplace) {
            this.clazz = clazz;
            this.writeReplace = writeReplace;
        }
    }
}

