/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.strands.queues;

import co.paralleluniverse.common.util.UtilUnsafe;
import co.paralleluniverse.strands.queues.QueueIterator;
import co.paralleluniverse.strands.queues.SingleConsumerQueue;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import sun.misc.Unsafe;

abstract class SingleConsumerArrayQueue<E>
extends SingleConsumerQueue<E> {
    final int capacity;
    final int mask;
    volatile int p001;
    volatile int p002;
    volatile int p003;
    volatile int p004;
    volatile int p005;
    volatile int p006;
    volatile int p007;
    volatile long head;
    volatile long p101;
    volatile long p102;
    volatile long p103;
    volatile long p104;
    volatile long p105;
    volatile long p106;
    volatile long p107;
    volatile long tail;
    volatile long p201;
    volatile long p202;
    volatile long p203;
    volatile long p204;
    volatile long p205;
    volatile long p206;
    volatile long p207;
    int seed = (int)System.nanoTime();
    static final Unsafe UNSAFE = UtilUnsafe.getUnsafe();
    private static final long headOffset;
    private static final long tailOffset;

    SingleConsumerArrayQueue(int capacity) {
        this.capacity = SingleConsumerArrayQueue.nextPowerOfTwo(capacity);
        this.mask = this.capacity - 1;
    }

    private static int nextPowerOfTwo(int v) {
        assert (v >= 0);
        return 1 << 32 - Integer.numberOfLeadingZeros(v - 1);
    }

    @Override
    public int capacity() {
        return this.capacity;
    }

    abstract E value(int var1);

    abstract int arrayLength();

    abstract void awaitValue(long var1);

    abstract void clearValue(int var1);

    abstract void copyValue(int var1, int var2);

    long maxReadIndex() {
        return this.tail;
    }

    final long preEnq() {
        long t;
        while (true) {
            long w;
            if (this.head <= (w = (t = this.tail) - (long)this.capacity)) {
                return -1L;
            }
            if (this.compareAndSetTail(t, t + 1L)) break;
            this.backoff();
        }
        return t;
    }

    public void deq(int index) {
        assert ((long)index == (this.head & (long)this.mask));
        this.clearValue(index);
        this.orderedSetHead(this.head + 1L);
    }

    abstract boolean hasNext(long var1, int var3);

    @Override
    public boolean hasNext() {
        long h = this.head;
        return this.hasNext(h, (int)h & this.mask);
    }

    int pk() {
        long h = this.head;
        int h1 = (int)this.head & this.mask;
        if (!this.hasNext(h, h1)) {
            return -1;
        }
        return h1;
    }

    @Override
    public E poll() {
        int i = this.pk();
        if (i < 0) {
            return null;
        }
        E v = this.value(i);
        this.deq(i);
        return v;
    }

    @Override
    public E peek() {
        int i = this.pk();
        return i >= 0 ? (E)this.value(i) : null;
    }

    int succ(int index) {
        if (index < 0) {
            return this.pk();
        }
        int n1 = index + 1 & this.mask;
        long n = this.intToLongIndex(n1);
        if (!this.hasNext(n, n1)) {
            return -1;
        }
        return (int)n & this.mask;
    }

    int del(int index) {
        long i;
        if (index == ((int)this.head & this.mask)) {
            this.deq(index);
            return -1;
        }
        this.clearValue(index);
        long t = this.tail;
        if (i == t && this.compareAndSetTail(t, t - 1L)) {
            return (int)(i - 1L) & this.mask;
        }
        long h = this.head;
        for (i = this.intToLongIndex(index); i != h; --i) {
            this.copyValue((int)i & this.mask, (int)(i - 1L) & this.mask);
        }
        this.clearValue((int)(h & (long)this.mask));
        this.head = h + 1L;
        return index;
    }

    private long intToLongIndex(int index) {
        int ih = (int)this.head & this.mask;
        return this.head + (long)(index >= ih ? index - ih : index + this.capacity - ih);
    }

    @Override
    public int size() {
        return (int)(this.tail - this.head);
    }

    @Override
    public boolean isEmpty() {
        return this.tail == this.head;
    }

    @Override
    public List<E> snapshot() {
        long t = this.tail;
        ArrayList<E> list = new ArrayList<E>((int)(t - this.head));
        for (long p = this.tail; p != this.head; --p) {
            list.add(this.value((int)p & this.mask));
        }
        return Lists.reverse(list);
    }

    int next(int i) {
        return i + 1 & this.mask;
    }

    int prev(int i) {
        return --i & this.mask;
    }

    void backoff() {
        int spins = 256;
        int r = this.seed;
        while (spins >= 0) {
            r ^= r << 1;
            r ^= r >>> 3;
            if ((r ^= r << 10) < 0) continue;
            --spins;
        }
        this.seed = r;
    }

    @Override
    public QueueIterator<E> iterator() {
        return new ArrayQueueIterator();
    }

    private boolean compareAndSetTail(long expect, long update) {
        return UNSAFE.compareAndSwapLong(this, tailOffset, expect, update);
    }

    private void orderedSetHead(long value) {
        UNSAFE.putOrderedLong(this, headOffset, value);
    }

    static {
        try {
            headOffset = UNSAFE.objectFieldOffset(SingleConsumerArrayQueue.class.getDeclaredField("head"));
            tailOffset = UNSAFE.objectFieldOffset(SingleConsumerArrayQueue.class.getDeclaredField("tail"));
        }
        catch (Exception ex) {
            throw new Error(ex);
        }
    }

    class ArrayQueueIterator
    implements QueueIterator<E> {
        int n = -1;

        ArrayQueueIterator() {
        }

        @Override
        public boolean hasNext() {
            return SingleConsumerArrayQueue.this.succ(this.n) >= 0;
        }

        @Override
        public E value() {
            return SingleConsumerArrayQueue.this.value(this.n);
        }

        @Override
        public void deq() {
            SingleConsumerArrayQueue.this.deq(this.n);
        }

        @Override
        public void reset() {
            this.n = -1;
        }

        @Override
        public E next() {
            this.n = SingleConsumerArrayQueue.this.succ(this.n);
            return this.value();
        }

        @Override
        public void remove() {
            this.n = SingleConsumerArrayQueue.this.del(this.n);
        }
    }
}

