/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ageiport.common.concurrent;

import com.alibaba.ageiport.common.exception.ExceptionUtils;
import com.alibaba.ageiport.common.logger.Logger;
import com.alibaba.ageiport.common.logger.LoggerFactory;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;

public class BlockPolicyExecutionHandler
implements RejectedExecutionHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(BlockPolicyExecutionHandler.class);
    private String name;

    public BlockPolicyExecutionHandler(String name) {
        this.name = name;
    }

    @Override
    public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
        try {
            long taskCount = executor.getTaskCount();
            long completedTaskCount = executor.getCompletedTaskCount();
            long largestPoolSize = executor.getLargestPoolSize();
            long poolSize = executor.getPoolSize();
            long activeCount = executor.getActiveCount();
            LOGGER.warn("thread pool {} is full. taskCount:{}, completedTaskCount:{}, largestPoolSize:{}, poolSize:{}, activeCount:{}", this.name, taskCount, completedTaskCount, largestPoolSize, poolSize, activeCount);
            executor.getQueue().put(r);
        }
        catch (InterruptedException e) {
            ExceptionUtils.throwException(e);
        }
    }
}

