/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ageiport.common.concurrent;

import com.alibaba.ageiport.common.concurrent.BlockPolicyExecutionHandler;
import com.alibaba.ageiport.common.concurrent.ListeningDecorator;
import com.alibaba.ageiport.common.concurrent.ListeningExecutorService;
import com.alibaba.ageiport.common.concurrent.NamedThreadFactory;
import com.alibaba.ageiport.common.logger.Logger;
import com.alibaba.ageiport.common.logger.LoggerFactory;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class ThreadPoolUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(ThreadPoolUtil.class);
    private static ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(2, ThreadPoolUtil.createThreadFactory("ScheduledExecutor pool"), new BlockPolicyExecutionHandler("GEI-ScheduledExecutor pool"));

    private ThreadPoolUtil() {
    }

    public static ListeningExecutorService createListeningExecutor(String name, int corePoolSize, int maxPoolSize, BlockingQueue<Runnable> workQueue) {
        ExecutorService executorService = ThreadPoolUtil.createExecutor(name, corePoolSize, maxPoolSize, workQueue);
        ListeningDecorator listeningExecutorService = new ListeningDecorator(executorService);
        return listeningExecutorService;
    }

    public static ExecutorService createExecutor(String name, int corePoolSize, int maxPoolSize, BlockingQueue<Runnable> workQueue) {
        ThreadFactory threadFactory = ThreadPoolUtil.createThreadFactory(name);
        return new ThreadPoolExecutor(corePoolSize, maxPoolSize, 10L, TimeUnit.SECONDS, workQueue, threadFactory, new BlockPolicyExecutionHandler(name));
    }

    public static ScheduledExecutorService scheduledExecutorService() {
        return executor;
    }

    private static ThreadFactory createThreadFactory(String name) {
        return new NamedThreadFactory("AGEI-" + name, false, (t, e) -> LOGGER.error(t.getName() + " e", e));
    }
}

