/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ageiport.common.constants;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

public enum TaskStatus {
    NEW("NEW", "\u65b0\u5efa"),
    EXECUTING("EXECUTING", "\u6267\u884c\u4e2d"),
    FINISHED("FINISHED", "\u5df2\u5b8c\u6210"),
    ERROR("ERROR", "\u6267\u884c\u9519\u8bef");

    private static final Map<String, TaskStatus> ENUM_MAP;
    private String code;
    private String desc;

    public String getCode() {
        return this.code;
    }

    public String getDesc() {
        return this.desc;
    }

    private TaskStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static TaskStatus of(String code) {
        if (code == null) {
            return null;
        }
        return ENUM_MAP.get(code);
    }

    public static Boolean isFinished(String code) {
        return TaskStatus.FINISHED.code.equals(code);
    }

    public static Boolean isError(String code) {
        return TaskStatus.ERROR.code.equals(code);
    }

    public static Boolean isFinalStatus(String code) {
        return TaskStatus.isFinished(code) != false || TaskStatus.isError(code) != false;
    }

    public static Boolean isNew(String code) {
        return TaskStatus.NEW.code.equals(code);
    }

    static {
        ENUM_MAP = Arrays.stream(TaskStatus.values()).collect(Collectors.toMap(s -> s.code, s -> s));
    }
}

