/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ageiport.common.feature;

import com.alibaba.ageiport.common.feature.FeatureKey;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.Map;

public class FeatureUtils {
    private FeatureUtils() {
    }

    public static <T> T getFeature(String feature, FeatureKey<T> key) {
        JSONObject object = JSON.parseObject((String)feature);
        if (object == null) {
            return null;
        }
        return (T)object.getObject(key.getKey(), key.getClazz());
    }

    public static <T> boolean exists(String feature, FeatureKey<T> key) {
        JSONObject object = JSON.parseObject((String)feature);
        if (object == null) {
            return false;
        }
        return object.containsKey((Object)key.getKey());
    }

    public static <T> String putFeature(String feature, FeatureKey<T> key, T info) {
        JSONObject object = JSON.parseObject((String)feature);
        if (object == null) {
            object = new JSONObject();
        }
        if (key.getLength() > 0 && info instanceof String && ((String)info).length() > key.getLength()) {
            object.put(key.getKey(), (Object)(((String)info).substring(0, key.getLength()) + "......"));
            return object.toJSONString();
        }
        object.put(key.getKey(), info);
        return object.toJSONString();
    }

    public static String merge(String oldFeature, String newFeature) {
        JSONObject oldFeatureObject = JSON.parseObject((String)oldFeature);
        if (oldFeatureObject == null) {
            return newFeature;
        }
        JSONObject newFeatureObject = JSON.parseObject((String)newFeature);
        if (newFeatureObject == null) {
            return oldFeature;
        }
        for (Map.Entry e : newFeatureObject.entrySet()) {
            oldFeatureObject.put((String)e.getKey(), e.getValue());
        }
        return oldFeatureObject.toJSONString();
    }
}

