/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ageiport.common.model;

import com.alibaba.ageiport.common.exception.AbstractStandardException;
import com.alibaba.ageiport.common.model.Page;
import com.alibaba.ageiport.common.utils.StringUtils;
import java.io.Serializable;

public class Result<T>
implements Serializable {
    private static final long serialVersionUID = -8056357560350402602L;
    protected boolean success;
    protected String code;
    protected String msg;
    protected T data;

    public Result(boolean success) {
        this.success = success;
    }

    public static <T> Result<T> success(T data) {
        Result<T> result = new Result<T>(true);
        result.setData(data);
        return result;
    }

    public static <T> Result<T> faled(Throwable e, T data) {
        Result<T> faled = Result.faled(e);
        faled.setData(data);
        return faled;
    }

    public static <T> Result<T> faled(Throwable e) {
        Result<T> result = new Result<T>(false);
        if (e instanceof AbstractStandardException) {
            result.setCode(((AbstractStandardException)e).getCode());
            result.setMsg(StringUtils.isBlank(e.getMessage()) ? "no message" : e.getMessage());
        } else {
            result.setCode("unknown");
            result.setMsg(StringUtils.isBlank(e.getMessage()) ? "no message" : e.getMessage());
        }
        return result;
    }

    public static <T> Result<T> faled(String code, String msg) {
        Result<T> result = new Result<T>(false);
        result.setCode(code);
        result.setMsg(msg);
        return result;
    }

    public static <T> Result<T> faled(String code, String msg, T data) {
        Result<T> result = new Result<T>(false);
        result.setCode(code);
        result.setMsg(msg);
        result.setData(data);
        return result;
    }

    public boolean isSuccessAndNotNull() {
        return this.success && this.data != null;
    }

    public boolean isSuccessAndPageNotEmpty() {
        Page page = (Page)this.data;
        return this.success && !page.isEmpty();
    }

    public boolean isSuccess() {
        return this.success;
    }

    public String getCode() {
        return this.code;
    }

    public String getMsg() {
        return this.msg;
    }

    public T getData() {
        return this.data;
    }

    public Result<T> setSuccess(boolean success) {
        this.success = success;
        return this;
    }

    public Result<T> setCode(String code) {
        this.code = code;
        return this;
    }

    public Result<T> setMsg(String msg) {
        this.msg = msg;
        return this;
    }

    public Result<T> setData(T data) {
        this.data = data;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Result)) {
            return false;
        }
        Result other = (Result)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isSuccess() != other.isSuccess()) {
            return false;
        }
        String this$code = this.getCode();
        String other$code = other.getCode();
        if (this$code == null ? other$code != null : !this$code.equals(other$code)) {
            return false;
        }
        String this$msg = this.getMsg();
        String other$msg = other.getMsg();
        if (this$msg == null ? other$msg != null : !this$msg.equals(other$msg)) {
            return false;
        }
        T this$data = this.getData();
        T other$data = other.getData();
        return !(this$data == null ? other$data != null : !this$data.equals(other$data));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Result;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isSuccess() ? 79 : 97);
        String $code = this.getCode();
        result = result * 59 + ($code == null ? 43 : $code.hashCode());
        String $msg = this.getMsg();
        result = result * 59 + ($msg == null ? 43 : $msg.hashCode());
        T $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        return result;
    }

    public String toString() {
        return "Result(success=" + this.isSuccess() + ", code=" + this.getCode() + ", msg=" + this.getMsg() + ", data=" + this.getData() + ")";
    }
}

