/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ageiport.common.utils;

import com.alibaba.ageiport.common.utils.ArrayUtils;
import com.alibaba.ageiport.common.utils.CollectionUtils;
import com.alibaba.ageiport.common.utils.StringUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.ListableBeanFactory;

public abstract class BeanFactoryUtils {
    public static <T> T getOptionalBean(ListableBeanFactory beanFactory, String beanName, Class<T> beanType) {
        if (StringUtils.isBlank(beanName)) {
            return null;
        }
        String[] beanNames = ArrayUtils.of(beanName);
        List<T> beans = BeanFactoryUtils.getBeans(beanFactory, beanNames, beanType);
        return CollectionUtils.isEmpty(beans) ? null : (T)beans.get(0);
    }

    public static <T> List<T> getBeans(ListableBeanFactory beanFactory, String[] beanNames, Class<T> beanType) {
        if (ArrayUtils.isEmpty(beanNames)) {
            return Collections.emptyList();
        }
        String[] allBeanNames = org.springframework.beans.factory.BeanFactoryUtils.beanNamesForTypeIncludingAncestors((ListableBeanFactory)beanFactory, beanType);
        ArrayList<Object> beans = new ArrayList<Object>(beanNames.length);
        for (String beanName : beanNames) {
            if (!ArrayUtils.contains(allBeanNames, beanName)) continue;
            beans.add(beanFactory.getBean(beanName, beanType));
        }
        return Collections.unmodifiableList(beans);
    }
}

