/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ageiport.common.utils;

import com.alibaba.ageiport.common.exception.UtilException;
import com.alibaba.ageiport.common.utils.NumberUtils;
import com.alibaba.ageiport.common.utils.StringUtils;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.TemporalAccessor;
import java.util.Date;

public class DateUtils {
    public static final String PURE_DATE_PATTERN = "yyyyMMdd";
    public static final SimpleDateFormat PURE_DATE_FORMAT = new SimpleDateFormat("yyyyMMdd");
    public static final String PURE_TIME_PATTERN = "HHmmss";
    public static final SimpleDateFormat PURE_TIME_FORMAT = new SimpleDateFormat("HHmmss");
    public static final String PURE_DATETIME_PATTERN = "yyyyMMddHHmmss";
    public static final SimpleDateFormat PURE_DATETIME_FORMAT = new SimpleDateFormat("yyyyMMddHHmmss");
    public static final String PURE_DATETIME_MS_PATTERN = "yyyyMMddHHmmssSSS";
    public static final SimpleDateFormat PURE_DATETIME_MS_FORMAT = new SimpleDateFormat("yyyyMMddHHmmssSSS");
    public static final String NORM_DATE_PATTERN = "yyyy-MM-dd";
    public static final SimpleDateFormat NORM_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd");
    public static final String NORM_DATETIME_MINUTE_PATTERN = "yyyy-MM-dd HH:mm";
    public static final SimpleDateFormat NORM_DATETIME_MINUTE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm");
    public static final String NORM_DATETIME_PATTERN = "yyyy-MM-dd HH:mm:ss";
    public static final SimpleDateFormat NORM_DATETIME_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public static Date date(TemporalAccessor temporalAccessor) {
        Instant instant = DateUtils.toInstant(temporalAccessor);
        return new Date(instant.toEpochMilli());
    }

    public static Instant toInstant(TemporalAccessor temporalAccessor) {
        if (null == temporalAccessor) {
            return null;
        }
        Instant result = temporalAccessor instanceof Instant ? (Instant)temporalAccessor : (temporalAccessor instanceof LocalDateTime ? ((LocalDateTime)temporalAccessor).atZone(ZoneId.systemDefault()).toInstant() : (temporalAccessor instanceof ZonedDateTime ? ((ZonedDateTime)temporalAccessor).toInstant() : (temporalAccessor instanceof OffsetDateTime ? ((OffsetDateTime)temporalAccessor).toInstant() : (temporalAccessor instanceof LocalDate ? ((LocalDate)temporalAccessor).atStartOfDay(ZoneId.systemDefault()).toInstant() : (temporalAccessor instanceof LocalTime ? ((LocalTime)temporalAccessor).atDate(LocalDate.now()).atZone(ZoneId.systemDefault()).toInstant() : (temporalAccessor instanceof OffsetTime ? ((OffsetTime)temporalAccessor).atDate(LocalDate.now()).toInstant() : Instant.from(temporalAccessor)))))));
        return result;
    }

    public static Date parse(CharSequence dateCharSequence) {
        if (StringUtils.isBlank(dateCharSequence)) {
            return null;
        }
        String dateStr = dateCharSequence.toString();
        dateStr = StringUtils.removeAll(dateStr.trim(), '\u65e5', '\u79d2');
        int length = dateStr.length();
        if (NumberUtils.isNumber(dateStr)) {
            if (length == PURE_DATETIME_PATTERN.length()) {
                return DateUtils.parse((CharSequence)dateStr, PURE_DATETIME_FORMAT);
            }
            if (length == PURE_DATETIME_MS_PATTERN.length()) {
                return DateUtils.parse((CharSequence)dateStr, PURE_DATETIME_MS_FORMAT);
            }
            if (length == PURE_DATE_PATTERN.length()) {
                return DateUtils.parse((CharSequence)dateStr, PURE_DATE_FORMAT);
            }
            if (length == PURE_TIME_PATTERN.length()) {
                return DateUtils.parse((CharSequence)dateStr, PURE_TIME_FORMAT);
            }
        }
        if (length == NORM_DATETIME_PATTERN.length()) {
            return DateUtils.parseDateTime(dateStr);
        }
        if (length == NORM_DATE_PATTERN.length()) {
            return DateUtils.parseDate(dateStr);
        }
        if (length == NORM_DATETIME_MINUTE_PATTERN.length()) {
            return DateUtils.parse((CharSequence)dateStr, NORM_DATETIME_MINUTE_FORMAT);
        }
        throw new UtilException("No format fit for date String:" + dateStr);
    }

    private static Date parse(CharSequence dateStr, DateFormat dateFormat) {
        if (StringUtils.isBlank(dateStr)) {
            throw new UtilException("dataStr is blank");
        }
        try {
            return dateFormat.parse(dateStr.toString());
        }
        catch (Throwable e) {
            String pattern = dateFormat instanceof SimpleDateFormat ? ((SimpleDateFormat)dateFormat).toPattern() : dateFormat.toString();
            throw new UtilException(StringUtils.format("Parse [{}] with format [{}] error!", dateStr, pattern), e);
        }
    }

    public static Date parse(CharSequence dateStr, String format) {
        SimpleDateFormat fmt = new SimpleDateFormat(format);
        return DateUtils.parse(dateStr, fmt);
    }

    public static Date parseDate(CharSequence dateString) {
        return DateUtils.parse(dateString, NORM_DATE_FORMAT);
    }

    public static Date parseDateTime(CharSequence dateString) {
        return DateUtils.parse(dateString, NORM_DATETIME_FORMAT);
    }

    public static String format(Date date, DateFormat format) {
        if (null == format || null == date) {
            return null;
        }
        return format.format(date);
    }
}

