/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ageiport.common.utils;

import com.alibaba.ageiport.common.utils.StringUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class JsonUtils {
    public static <T> T getObjectFromKv(Map<String, Object> properties, String keyPrefix, Class<T> clazz) {
        String jsonStringFromKv = JsonUtils.getJsonStringFromKv(properties, keyPrefix);
        Object object = JSON.parseObject((String)jsonStringFromKv, clazz);
        return (T)object;
    }

    public static String getJsonStringFromKv(Map<String, Object> properties, String keyPrefix) {
        if (!StringUtils.endsWithIgnoreCase(keyPrefix, ".")) {
            keyPrefix = keyPrefix + ".";
        }
        HashMap<String, Object> geiProperties = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : properties.entrySet()) {
            if (!entry.getKey().startsWith(keyPrefix)) continue;
            String newKey = entry.getKey().replace(keyPrefix, "");
            geiProperties.put(newKey, entry.getValue());
        }
        String jsonStringFromKv = JsonUtils.getJsonStringFromKv(geiProperties);
        return jsonStringFromKv;
    }

    public static String getJsonStringFromKv(Map<String, Object> properties) {
        Map jsonObject = new HashMap();
        for (Map.Entry<String, Object> entry : properties.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            JSONObject jsonCur = JsonUtils.getJsonCur(key, value);
            jsonObject = JsonUtils.deepMerge(jsonObject, (Map)jsonCur);
        }
        return JSON.toJSONString(jsonObject);
    }

    private static JSONObject getJsonCur(String key, Object value) {
        JSONObject jsonObject = new JSONObject();
        String[] split = key.split("\\.");
        if (split.length == 1) {
            jsonObject.put(key, value);
            return jsonObject;
        }
        int firstIndexOfDot = key.indexOf(".");
        String restKey = key.substring(firstIndexOfDot + 1);
        JSONObject jsonCur = JsonUtils.getJsonCur(restKey, value);
        String currentKey = split[0];
        jsonObject.put(currentKey, (Object)jsonCur);
        return jsonObject;
    }

    private static Map deepMerge(Map original, Map newMap) {
        for (Object key : newMap.keySet()) {
            Object newChild;
            Object originalChild;
            if (newMap.get(key) instanceof Map && original.get(key) instanceof Map) {
                originalChild = (Map)original.get(key);
                newChild = (Map)newMap.get(key);
                original.put(key, JsonUtils.deepMerge((Map)originalChild, (Map)newChild));
                continue;
            }
            if (newMap.get(key) instanceof List && original.get(key) instanceof List) {
                originalChild = (List)original.get(key);
                newChild = (List)newMap.get(key);
                Iterator iterator = newChild.iterator();
                while (iterator.hasNext()) {
                    Object each = iterator.next();
                    if (originalChild.contains(each)) continue;
                    originalChild.add(each);
                }
                continue;
            }
            original.put(key, newMap.get(key));
        }
        return original;
    }

    public static void main(String[] args) {
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("x.a", "1");
        props.put("x.b", "2");
        props.put("x.n.a", "2");
        props.put("x.n.b", "2");
        String jsonStringFromKv = JsonUtils.getJsonStringFromKv(props);
        System.out.println(jsonStringFromKv);
    }
}

