/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ageiport.common.utils;

import com.alibaba.ageiport.common.exception.UtilException;
import com.alibaba.ageiport.common.function.Filter;
import com.alibaba.ageiport.common.utils.CollectionUtils;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;

public class NetUtils {
    private static transient String currentIp;

    public static boolean isLocalhost(String ip) {
        return "127.0.0.1".equals(ip) || "0:0:0:0:0:0:0:1".equals(ip) || "localhost".equals(ip) || "::1".equals(ip);
    }

    public static String getInstanceIp() {
        InetAddress localhost = NetUtils.getLocalhost();
        if (null != localhost) {
            return localhost.getHostAddress();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getInstanceIpWithCache() {
        if (!Objects.isNull(currentIp)) return currentIp;
        Class<NetUtils> clazz = NetUtils.class;
        synchronized (NetUtils.class) {
            if (!Objects.isNull(currentIp)) return currentIp;
            InetAddress localhost = NetUtils.getLocalhost();
            currentIp = Objects.nonNull(localhost) ? localhost.getHostAddress() : "";
            // ** MonitorExit[var0] (shouldn't be in output)
            return currentIp;
        }
    }

    public static InetAddress getLocalhost() {
        LinkedHashSet<InetAddress> localAddressList = NetUtils.localAddressList(address -> false == address.isLoopbackAddress() && false == address.isSiteLocalAddress() && address instanceof Inet4Address);
        if (CollectionUtils.isNotEmpty(localAddressList)) {
            return CollectionUtils.get(localAddressList, 0);
        }
        try {
            return InetAddress.getLocalHost();
        }
        catch (UnknownHostException unknownHostException) {
            return null;
        }
    }

    public static LinkedHashSet<String> localIps() {
        LinkedHashSet<InetAddress> localAddressList = NetUtils.localAddressList(null);
        return NetUtils.toIpList(localAddressList);
    }

    public static LinkedHashSet<String> toIpList(Set<InetAddress> addressList) {
        LinkedHashSet<String> ipSet = new LinkedHashSet<String>();
        for (InetAddress address : addressList) {
            ipSet.add(address.getHostAddress());
        }
        return ipSet;
    }

    public static LinkedHashSet<InetAddress> localAddressList(Filter<InetAddress> addressFilter) {
        Enumeration<NetworkInterface> networkInterfaces;
        try {
            networkInterfaces = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException e) {
            throw new UtilException(e.getMessage(), e);
        }
        if (networkInterfaces == null) {
            throw new UtilException("Get network interface error!");
        }
        LinkedHashSet<InetAddress> ipSet = new LinkedHashSet<InetAddress>();
        while (networkInterfaces.hasMoreElements()) {
            NetworkInterface networkInterface = networkInterfaces.nextElement();
            Enumeration<InetAddress> inetAddresses = networkInterface.getInetAddresses();
            while (inetAddresses.hasMoreElements()) {
                InetAddress inetAddress = inetAddresses.nextElement();
                if (inetAddress == null || null != addressFilter && !addressFilter.accept(inetAddress)) continue;
                ipSet.add(inetAddress);
            }
        }
        return ipSet;
    }

    public static NetworkInterface getNetworkInterface(String name) {
        Enumeration<NetworkInterface> networkInterfaces;
        try {
            networkInterfaces = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException e) {
            return null;
        }
        while (networkInterfaces.hasMoreElements()) {
            NetworkInterface netInterface = networkInterfaces.nextElement();
            if (null == netInterface || !name.equals(netInterface.getName())) continue;
            return netInterface;
        }
        return null;
    }

    public static Collection<NetworkInterface> getNetworkInterfaces() {
        Enumeration<NetworkInterface> networkInterfaces;
        try {
            networkInterfaces = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException e) {
            return null;
        }
        return CollectionUtils.addAll(new ArrayList(), networkInterfaces);
    }

    public static String getHostName() {
        try {
            return InetAddress.getLocalHost().getCanonicalHostName();
        }
        catch (Throwable e) {
            return null;
        }
    }

    public static boolean isPortAvailable(int port) {
        String host = "localhost";
        try {
            Socket socket = new Socket(host, port);
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }
}

