/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ageiport.common.utils;

import com.alibaba.ageiport.common.utils.ArrayUtils;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class TypeUtils {
    public static List<Type> getGenericParamType(Class source, Class target) {
        ParameterizedType directTargetInterface = TypeUtils.findDirectTargetInterface(source, target);
        if (directTargetInterface != null) {
            return TypeUtils.findActualTypeArguments(directTargetInterface);
        }
        Map<String, Type> parentTypeArgumentMap = TypeUtils.findParentTypeArgumentMap(source);
        ParameterizedType targetInterface = TypeUtils.findTargetInterfaceRecursive(source, target);
        List<Type> actualTypeArguments = TypeUtils.findActualTypeArguments(targetInterface);
        return actualTypeArguments.stream().map(type -> {
            if (type instanceof TypeVariable) {
                String name = ((TypeVariable)type).getName();
                return (Type)parentTypeArgumentMap.get(name);
            }
            return type;
        }).collect(Collectors.toList());
    }

    public static ParameterizedType findDirectTargetInterface(Class source, Class target) {
        Type[] genericInterfaces;
        for (Type genericInterface : genericInterfaces = source.getGenericInterfaces()) {
            Type rawType;
            if (!(genericInterface instanceof ParameterizedType) || !(rawType = ((ParameterizedType)genericInterface).getRawType()).equals(target)) continue;
            return (ParameterizedType)genericInterface;
        }
        return null;
    }

    public static ParameterizedType findTargetInterfaceRecursive(Class source, Class target) {
        while (source != null && !source.equals(Object.class)) {
            ParameterizedType directTargetInterface = TypeUtils.findDirectTargetInterface(source, target);
            if (directTargetInterface != null) {
                return directTargetInterface;
            }
            source = source.getSuperclass();
        }
        return null;
    }

    public static List<Type> findActualTypeArguments(Type type) {
        ArrayList<Type> list = new ArrayList<Type>();
        if (type instanceof ParameterizedType) {
            Type[] actualTypeArguments;
            for (Type actualTypeArgument : actualTypeArguments = ((ParameterizedType)type).getActualTypeArguments()) {
                if (actualTypeArgument instanceof ParameterizedType) {
                    list.add(TypeUtils.findActualTypeArgumentIfRawTypeIfList(actualTypeArgument));
                    continue;
                }
                list.add(actualTypeArgument);
            }
        }
        return list;
    }

    public static Type findActualTypeArgumentIfRawTypeIfList(Type type) {
        if (type instanceof ParameterizedType) {
            Type rawType = ((ParameterizedType)type).getRawType();
            Type actualTypeArgument = ((ParameterizedType)type).getActualTypeArguments()[0];
            if (List.class.isAssignableFrom((Class)rawType)) {
                return TypeUtils.findActualTypeArgumentIfRawTypeIfList(actualTypeArgument);
            }
            return rawType;
        }
        return type;
    }

    public static Map<String, Type> findParentTypeArgumentMap(Class source) {
        HashMap<String, Type> map = new HashMap<String, Type>(8);
        while (source != null && !source.equals(Object.class)) {
            Type genericSuperclass = source.getGenericSuperclass();
            if (genericSuperclass instanceof ParameterizedType) {
                Type[] actualTypeArguments = ((ParameterizedType)genericSuperclass).getActualTypeArguments();
                TypeVariable<Class<T>>[] typeParameters = source.getSuperclass().getTypeParameters();
                for (int i = 0; i < typeParameters.length; ++i) {
                    Type actualTypeArgument = actualTypeArguments[i];
                    TypeVariable typeParameter = typeParameters[i];
                    Type actualTypeArgumentIfRawType = TypeUtils.findActualTypeArgumentIfRawTypeIfList(actualTypeArgument);
                    if (map.containsKey(typeParameter.getName()) || !(actualTypeArgumentIfRawType instanceof Class)) continue;
                    map.put(typeParameter.getName(), actualTypeArgumentIfRawType);
                }
            }
            source = source.getSuperclass();
        }
        return map;
    }

    public static List<Field> getDeclaredFields(Class clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("clazz param can not be null");
        }
        ArrayList classes = new ArrayList();
        while (clazz != null && clazz != Object.class) {
            classes.add(clazz);
            clazz = clazz.getSuperclass();
        }
        ArrayList<Field> fields = new ArrayList<Field>();
        for (int i = classes.size() - 1; i >= 0; --i) {
            Class aClass = (Class)classes.get(i);
            fields.addAll(new ArrayList<Field>(Arrays.asList(aClass.getDeclaredFields())));
        }
        return fields;
    }

    public static Set<Class<?>> flattenHierarchy(Class<?> concreteClass) {
        HashSet classes = new HashSet();
        classes.add(concreteClass);
        while (concreteClass != null && !concreteClass.equals(Object.class)) {
            Class<?>[] interfaces = concreteClass.getInterfaces();
            if (interfaces != null) {
                for (Class<?> anInterface : interfaces) {
                    classes.addAll(TypeUtils.flattenHierarchy(anInterface));
                }
            }
            if ((concreteClass = concreteClass.getSuperclass()) == null) continue;
            classes.add(concreteClass);
        }
        return classes;
    }

    public static boolean isUnknow(Type type) {
        return null == type || type instanceof TypeVariable;
    }

    public static Type getTypeArgument(Type type) {
        return TypeUtils.getTypeArgument(type, 0);
    }

    public static Type getTypeArgument(Type type, int index) {
        Type[] typeArguments = TypeUtils.getTypeArguments(type);
        if (null != typeArguments && typeArguments.length > index) {
            return typeArguments[index];
        }
        return null;
    }

    public static Type[] getTypeArguments(Type type) {
        if (null == type) {
            return null;
        }
        ParameterizedType parameterizedType = TypeUtils.toParameterizedType(type);
        return null == parameterizedType ? null : parameterizedType.getActualTypeArguments();
    }

    public static Class<?> getClass(Type type) {
        if (null != type) {
            Type[] upperBounds;
            if (type instanceof Class) {
                return (Class)type;
            }
            if (type instanceof ParameterizedType) {
                return (Class)((ParameterizedType)type).getRawType();
            }
            if (type instanceof TypeVariable) {
                return (Class)((TypeVariable)type).getBounds()[0];
            }
            if (type instanceof WildcardType && (upperBounds = ((WildcardType)type).getUpperBounds()).length == 1) {
                return TypeUtils.getClass(upperBounds[0]);
            }
        }
        return null;
    }

    public static ParameterizedType toParameterizedType(Type type) {
        ParameterizedType result = null;
        if (type instanceof ParameterizedType) {
            result = (ParameterizedType)type;
        } else if (type instanceof Class) {
            Object[] genericInterfaces;
            Class clazz = (Class)type;
            Object genericSuper = clazz.getGenericSuperclass();
            if ((null == genericSuper || Object.class.equals(genericSuper)) && ArrayUtils.isNotEmpty(genericInterfaces = clazz.getGenericInterfaces())) {
                genericSuper = genericInterfaces[0];
            }
            result = TypeUtils.toParameterizedType((Type)genericSuper);
        }
        return result;
    }
}

