/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ageiport.ext.arch;

import com.alibaba.ageiport.common.collections.map.ConcurrentHashSet;
import com.alibaba.ageiport.common.constants.ConstValues;
import com.alibaba.ageiport.common.function.Prioritized;
import com.alibaba.ageiport.common.logger.Logger;
import com.alibaba.ageiport.common.logger.LoggerFactory;
import com.alibaba.ageiport.common.model.Holder;
import com.alibaba.ageiport.common.utils.ArrayUtils;
import com.alibaba.ageiport.common.utils.ClassUtils;
import com.alibaba.ageiport.common.utils.CollectionUtils;
import com.alibaba.ageiport.common.utils.ConfigUtils;
import com.alibaba.ageiport.common.utils.ReflectUtils;
import com.alibaba.ageiport.common.utils.StringUtils;
import com.alibaba.ageiport.ext.arch.Activate;
import com.alibaba.ageiport.ext.arch.Adaptive;
import com.alibaba.ageiport.ext.arch.AdaptiveClassCodeGenerator;
import com.alibaba.ageiport.ext.arch.DisableInject;
import com.alibaba.ageiport.ext.arch.ExtensionFactory;
import com.alibaba.ageiport.ext.arch.LoadingStrategy;
import com.alibaba.ageiport.ext.arch.SPI;
import com.alibaba.ageiport.ext.arch.compiler.Compiler;
import com.alibaba.ageiport.ext.arch.context.Lifecycle;
import com.alibaba.ageiport.ext.arch.support.ActivateComparator;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Pattern;

public class ExtensionLoader<T> {
    private static final Logger logger = LoggerFactory.getLogger(ExtensionLoader.class);
    private static final String SERVICES_DIRECTORY = "META-INF/ageiport/";
    private static final Pattern NAME_SEPARATOR = Pattern.compile("\\s*[,]+\\s*");
    private static final ConcurrentMap<Class<?>, ExtensionLoader<?>> EXTENSION_LOADERS = new ConcurrentHashMap(64);
    private static final ConcurrentMap<Class<?>, Object> EXTENSION_INSTANCES = new ConcurrentHashMap(64);
    private final Class<T> type;
    private final ExtensionFactory objectFactory;
    private final ConcurrentMap<Class<?>, String> cachedNames = new ConcurrentHashMap();
    private final Holder<Map<String, Class<?>>> cachedClasses = new Holder();
    private final Map<String, Object> cachedActivates = new ConcurrentHashMap<String, Object>();
    private final ConcurrentMap<String, Holder<Object>> cachedInstances = new ConcurrentHashMap<String, Holder<Object>>();
    private final Holder<Object> cachedAdaptiveInstance = new Holder();
    private volatile Class<?> cachedAdaptiveClass = null;
    private String cachedDefaultName;
    private volatile Throwable createAdaptiveInstanceError;
    private Set<Class<?>> cachedWrapperClasses;
    private Map<String, IllegalStateException> exceptions = new ConcurrentHashMap<String, IllegalStateException>();
    private static LoadingStrategy SERVICES_STRATEGY = () -> "META-INF/ageiport/";
    private static LoadingStrategy[] strategies = new LoadingStrategy[]{SERVICES_STRATEGY};

    private ExtensionLoader(Class<T> type) {
        this.type = type;
        this.objectFactory = type == ExtensionFactory.class ? null : ExtensionLoader.getExtensionLoader(ExtensionFactory.class).getAdaptiveExtension();
    }

    private static <T> boolean withExtensionAnnotation(Class<T> type) {
        return type.isAnnotationPresent(SPI.class);
    }

    public static <T> ExtensionLoader<T> getExtensionLoader(Class<T> type) {
        if (type == null) {
            throw new IllegalArgumentException("Extension type == null");
        }
        if (!type.isInterface()) {
            throw new IllegalArgumentException("Extension type (" + type + ") is not an interface!");
        }
        if (!ExtensionLoader.withExtensionAnnotation(type)) {
            throw new IllegalArgumentException("Extension type (" + type + ") is not an extension, because it is NOT annotated with @" + SPI.class.getSimpleName() + "!");
        }
        ExtensionLoader loader = (ExtensionLoader)EXTENSION_LOADERS.get(type);
        if (loader == null) {
            EXTENSION_LOADERS.putIfAbsent(type, new ExtensionLoader<T>(type));
            loader = (ExtensionLoader)EXTENSION_LOADERS.get(type);
        }
        return loader;
    }

    private static ClassLoader findClassLoader() {
        return ClassUtils.getClassLoader(ExtensionLoader.class);
    }

    public String getExtensionName(T extensionInstance) {
        return this.getExtensionName(extensionInstance.getClass());
    }

    public String getExtensionName(Class<?> extensionClass) {
        this.getExtensionClasses();
        return (String)this.cachedNames.get(extensionClass);
    }

    public List<T> getActivateExtension(com.alibaba.ageiport.common.URL url, String key) {
        return this.getActivateExtension(url, key, null);
    }

    public List<T> getActivateExtension(com.alibaba.ageiport.common.URL url, String[] values) {
        return this.getActivateExtension(url, values, null);
    }

    public List<T> getActivateExtension(com.alibaba.ageiport.common.URL url, String key, String group) {
        String value = url.getParameter(key);
        return this.getActivateExtension(url, StringUtils.isEmpty((CharSequence)value) ? null : ConstValues.COMMA_SPLIT_PATTERN.split(value), group);
    }

    public List<T> getActivateExtension(com.alibaba.ageiport.common.URL url, String[] values, String group) {
        String name;
        List<Object> names;
        ArrayList<Object> activateExtensions = new ArrayList<Object>();
        List<Object> list = names = values == null ? new ArrayList(0) : Arrays.asList(values);
        if (!names.contains("-default")) {
            this.getExtensionClasses();
            for (Map.Entry<String, Object> entry : this.cachedActivates.entrySet()) {
                name = entry.getKey();
                Object activate = entry.getValue();
                if (!(activate instanceof Activate)) continue;
                String[] activateGroup = ((Activate)activate).group();
                String[] activateValue = ((Activate)activate).value();
                if (!this.isMatchGroup(group, activateGroup) || names.contains(name) || names.contains("-" + name) || !this.isActive(activateValue, url)) continue;
                activateExtensions.add(this.getExtension(name));
            }
            activateExtensions.sort(ActivateComparator.COMPARATOR);
        }
        ArrayList<T> loadedExtensions = new ArrayList<T>();
        for (int i = 0; i < names.size(); ++i) {
            name = (String)names.get(i);
            if (name.startsWith("-") || names.contains("-" + name)) continue;
            if ("default".equals(name)) {
                if (loadedExtensions.isEmpty()) continue;
                activateExtensions.addAll(0, loadedExtensions);
                loadedExtensions.clear();
                continue;
            }
            loadedExtensions.add(this.getExtension(name));
        }
        if (!loadedExtensions.isEmpty()) {
            activateExtensions.addAll(loadedExtensions);
        }
        return activateExtensions;
    }

    private boolean isMatchGroup(String group, String[] groups) {
        if (StringUtils.isEmpty((CharSequence)group)) {
            return true;
        }
        if (groups != null && groups.length > 0) {
            for (String g : groups) {
                if (!group.equals(g)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isActive(String[] keys, com.alibaba.ageiport.common.URL url) {
        if (keys.length == 0) {
            return true;
        }
        for (String key : keys) {
            String keyValue = null;
            if (key.contains(":")) {
                String[] arr = key.split(":");
                key = arr[0];
                keyValue = arr[1];
            }
            for (Map.Entry entry : url.getParameters().entrySet()) {
                String k = (String)entry.getKey();
                String v = (String)entry.getValue();
                if (!k.equals(key) && !k.endsWith("." + key) || (keyValue == null || !keyValue.equals(v)) && (keyValue != null || !ConfigUtils.isNotEmpty((String)v))) continue;
                return true;
            }
        }
        return false;
    }

    public T getLoadedExtension(String name) {
        if (StringUtils.isEmpty((CharSequence)name)) {
            throw new IllegalArgumentException("Extension name == null");
        }
        Holder<Object> holder = this.getOrCreateHolder(name);
        return (T)holder.get();
    }

    private Holder<Object> getOrCreateHolder(String name) {
        Holder holder = (Holder)this.cachedInstances.get(name);
        if (holder == null) {
            this.cachedInstances.putIfAbsent(name, (Holder<Object>)new Holder());
            holder = (Holder)this.cachedInstances.get(name);
        }
        return holder;
    }

    public Set<String> getLoadedExtensions() {
        return Collections.unmodifiableSet(new TreeSet(this.cachedInstances.keySet()));
    }

    public List<T> getLoadedExtensionInstances() {
        ArrayList instances = new ArrayList();
        this.cachedInstances.values().forEach(holder -> instances.add(holder.get()));
        return instances;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T getExtension(String name) {
        if (StringUtils.isEmpty((CharSequence)name)) {
            throw new IllegalArgumentException("Extension name == null");
        }
        if ("true".equals(name)) {
            return this.getDefaultExtension();
        }
        Holder<Object> holder = this.getOrCreateHolder(name);
        Object instance = holder.get();
        if (instance == null) {
            Holder<Object> holder2 = holder;
            synchronized (holder2) {
                instance = holder.get();
                if (instance == null) {
                    instance = this.createExtension(name);
                    holder.set(instance);
                }
            }
        }
        return (T)instance;
    }

    public T getOrDefaultExtension(String name) {
        return this.containsExtension(name) ? this.getExtension(name) : this.getDefaultExtension();
    }

    public T getDefaultExtension() {
        this.getExtensionClasses();
        if (StringUtils.isBlank((CharSequence)this.cachedDefaultName) || "true".equals(this.cachedDefaultName)) {
            return null;
        }
        return this.getExtension(this.cachedDefaultName);
    }

    public boolean hasExtension(String name) {
        if (StringUtils.isEmpty((CharSequence)name)) {
            throw new IllegalArgumentException("Extension name == null");
        }
        Class<?> c = this.getExtensionClass(name);
        return c != null;
    }

    public Set<String> getSupportedExtensions() {
        Map<String, Class<?>> clazzes = this.getExtensionClasses();
        return Collections.unmodifiableSet(new TreeSet<String>(clazzes.keySet()));
    }

    public Set<T> getSupportedExtensionInstances() {
        LinkedList<T> instances = new LinkedList<T>();
        Set<String> supportedExtensions = this.getSupportedExtensions();
        if (CollectionUtils.isNotEmpty(supportedExtensions)) {
            for (String name : supportedExtensions) {
                instances.add(this.getExtension(name));
            }
        }
        Collections.sort(instances, Prioritized.COMPARATOR);
        return new LinkedHashSet(instances);
    }

    public String getDefaultExtensionName() {
        this.getExtensionClasses();
        return this.cachedDefaultName;
    }

    public void addExtension(String name, Class<?> clazz) {
        this.getExtensionClasses();
        if (!this.type.isAssignableFrom(clazz)) {
            throw new IllegalStateException("Input type " + clazz + " doesn't implement the Extension " + this.type);
        }
        if (clazz.isInterface()) {
            throw new IllegalStateException("Input type " + clazz + " can't be interface!");
        }
        if (!clazz.isAnnotationPresent(Adaptive.class)) {
            if (StringUtils.isBlank((CharSequence)name)) {
                throw new IllegalStateException("Extension name is blank (Extension " + this.type + ")!");
            }
            if (((Map)this.cachedClasses.get()).containsKey(name)) {
                throw new IllegalStateException("Extension name " + name + " already exists (Extension " + this.type + ")!");
            }
            this.cachedNames.put(clazz, name);
            ((Map)this.cachedClasses.get()).put(name, clazz);
        } else {
            if (this.cachedAdaptiveClass != null) {
                throw new IllegalStateException("Adaptive Extension already exists (Extension " + this.type + ")!");
            }
            this.cachedAdaptiveClass = clazz;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T getAdaptiveExtension() {
        Object instance = this.cachedAdaptiveInstance.get();
        if (instance == null) {
            if (this.createAdaptiveInstanceError != null) {
                throw new IllegalStateException("Failed to create adaptive instance: " + this.createAdaptiveInstanceError.toString(), this.createAdaptiveInstanceError);
            }
            Holder<Object> holder = this.cachedAdaptiveInstance;
            synchronized (holder) {
                instance = this.cachedAdaptiveInstance.get();
                if (instance == null) {
                    try {
                        instance = this.createAdaptiveExtension();
                        this.cachedAdaptiveInstance.set(instance);
                    }
                    catch (Throwable t) {
                        this.createAdaptiveInstanceError = t;
                        throw new IllegalStateException("Failed to create adaptive instance: " + t.toString(), t);
                    }
                }
            }
        }
        return (T)instance;
    }

    private IllegalStateException findException(String name) {
        for (Map.Entry<String, IllegalStateException> entry : this.exceptions.entrySet()) {
            if (!entry.getKey().toLowerCase().contains(name.toLowerCase())) continue;
            return entry.getValue();
        }
        StringBuilder buf = new StringBuilder("No such extension " + this.type.getName() + " by name " + name);
        int i = 1;
        for (Map.Entry<String, IllegalStateException> entry : this.exceptions.entrySet()) {
            if (i == 1) {
                buf.append(", possible causes: ");
            }
            buf.append("\r\n(");
            buf.append(i++);
            buf.append(") ");
            buf.append(entry.getKey());
            buf.append(":\r\n");
            buf.append(StringUtils.toString((Throwable)entry.getValue()));
        }
        return new IllegalStateException(buf.toString());
    }

    private T createExtension(String name) {
        Class<?> clazz = this.getExtensionClasses().get(name);
        if (clazz == null) {
            throw this.findException(name);
        }
        try {
            Object instance = EXTENSION_INSTANCES.get(clazz);
            if (instance == null) {
                EXTENSION_INSTANCES.putIfAbsent(clazz, clazz.newInstance());
                instance = EXTENSION_INSTANCES.get(clazz);
            }
            this.injectExtension(instance);
            Set<Class<?>> wrapperClasses = this.cachedWrapperClasses;
            if (CollectionUtils.isNotEmpty(wrapperClasses)) {
                for (Class<?> wrapperClass : wrapperClasses) {
                    instance = this.injectExtension(wrapperClass.getConstructor(this.type).newInstance(instance));
                }
            }
            this.initExtension(instance);
            return (T)instance;
        }
        catch (Throwable t) {
            throw new IllegalStateException("Extension instance (name: " + name + ", class: " + this.type + ") couldn't be instantiated: " + t.getMessage(), t);
        }
    }

    private boolean containsExtension(String name) {
        return this.getExtensionClasses().containsKey(name);
    }

    private T injectExtension(T instance) {
        if (this.objectFactory == null) {
            return instance;
        }
        try {
            for (Method method : instance.getClass().getMethods()) {
                Class<?> pt;
                if (!this.isSetter(method) || method.getAnnotation(DisableInject.class) != null || ReflectUtils.isPrimitives(pt = method.getParameterTypes()[0])) continue;
                try {
                    String property = this.getSetterProperty(method);
                    Object object = this.objectFactory.getExtension(pt, property);
                    if (object == null) continue;
                    method.invoke(instance, object);
                }
                catch (Throwable e) {
                    logger.error("Failed to inject via method " + method.getName() + " of interface " + this.type.getName() + ": " + e.getMessage(), e);
                }
            }
        }
        catch (Throwable e) {
            logger.error(e.getMessage(), e);
        }
        return instance;
    }

    private void initExtension(T instance) {
        if (instance instanceof Lifecycle) {
            Lifecycle lifecycle = (Lifecycle)instance;
            lifecycle.initialize();
        }
    }

    private String getSetterProperty(Method method) {
        return method.getName().length() > 3 ? method.getName().substring(3, 4).toLowerCase() + method.getName().substring(4) : "";
    }

    private boolean isSetter(Method method) {
        return method.getName().startsWith("set") && method.getParameterTypes().length == 1 && Modifier.isPublic(method.getModifiers());
    }

    private Class<?> getExtensionClass(String name) {
        if (this.type == null) {
            throw new IllegalArgumentException("Extension type == null");
        }
        if (name == null) {
            throw new IllegalArgumentException("Extension name == null");
        }
        return this.getExtensionClasses().get(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Class<?>> getExtensionClasses() {
        Map<String, Class<?>> classes = (Map<String, Class<?>>)this.cachedClasses.get();
        if (classes == null) {
            Holder<Map<String, Class<?>>> holder = this.cachedClasses;
            synchronized (holder) {
                classes = (Map)this.cachedClasses.get();
                if (classes == null) {
                    classes = this.loadExtensionClasses();
                    this.cachedClasses.set(classes);
                }
            }
        }
        return classes;
    }

    private Map<String, Class<?>> loadExtensionClasses() {
        this.cacheDefaultExtensionName();
        HashMap extensionClasses = new HashMap();
        for (LoadingStrategy strategy : strategies) {
            this.loadDirectory(extensionClasses, strategy.directory(), this.type.getName(), strategy.preferExtensionClassLoader(), strategy.excludedPackages());
        }
        return extensionClasses;
    }

    private void cacheDefaultExtensionName() {
        SPI defaultAnnotation = this.type.getAnnotation(SPI.class);
        if (defaultAnnotation == null) {
            return;
        }
        String value = defaultAnnotation.value();
        if ((value = value.trim()).length() > 0) {
            Object[] names = NAME_SEPARATOR.split(value);
            if (names.length > 1) {
                throw new IllegalStateException("More than 1 default extension name on extension " + this.type.getName() + ": " + Arrays.toString(names));
            }
            if (names.length == 1) {
                this.cachedDefaultName = names[0];
            }
        }
    }

    private void loadDirectory(Map<String, Class<?>> extensionClasses, String dir, String type, boolean extensionLoaderClassLoaderFirst, String ... excludedPackages) {
        String fileName = dir + type;
        try {
            Enumeration<URL> urls = null;
            ClassLoader classLoader = ExtensionLoader.findClassLoader();
            if (extensionLoaderClassLoaderFirst) {
                ClassLoader extensionLoaderClassLoader = ExtensionLoader.class.getClassLoader();
                if (ClassLoader.getSystemClassLoader() != extensionLoaderClassLoader) {
                    urls = extensionLoaderClassLoader.getResources(fileName);
                }
            }
            if (urls == null || !urls.hasMoreElements()) {
                urls = classLoader != null ? classLoader.getResources(fileName) : ClassLoader.getSystemResources(fileName);
            }
            if (urls != null) {
                while (urls.hasMoreElements()) {
                    URL resourceURL = urls.nextElement();
                    this.loadResource(extensionClasses, classLoader, resourceURL, excludedPackages);
                }
            }
        }
        catch (Throwable t) {
            logger.error("Exception occurred when loading extension class (interface: " + type + ", description file: " + fileName + ").", t);
        }
    }

    private void loadResource(Map<String, Class<?>> extensionClasses, ClassLoader classLoader, URL resourceURL, String ... excludedPackages) {
        block13: {
            try {
                BufferedReader reader = new BufferedReader(new InputStreamReader(resourceURL.openStream(), StandardCharsets.UTF_8));
                block9: while (true) {
                    String line;
                    while ((line = reader.readLine()) != null) {
                        int ci = line.indexOf(35);
                        if (ci >= 0) {
                            line = line.substring(0, ci);
                        }
                        if ((line = line.trim()).length() <= 0) continue;
                        try {
                            String name = null;
                            int i = line.indexOf(61);
                            if (i > 0) {
                                name = line.substring(0, i).trim();
                                line = line.substring(i + 1).trim();
                            }
                            if (line.length() <= 0 || this.isExcluded(line, excludedPackages)) continue block9;
                            this.loadClass(extensionClasses, resourceURL, Class.forName(line, true, classLoader), name);
                            continue block9;
                        }
                        catch (Throwable t) {
                            IllegalStateException e = new IllegalStateException("Failed to load extension class (interface: " + this.type + ", class line: " + line + ") in " + resourceURL + ", cause: " + t.getMessage(), t);
                            this.exceptions.put(line, e);
                        }
                    }
                    break block13;
                    {
                        continue block9;
                        break;
                    }
                    break;
                }
                finally {
                    reader.close();
                }
            }
            catch (Throwable t) {
                logger.error("Exception occurred when loading extension class (interface: " + this.type + ", class file: " + resourceURL + ") in " + resourceURL, t);
            }
        }
    }

    private boolean isExcluded(String className, String ... excludedPackages) {
        if (excludedPackages != null) {
            for (String excludePackage : excludedPackages) {
                if (!className.startsWith(excludePackage + ".")) continue;
                return true;
            }
        }
        return false;
    }

    private void loadClass(Map<String, Class<?>> extensionClasses, URL resourceURL, Class<?> clazz, String name) throws NoSuchMethodException {
        if (!this.type.isAssignableFrom(clazz)) {
            throw new IllegalStateException("Error occurred when loading extension class (interface: " + this.type + ", class line: " + clazz.getName() + "), class " + clazz.getName() + " is not subtype of interface.");
        }
        if (clazz.isAnnotationPresent(Adaptive.class)) {
            this.cacheAdaptiveClass(clazz);
        } else if (this.isWrapperClass(clazz)) {
            this.cacheWrapperClass(clazz);
        } else {
            clazz.getConstructor(new Class[0]);
            if (StringUtils.isEmpty((CharSequence)name) && (name = this.findAnnotationName(clazz)).length() == 0) {
                throw new IllegalStateException("No such extension name for the class " + clazz.getName() + " in the config " + resourceURL);
            }
            Object[] names = NAME_SEPARATOR.split(name);
            if (ArrayUtils.isNotEmpty((Object[])names)) {
                this.cacheActivateClass(clazz, (String)names[0]);
                for (Object n : names) {
                    this.cacheName(clazz, (String)n);
                    this.saveInExtensionClass(extensionClasses, clazz, (String)n);
                }
            }
        }
    }

    private void cacheName(Class<?> clazz, String name) {
        if (!this.cachedNames.containsKey(clazz)) {
            this.cachedNames.put(clazz, name);
        }
    }

    private void saveInExtensionClass(Map<String, Class<?>> extensionClasses, Class<?> clazz, String name) {
        Class<?> c = extensionClasses.get(name);
        if (c == null) {
            extensionClasses.put(name, clazz);
        } else if (c != clazz) {
            String duplicateMsg = "Duplicate extension " + this.type.getName() + " name " + name + " on " + c.getName() + " and " + clazz.getName();
            logger.error(duplicateMsg);
            throw new IllegalStateException(duplicateMsg);
        }
    }

    private void cacheActivateClass(Class<?> clazz, String name) {
        Activate activate = clazz.getAnnotation(Activate.class);
        if (activate != null) {
            this.cachedActivates.put(name, activate);
        }
    }

    private void cacheAdaptiveClass(Class<?> clazz) {
        if (this.cachedAdaptiveClass == null) {
            this.cachedAdaptiveClass = clazz;
        } else if (!this.cachedAdaptiveClass.equals(clazz)) {
            throw new IllegalStateException("More than 1 adaptive class found: " + this.cachedAdaptiveClass.getName() + ", " + clazz.getName());
        }
    }

    private void cacheWrapperClass(Class<?> clazz) {
        if (this.cachedWrapperClasses == null) {
            this.cachedWrapperClasses = new ConcurrentHashSet();
        }
        this.cachedWrapperClasses.add(clazz);
    }

    private boolean isWrapperClass(Class<?> clazz) {
        try {
            clazz.getConstructor(this.type);
            return true;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }

    private String findAnnotationName(Class<?> clazz) {
        String name = clazz.getSimpleName();
        if (name.endsWith(this.type.getSimpleName())) {
            name = name.substring(0, name.length() - this.type.getSimpleName().length());
        }
        return name.toLowerCase();
    }

    private Object createAdaptiveExtension() {
        try {
            return this.injectExtension(this.getAdaptiveExtensionClass().newInstance());
        }
        catch (Throwable e) {
            throw new IllegalStateException("Can't create adaptive extension " + this.type + ", cause: " + e.getMessage(), e);
        }
    }

    private Class<?> getAdaptiveExtensionClass() {
        this.getExtensionClasses();
        if (this.cachedAdaptiveClass != null) {
            return this.cachedAdaptiveClass;
        }
        this.cachedAdaptiveClass = this.createAdaptiveExtensionClass();
        return this.cachedAdaptiveClass;
    }

    private Class<?> createAdaptiveExtensionClass() {
        String code = new AdaptiveClassCodeGenerator(this.type, this.cachedDefaultName).generate();
        ClassLoader classLoader = ExtensionLoader.findClassLoader();
        Compiler compiler = ExtensionLoader.getExtensionLoader(Compiler.class).getAdaptiveExtension();
        return compiler.compile(code, classLoader);
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.type.getName() + "]";
    }
}

