/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ageiport.ext.cluster;

import com.alibaba.ageiport.common.logger.Logger;
import com.alibaba.ageiport.common.logger.LoggerFactory;
import com.alibaba.ageiport.common.utils.CollectionUtils;
import com.alibaba.ageiport.common.utils.JsonUtil;
import com.alibaba.ageiport.ext.cluster.SpringCloudNode;
import com.alibaba.ageiport.processor.core.AgeiPort;
import com.alibaba.ageiport.processor.core.AgeiPortOptions;
import com.alibaba.ageiport.processor.core.spi.cluster.ClusterManager;
import com.alibaba.ageiport.processor.core.spi.cluster.Node;
import com.alibaba.ageiport.processor.core.spi.cluster.NodeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.DiscoveryClient;

public class SpringCloudClusterManager
implements ClusterManager {
    public static Logger log = LoggerFactory.getLogger(SpringCloudClusterManager.class);
    private AgeiPort ageiPort;
    private List<Node> nodes;
    private Node localNode;
    private List<NodeListener> nodeListeners;
    private DiscoveryClient discoveryClient;
    private boolean refreshed = false;

    public void join() {
    }

    public void leave() {
    }

    public List<NodeListener> getNodeListeners() {
        return this.nodeListeners;
    }

    public void refreshNodes() {
        AgeiPortOptions ageiPortOptions = this.ageiPort.getOptions();
        String app = ageiPortOptions.getApp();
        List instances = this.discoveryClient.getInstances(app);
        if (CollectionUtils.isEmpty((Collection)instances)) {
            throw new IllegalArgumentException("Cannot found any instance from discovery server, serviceId:" + app);
        }
        ArrayList<Node> nodes = new ArrayList<Node>();
        for (ServiceInstance instance : instances) {
            SpringCloudNode cloudNode = new SpringCloudNode();
            cloudNode.setApp(app);
            cloudNode.setId(instance.getHost() + ":" + instance.getPort());
            cloudNode.setHost(instance.getHost());
            cloudNode.setGroup(app);
            cloudNode.setAttributes(instance.getMetadata());
            cloudNode.setLabels(instance.getMetadata());
            nodes.add(cloudNode);
            if (!cloudNode.getHost().equals(this.localNode.getHost())) continue;
            this.setLocalNode(cloudNode);
        }
        this.setNodes(nodes);
        log.info("refresh cluster node, clusterSize:{}, local:{}", new Object[]{nodes.size(), JsonUtil.toJsonString((Object)this.localNode)});
        this.setRefreshed(true);
    }

    public AgeiPort getAgeiPort() {
        return this.ageiPort;
    }

    public List<Node> getNodes() {
        return this.nodes;
    }

    public Node getLocalNode() {
        return this.localNode;
    }

    public DiscoveryClient getDiscoveryClient() {
        return this.discoveryClient;
    }

    public boolean isRefreshed() {
        return this.refreshed;
    }

    public void setAgeiPort(AgeiPort ageiPort) {
        this.ageiPort = ageiPort;
    }

    public void setNodes(List<Node> nodes) {
        this.nodes = nodes;
    }

    public void setLocalNode(Node localNode) {
        this.localNode = localNode;
    }

    public void setNodeListeners(List<NodeListener> nodeListeners) {
        this.nodeListeners = nodeListeners;
    }

    public void setDiscoveryClient(DiscoveryClient discoveryClient) {
        this.discoveryClient = discoveryClient;
    }

    public void setRefreshed(boolean refreshed) {
        this.refreshed = refreshed;
    }
}

