/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.adapter.gateway.common.command;

import com.alibaba.csp.sentinel.adapter.gateway.common.rule.GatewayFlowRule;
import com.alibaba.csp.sentinel.adapter.gateway.common.rule.GatewayRuleManager;
import com.alibaba.csp.sentinel.command.CommandHandler;
import com.alibaba.csp.sentinel.command.CommandRequest;
import com.alibaba.csp.sentinel.command.CommandResponse;
import com.alibaba.csp.sentinel.command.annotation.CommandMapping;
import com.alibaba.csp.sentinel.datasource.WritableDataSource;
import com.alibaba.csp.sentinel.log.RecordLog;
import com.alibaba.csp.sentinel.util.StringUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.net.URLDecoder;
import java.util.Set;

@CommandMapping(name="gateway/updateRules", desc="Update gateway rules")
public class UpdateGatewayRuleCommandHandler
implements CommandHandler<String> {
    private static WritableDataSource<Set<GatewayFlowRule>> gatewayFlowWds = null;
    private static final String SUCCESS_MSG = "success";
    private static final String WRITE_DS_FAILURE_MSG = "partial success (write data source failed)";

    public CommandResponse<String> handle(CommandRequest request) {
        String data = request.getParam("data");
        if (StringUtil.isBlank((String)data)) {
            return CommandResponse.ofFailure((Throwable)new IllegalArgumentException("Bad data"));
        }
        try {
            data = URLDecoder.decode(data, "utf-8");
        }
        catch (Exception e) {
            RecordLog.info((String)"Decode gateway rule data error", (Throwable)e);
            return CommandResponse.ofFailure((Throwable)e, (Object)"decode gateway rule data error");
        }
        RecordLog.info((String)"[API Server] Receiving rule change (type: gateway rule): {}", (Object[])new Object[]{data});
        String result = SUCCESS_MSG;
        Set flowRules = (Set)JSON.parseObject((String)data, (TypeReference)new TypeReference<Set<GatewayFlowRule>>(){}, (Feature[])new Feature[0]);
        GatewayRuleManager.loadRules(flowRules);
        if (!this.writeToDataSource(gatewayFlowWds, flowRules)) {
            result = WRITE_DS_FAILURE_MSG;
        }
        return CommandResponse.ofSuccess((Object)result);
    }

    private <T> boolean writeToDataSource(WritableDataSource<T> dataSource, T value) {
        if (dataSource != null) {
            try {
                dataSource.write(value);
            }
            catch (Exception e) {
                RecordLog.warn((String)"Write data source failed", (Throwable)e);
                return false;
            }
        }
        return true;
    }

    public static synchronized WritableDataSource<Set<GatewayFlowRule>> getWritableDataSource() {
        return gatewayFlowWds;
    }

    public static synchronized void setWritableDataSource(WritableDataSource<Set<GatewayFlowRule>> gatewayFlowWds) {
        UpdateGatewayRuleCommandHandler.gatewayFlowWds = gatewayFlowWds;
    }
}

