/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.adapter.gateway.sc.route;

import com.alibaba.csp.sentinel.util.AssertUtil;
import com.alibaba.csp.sentinel.util.function.Predicate;
import java.util.regex.Pattern;
import org.springframework.web.server.ServerWebExchange;

public class RegexRoutePathMatcher
implements Predicate<ServerWebExchange> {
    private final String pattern;
    private final Pattern regex;

    public RegexRoutePathMatcher(String pattern) {
        AssertUtil.assertNotBlank((String)pattern, (String)"pattern cannot be blank");
        this.pattern = pattern;
        this.regex = Pattern.compile(pattern);
    }

    public boolean test(ServerWebExchange exchange) {
        String path = exchange.getRequest().getPath().value();
        return this.regex.matcher(path).matches();
    }

    public String getPattern() {
        return this.pattern;
    }
}

