/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dashscope.protocol;

import com.alibaba.dashscope.protocol.ConnectionOptions;
import com.alibaba.dashscope.protocol.FullDuplexClient;
import com.alibaba.dashscope.protocol.HalfDuplexClient;
import com.alibaba.dashscope.protocol.okhttp.OkHttpClientFactory;
import com.alibaba.dashscope.protocol.okhttp.OkHttpHttpClient;
import com.alibaba.dashscope.protocol.okhttp.OkHttpWebSocketClient;

public class ClientProviders {
    public static HalfDuplexClient getHalfDuplexClient(String protocol) {
        return ClientProviders.getHalfDuplexClient(null, protocol);
    }

    public static FullDuplexClient getFullDuplexClient() {
        return ClientProviders.getFullDuplexClient(null);
    }

    public static HalfDuplexClient getHalfDuplexClient(ConnectionOptions options, String protocol) {
        if (protocol == null) {
            protocol = "https";
        }
        if (options == null) {
            if (protocol.toLowerCase().startsWith("http")) {
                return new OkHttpHttpClient(OkHttpClientFactory.getOkHttpClient());
            }
            return new OkHttpWebSocketClient(OkHttpClientFactory.getOkHttpClient());
        }
        if (protocol.toLowerCase().startsWith("http")) {
            return new OkHttpHttpClient(OkHttpClientFactory.getNewOkHttpClient(options));
        }
        return new OkHttpWebSocketClient(OkHttpClientFactory.getNewOkHttpClient(options));
    }

    public static FullDuplexClient getFullDuplexClient(ConnectionOptions connectionOptions) {
        if (connectionOptions == null) {
            return new OkHttpWebSocketClient(OkHttpClientFactory.getOkHttpClient());
        }
        return new OkHttpWebSocketClient(OkHttpClientFactory.getNewOkHttpClient(connectionOptions));
    }
}

