/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dashscope.aigc.multimodalconversation;

import com.alibaba.dashscope.aigc.multimodalconversation.MultiModalConversationMessage;
import com.alibaba.dashscope.aigc.multimodalconversation.MultiModalConversationParam;
import com.alibaba.dashscope.aigc.multimodalconversation.MultiModalConversationResult;
import com.alibaba.dashscope.api.SynchronizeHalfDuplexApi;
import com.alibaba.dashscope.common.DashScopeResult;
import com.alibaba.dashscope.common.Function;
import com.alibaba.dashscope.common.OutputMode;
import com.alibaba.dashscope.common.ResultCallback;
import com.alibaba.dashscope.common.Task;
import com.alibaba.dashscope.common.TaskGroup;
import com.alibaba.dashscope.exception.ApiException;
import com.alibaba.dashscope.exception.InputRequiredException;
import com.alibaba.dashscope.exception.NoApiKeyException;
import com.alibaba.dashscope.exception.UploadFileException;
import com.alibaba.dashscope.protocol.ApiServiceOption;
import com.alibaba.dashscope.protocol.ClientOptions;
import com.alibaba.dashscope.protocol.HttpMethod;
import com.alibaba.dashscope.protocol.Protocol;
import com.alibaba.dashscope.protocol.StreamingMode;
import com.alibaba.dashscope.utils.PreprocessMessageInput;
import io.reactivex.Flowable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MultiModalConversation {
    private static final Logger log = LoggerFactory.getLogger(MultiModalConversation.class);
    private final SynchronizeHalfDuplexApi<MultiModalConversationParam> syncApi;
    private final ApiServiceOption serviceOption;

    public MultiModalConversation() {
        this.serviceOption = ((ApiServiceOption.ApiServiceOptionBuilder)((ApiServiceOption.ApiServiceOptionBuilder)((ApiServiceOption.ApiServiceOptionBuilder)((ApiServiceOption.ApiServiceOptionBuilder)((ApiServiceOption.ApiServiceOptionBuilder)((ApiServiceOption.ApiServiceOptionBuilder)((ApiServiceOption.ApiServiceOptionBuilder)ApiServiceOption.builder().protocol(Protocol.HTTP)).httpMethod(HttpMethod.POST)).streamingMode(StreamingMode.NONE)).outputMode(OutputMode.ACCUMULATE)).taskGroup(TaskGroup.AIGC.getValue())).task(Task.MULTIMODAL_GENERATION.getValue())).function(Function.GENERATION.getValue())).build();
        this.syncApi = new SynchronizeHalfDuplexApi(this.serviceOption);
    }

    public MultiModalConversation(String protocol) {
        this.serviceOption = ((ApiServiceOption.ApiServiceOptionBuilder)((ApiServiceOption.ApiServiceOptionBuilder)((ApiServiceOption.ApiServiceOptionBuilder)((ApiServiceOption.ApiServiceOptionBuilder)((ApiServiceOption.ApiServiceOptionBuilder)((ApiServiceOption.ApiServiceOptionBuilder)ApiServiceOption.builder().protocol(Protocol.of(protocol))).streamingMode(StreamingMode.NONE)).outputMode(OutputMode.ACCUMULATE)).taskGroup(TaskGroup.AIGC.getValue())).task(Task.MULTIMODAL_GENERATION.getValue())).function(Function.GENERATION.getValue())).build();
        this.syncApi = new SynchronizeHalfDuplexApi((ClientOptions)((ClientOptions.ClientOptionsBuilder)ClientOptions.builder().protocol(protocol)).build(), this.serviceOption);
    }

    public MultiModalConversationResult call(MultiModalConversationParam param) throws ApiException, NoApiKeyException, UploadFileException {
        this.serviceOption.setIsSSE(false);
        this.serviceOption.setStreamingMode(StreamingMode.NONE);
        this.preprocessInput(param);
        return MultiModalConversationResult.fromDashScopeResult(this.syncApi.call(param));
    }

    public void call(MultiModalConversationParam param, final ResultCallback<MultiModalConversationResult> callback) throws ApiException, NoApiKeyException, UploadFileException {
        this.serviceOption.setIsSSE(false);
        this.serviceOption.setStreamingMode(StreamingMode.NONE);
        this.preprocessInput(param);
        this.syncApi.call(param, new ResultCallback<DashScopeResult>(){

            @Override
            public void onEvent(DashScopeResult message) {
                callback.onEvent(MultiModalConversationResult.fromDashScopeResult(message));
            }

            @Override
            public void onComplete() {
                callback.onComplete();
            }

            @Override
            public void onError(Exception e) {
                callback.onError(e);
            }
        });
    }

    public Flowable<MultiModalConversationResult> streamCall(MultiModalConversationParam param) throws ApiException, NoApiKeyException, UploadFileException {
        this.serviceOption.setIsSSE(true);
        this.serviceOption.setStreamingMode(StreamingMode.OUT);
        this.preprocessInput(param);
        return this.syncApi.streamCall(param).map(item -> MultiModalConversationResult.fromDashScopeResult(item));
    }

    public void streamCall(MultiModalConversationParam param, final ResultCallback<MultiModalConversationResult> callback) throws ApiException, NoApiKeyException, InputRequiredException, UploadFileException {
        param.validate();
        this.serviceOption.setIsSSE(true);
        this.serviceOption.setStreamingMode(StreamingMode.OUT);
        this.preprocessInput(param);
        this.syncApi.streamCall(param, new ResultCallback<DashScopeResult>(){

            @Override
            public void onEvent(DashScopeResult msg) {
                callback.onEvent(MultiModalConversationResult.fromDashScopeResult(msg));
            }

            @Override
            public void onComplete() {
                callback.onComplete();
            }

            @Override
            public void onError(Exception e) {
                callback.onError(e);
            }
        });
    }

    private void preprocessInput(MultiModalConversationParam param) throws NoApiKeyException, UploadFileException {
        boolean hasUpload = false;
        for (MultiModalConversationMessage msg : param.getMessages()) {
            boolean isUpload = PreprocessMessageInput.preProcessMessageInputs(param.getModel(), msg.getContent(), param.getApiKey());
            if (!isUpload || hasUpload) continue;
            hasUpload = true;
        }
        if (hasUpload) {
            param.putHeader("X-DashScope-OssResourceResolve", "enable");
        }
    }

    public static class Models {
        public static final String QWEN_VL_CHAT_V1 = "qwen-vl-chat-v1";
    }
}

