/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.support.opds.udf;

import com.alibaba.druid.sql.SQLUtils;
import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.visitor.SchemaStatVisitor;
import com.alibaba.druid.stat.TableStat;
import com.alibaba.druid.support.json.JSONUtils;
import com.aliyun.odps.udf.UDF;
import java.util.ArrayList;
import java.util.List;

public class ExportConditions
extends UDF {
    public String evaluate(String sql) {
        return this.evaluate(sql, null);
    }

    public String evaluate(String sql, String dbType) {
        try {
            List<SQLStatement> statementList = SQLUtils.parseStatements(sql, dbType);
            SchemaStatVisitor visitor = SQLUtils.createSchemaStatVisitor(dbType);
            for (SQLStatement stmt : statementList) {
                stmt.accept(visitor);
            }
            ArrayList rows = new ArrayList();
            List<TableStat.Condition> conditions = visitor.getConditions();
            for (int i = 0; i < conditions.size(); ++i) {
                TableStat.Condition condition = conditions.get(i);
                TableStat.Column column = condition.getColumn();
                String operator = condition.getOperator();
                List<Object> values = condition.getValues();
                ArrayList<Object> row = new ArrayList<Object>();
                row.add(column.getTable());
                row.add(column.getName());
                row.add(operator);
                if (values.size() == 0) {
                    row.add(null);
                } else if (values.size() == 1) {
                    row.add(values.get(0));
                } else {
                    row.add(values);
                }
                rows.add(row);
            }
            return JSONUtils.toJSONString(rows);
        }
        catch (Throwable ex) {
            System.err.println("error sql : " + sql);
            ex.printStackTrace();
            return null;
        }
    }
}

