/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.simpleimage.analyze.search.cluster.impl;

import com.alibaba.simpleimage.analyze.search.cluster.Clusterable;
import com.alibaba.simpleimage.analyze.search.util.ClusterUtils;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Cluster
implements Clusterable {
    private float[] mOriginalMeanLocation;
    private float[] mCurrentMeanLocation;
    private List<Clusterable> mClusterItems;
    private int id;

    public Cluster(float[] location, int id) {
        this.mOriginalMeanLocation = location;
        this.mClusterItems = new ArrayList<Clusterable>();
        this.id = id;
    }

    public float[] getClusterMean() {
        float[] normedCurrentLocation = new float[this.mCurrentMeanLocation.length];
        for (int i = 0; i < this.mCurrentMeanLocation.length; ++i) {
            normedCurrentLocation[i] = this.mCurrentMeanLocation[i] / (float)this.mClusterItems.size();
        }
        return normedCurrentLocation;
    }

    public float getClusterMeanDist() {
        float[] clusterMean = this.getClusterMean();
        float sum = 0.0f;
        for (Clusterable clusterItem : this.mClusterItems) {
            float dist = ClusterUtils.getEuclideanDistance(clusterItem.getLocation(), clusterMean);
            sum += dist * dist;
        }
        return (float)Math.sqrt(sum);
    }

    public void removeItem(Clusterable item) {
        this.mClusterItems.remove(item);
    }

    public void addItem(Clusterable item) {
        this.mCurrentMeanLocation = this.mCurrentMeanLocation == null ? (float[])item.getLocation().clone() : Cluster.sumArrays(this.mCurrentMeanLocation, item.getLocation());
        this.mClusterItems.add(item);
    }

    public List<Clusterable> getItems() {
        return this.mClusterItems;
    }

    @Override
    public float[] getLocation() {
        return this.mOriginalMeanLocation;
    }

    public void setLocation(float[] location) {
        this.mOriginalMeanLocation = location;
    }

    public static float[] getMeanValue(List<Clusterable> items) {
        assert (items != null);
        assert (items.size() > 0);
        float[] newLocation = new float[items.get(0).getLocation().length];
        for (Clusterable item : items) {
            newLocation = Cluster.sumArrays(newLocation, item.getLocation());
        }
        for (int i = 0; i < newLocation.length; ++i) {
            newLocation[i] = newLocation[i] / (float)items.size();
        }
        return newLocation;
    }

    private static float[] sumArrays(float[] valsA, float[] valsB) {
        for (int i = 0; i < valsA.length; ++i) {
            int n = i;
            valsA[n] = valsA[n] + valsB[i];
        }
        return valsA;
    }

    public String toString() {
        return String.valueOf(this.id);
    }

    public int getId() {
        return this.id;
    }

    public static void main(String[] args) {
        float[] center = new float[]{0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f};
        Cluster c = new Cluster(center, 0);
        float[] center2 = new float[]{1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f};
        c.addItem(new Cluster(center2, 0));
        System.out.print("avg = [");
        for (float val : c.getClusterMean()) {
            System.out.print(val + ",");
        }
        System.out.println("]");
        float[] center3 = new float[]{0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f};
        c.addItem(new Cluster(center3, 0));
        System.out.print("avg = [");
        for (float val : c.getClusterMean()) {
            System.out.print(val + ",");
        }
        System.out.println("]");
        float[] center4 = new float[]{-4.0f, -4.0f, -4.0f, -4.0f, -4.0f, -4.0f, -4.0f, -4.0f, -4.0f, -4.0f, -4.0f, -4.0f, -4.0f, -4.0f, -4.0f, -4.0f, -4.0f, -4.0f, -4.0f, -4.0f};
        c.addItem(new Cluster(center4, 0));
        System.out.print("avg = [");
        for (float val : c.getClusterMean()) {
            System.out.print(val + ",");
        }
        System.out.println("]");
    }
}

