/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.simpleimage.analyze.search.cluster.impl;

import com.alibaba.simpleimage.analyze.search.cluster.Clusterable;
import com.alibaba.simpleimage.analyze.search.cluster.impl.AbstractClusterBuilder;
import com.alibaba.simpleimage.analyze.search.cluster.impl.Cluster;
import com.alibaba.simpleimage.analyze.search.util.ClusterUtils;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MeansClusterBuilder
extends AbstractClusterBuilder {
    @Override
    protected Clusterable[] assignClusters(Clusterable[] clusters, List<? extends Clusterable> values) {
        this.assignClustersByDistance(clusters, values);
        return clusters;
    }

    protected void assignClustersByDistance(Clusterable[] clusters, List<? extends Clusterable> values) {
        for (int j = 0; j < values.size(); ++j) {
            Clusterable val = values.get(j);
            Clusterable nearestCluster = null;
            float minDistance = Float.MAX_VALUE;
            for (int i = 0; i < clusters.length; ++i) {
                Clusterable cluster = clusters[i];
                float distance = ClusterUtils.getEuclideanDistance(val, cluster);
                if (!(distance < minDistance)) continue;
                nearestCluster = cluster;
                minDistance = distance;
            }
            ((Cluster)nearestCluster).addItem(val);
        }
    }

    @Override
    protected Clusterable[] getNewClusters(Clusterable[] clusters) {
        for (int i = 0; i < clusters.length; ++i) {
            if (((Cluster)clusters[i]).getItems().size() <= 0) continue;
            clusters[i] = new Cluster(((Cluster)clusters[i]).getClusterMean(), i);
        }
        return clusters;
    }

    public static void main(String[] args) {
    }

    public static boolean hasBadValue(float[] values) {
        for (float value : values) {
            if (value < 1.0f && value > -1.0f) continue;
            return true;
        }
        return false;
    }
}

