/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.simpleimage.analyze.search.util;

import com.alibaba.simpleimage.analyze.search.cluster.Clusterable;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClusterUtils {
    public static float getEuclideanDistance(double[] a, double[] b) {
        if (a.length != b.length) {
            throw new RuntimeException("Attempting to compare two clusterables of different dimensions");
        }
        double sum = 0.0;
        for (int i = 0; i < a.length; ++i) {
            double diff = a[i] - b[i];
            sum += diff * diff;
        }
        return (float)Math.sqrt(sum);
    }

    public static float getEuclideanDistance(float[] a, float[] b) {
        if (a.length != b.length) {
            throw new RuntimeException("Attempting to compare two clusterables of different dimensions");
        }
        float sum = 0.0f;
        for (int i = 0; i < a.length; ++i) {
            float diff = a[i] - b[i];
            sum += diff * diff;
        }
        return (float)Math.sqrt(sum);
    }

    public static float getEuclideanDistance(Clusterable a, Clusterable b) {
        return ClusterUtils.getEuclideanDistance(a.getLocation(), b.getLocation());
    }

    public static float sumDifferences(List<Double> a, List<Double> b) {
        assert (a.size() == b.size());
        float sumDiff = 0.0f;
        for (int i = 0; i < a.size(); ++i) {
            sumDiff = (float)((double)sumDiff + Math.abs(a.get(i) - b.get(i)));
        }
        return sumDiff;
    }
}

