/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.simpleimage.codec.jpeg.ext;

import com.alibaba.simpleimage.codec.ExtendImageHeaderReader;
import com.alibaba.simpleimage.codec.jpeg.MarkerConstants;
import com.alibaba.simpleimage.codec.jpeg.ext.ExtendImageHeader;
import com.alibaba.simpleimage.io.ImageInputStream;
import java.io.IOException;

public class ICCProfileReader
implements ExtendImageHeaderReader {
    private int numOfRed = 0;
    private int numOfChunks = 0;
    private int totalLength = 0;
    private boolean errorOnParse = false;
    private byte[][] rawProfileData;
    private byte[] profileData;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readProperties(ImageInputStream in, int len, ExtendImageHeader imageHeader) throws IOException {
        try {
            if (len < MarkerConstants.ICC_PROFILE_LABEL.length) {
                return;
            }
            if (this.errorOnParse) {
                return;
            }
            byte[] label = new byte[MarkerConstants.ICC_PROFILE_LABEL.length];
            in.read(label);
            len -= label.length;
            if (!this.isICCProfileLabel(label)) {
                return;
            }
            int seq = in.read();
            int nums = in.read();
            len -= 2;
            if (this.numOfChunks == 0) {
                this.numOfChunks = nums;
            } else if (nums != this.numOfChunks) {
                this.errorOnParse = true;
                return;
            }
            if (seq > this.numOfChunks) {
                this.errorOnParse = true;
                return;
            }
            byte[] data = new byte[len];
            in.read(data);
            len = 0;
            if (this.rawProfileData == null) {
                this.rawProfileData = new byte[this.numOfChunks + 1][];
            }
            this.rawProfileData[seq] = data;
            this.totalLength += data.length;
            ++this.numOfRed;
            if (this.numOfRed == this.numOfChunks) {
                imageHeader.setExistProfile(true);
                imageHeader.setProfileData(this.getProfileData());
            }
        }
        finally {
            if (len > 0) {
                in.skipBytes(len);
            }
        }
    }

    protected boolean isICCProfileLabel(byte[] label) throws IOException {
        if (label.length != MarkerConstants.ICC_PROFILE_LABEL.length) {
            return false;
        }
        for (int i = 0; i < label.length; ++i) {
            if (label[i] == MarkerConstants.ICC_PROFILE_LABEL[i]) continue;
            return false;
        }
        return true;
    }

    public byte[] getProfileData() {
        if (this.errorOnParse) {
            return null;
        }
        if (this.profileData == null) {
            this.profileData = new byte[this.totalLength];
            int destPos = 0;
            for (int i = 0; i <= this.numOfChunks; ++i) {
                if (this.rawProfileData[i] == null) continue;
                System.arraycopy(this.rawProfileData[i], 0, this.profileData, destPos, this.rawProfileData[i].length);
                destPos += this.rawProfileData[i].length;
            }
        }
        return this.profileData;
    }
}

