/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.simpleimage.font;

import java.awt.Font;
import java.awt.FontFormatException;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class FontLoader {
    private volatile Font font;
    protected String name;
    protected int fontType;
    protected String path;
    protected final Lock lock = new ReentrantLock();

    public FontLoader(String name, int fontType, String path) {
        this.name = name;
        this.fontType = fontType;
        this.path = path;
    }

    public FontLoader(String name, String path) {
        this(name, 0, path);
    }

    protected Font loadFont(String path) {
        return this.loadFont(0, path);
    }

    public String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Font getFont() {
        if (this.font == null) {
            this.lock.lock();
            try {
                if (this.font == null) {
                    this.font = this.loadFont(this.fontType, this.path);
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        return this.font;
    }

    protected Font loadFont(int fontType, String path) {
        InputStream fontStream = null;
        try {
            fontStream = FontLoader.class.getResourceAsStream(path);
            Font font = Font.createFont(fontType, fontStream);
            return font;
        }
        catch (FontFormatException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (fontStream != null) {
                try {
                    fontStream.close();
                }
                catch (IOException ignore) {}
            }
        }
    }
}

