/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.simpleimage.jai.scale;

import com.alibaba.simpleimage.jai.scale.LanczosContributionInfo;
import com.alibaba.simpleimage.jai.scale.LanczosResizeFilter;
import com.alibaba.simpleimage.util.ImageUtils;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import javax.media.jai.RasterAccessor;
import javax.media.jai.RasterFormatTag;

public class LanczosScaleOp {
    static final double WORK_LOAD_FACTOR = 0.265;
    protected double scaleX;
    protected double scaleY;
    protected LanczosResizeFilter filter;
    protected double scaleFactor;
    protected Rectangle filterRect;
    protected Rectangle destRect;
    protected int destWidth;
    protected int destHeight;

    public LanczosScaleOp(double scaleX, double scaleY) {
        this.scaleX = scaleX;
        this.scaleY = scaleY;
        this.filter = new LanczosResizeFilter();
        this.scaleFactor = this.scaleX * this.scaleY;
    }

    public BufferedImage compute(BufferedImage src) {
        this.destWidth = (int)((double)src.getWidth() * this.scaleX);
        this.destHeight = (int)((double)src.getHeight() * this.scaleY);
        if (this.destWidth <= 0) {
            this.destWidth = 1;
        }
        if (this.destHeight <= 0) {
            this.destHeight = 1;
        }
        this.destRect = new Rectangle(this.destWidth, this.destHeight);
        this.filterRect = this.scaleFactor > 0.265 ? new Rectangle(this.destWidth, src.getHeight()) : new Rectangle(src.getWidth(), this.destHeight);
        WritableRaster srcRst = src.getRaster();
        ColorModel srcCM = src.getColorModel();
        SampleModel destSM = src.getSampleModel().createCompatibleSampleModel(this.destRect.width, this.destRect.height);
        WritableRaster destRst = Raster.createWritableRaster(destSM, this.destRect.getLocation());
        SampleModel filterSM = src.getSampleModel().createCompatibleSampleModel(this.filterRect.width, this.filterRect.height);
        WritableRaster filterRst = Raster.createWritableRaster(filterSM, this.filterRect.getLocation());
        BufferedImage dest = new BufferedImage(srcCM, destRst, src.isAlphaPremultiplied(), null);
        RasterFormatTag[] formatTags = RasterAccessor.findCompatibleTags((RenderedImage[])new RenderedImage[]{src}, (RenderedImage)dest);
        RasterAccessor srcRA = new RasterAccessor((Raster)srcRst, srcRst.getBounds(), formatTags[0], src.getColorModel());
        RasterAccessor filterRA = new RasterAccessor((Raster)filterRst, this.filterRect, formatTags[1], src.getColorModel());
        RasterAccessor dstRA = new RasterAccessor((Raster)destRst, this.destRect, formatTags[1], dest.getColorModel());
        switch (dstRA.getDataType()) {
            case 0: {
                this.computeRectByte(srcRA, filterRA, dstRA);
                break;
            }
            case 1: {
                this.computeRectUShort(srcRA, filterRA, dstRA);
                break;
            }
            case 2: {
                this.computeRectShort(srcRA, filterRA, dstRA);
                break;
            }
            case 3: {
                this.computeRectInt(srcRA, filterRA, dstRA);
                break;
            }
            case 4: {
                this.computeRectFloat(srcRA, filterRA, dstRA);
                break;
            }
            case 5: {
                this.computeRectDouble(srcRA, filterRA, dstRA);
                break;
            }
            default: {
                throw new IllegalArgumentException("");
            }
        }
        return dest;
    }

    private void computeRectByte(RasterAccessor src, RasterAccessor mid, RasterAccessor dst) {
        if (this.scaleFactor > 0.265) {
            this.lanczosHorizontalFilterByte(src, mid);
            this.lanczosVerticalFilterByte(mid, dst);
        } else {
            this.lanczosVerticalFilterByte(src, mid);
            this.lanczosHorizontalFilterByte(mid, dst);
        }
    }

    private void computeRectUShort(RasterAccessor src, RasterAccessor mid, RasterAccessor dst) {
        if (this.scaleFactor > 0.265) {
            this.lanczosHorizontalFilterUShort(src, mid);
            this.lanczosVerticalFilterUShort(mid, dst);
        } else {
            this.lanczosVerticalFilterUShort(src, mid);
            this.lanczosHorizontalFilterUShort(mid, dst);
        }
    }

    private void computeRectShort(RasterAccessor src, RasterAccessor mid, RasterAccessor dst) {
        if (this.scaleFactor > 0.265) {
            this.lanczosHorizontalFilterShort(src, mid);
            this.lanczosVerticalFilterShort(mid, dst);
        } else {
            this.lanczosVerticalFilterShort(src, mid);
            this.lanczosHorizontalFilterShort(mid, dst);
        }
    }

    private void computeRectInt(RasterAccessor src, RasterAccessor mid, RasterAccessor dst) {
        if (this.scaleFactor > 0.265) {
            this.lanczosHorizontalFilterInt(src, mid);
            this.lanczosVerticalFilterInt(mid, dst);
        } else {
            this.lanczosVerticalFilterInt(src, mid);
            this.lanczosHorizontalFilterInt(mid, dst);
        }
    }

    private void computeRectFloat(RasterAccessor src, RasterAccessor mid, RasterAccessor dst) {
        if (this.scaleFactor > 0.265) {
            this.lanczosHorizontalFilterFloat(src, mid);
            this.lanczosVerticalFilterFloat(mid, dst);
        } else {
            this.lanczosVerticalFilterFloat(src, mid);
            this.lanczosHorizontalFilterFloat(mid, dst);
        }
    }

    private void computeRectDouble(RasterAccessor src, RasterAccessor mid, RasterAccessor dst) {
        if (this.scaleFactor > 0.265) {
            this.lanczosHorizontalFilterDouble(src, mid);
            this.lanczosVerticalFilterDouble(mid, dst);
        } else {
            this.lanczosVerticalFilterDouble(src, mid);
            this.lanczosHorizontalFilterDouble(mid, dst);
        }
    }

    private void lanczosHorizontalFilterByte(RasterAccessor src, RasterAccessor dst) {
        double scale = Math.max(1.0 / this.scaleX, 1.0);
        double support = scale * this.filter.getSupport() * this.filter.getBlur();
        if (support < 0.5) {
            support = 0.5;
            scale = 1.0;
        }
        byte[][] srcDataArrays = src.getByteDataArrays();
        byte[][] dstDataArrays = dst.getByteDataArrays();
        double[] pixel = new double[]{0.0, 0.0, 0.0, 0.0};
        int channel = src.getNumBands();
        scale = 1.0 / scale;
        int contributionsNum = (int)(2.0 * support + 3.0);
        LanczosContributionInfo[] contribution = new LanczosContributionInfo[contributionsNum];
        for (int t = 0; t < contributionsNum; ++t) {
            contribution[t] = new LanczosContributionInfo();
        }
        int dstWidth = dst.getWidth();
        int dstHeight = dst.getHeight();
        int srcWidth = src.getWidth();
        int dstScanlineStride = dst.getScanlineStride();
        int srcScanlineStride = src.getScanlineStride();
        for (int x = 0; x < dstWidth; ++x) {
            int tmp4;
            int i;
            int tmp6;
            int y;
            int n;
            double center = ((double)x + 0.5) / this.scaleX;
            double t1 = center - support + 0.5;
            double t2 = center + support + 0.5;
            int start = (int)(t1 > 0.0 ? t1 : 0.0);
            int stop = (int)(t2 < (double)srcWidth ? t2 : (double)srcWidth);
            double density = 0.0;
            for (n = 0; n < stop - start; ++n) {
                contribution[n].pixel = start + n;
                contribution[n].weight = this.getLanczosResizeFilterWeight(scale * ((double)(start + n) - center + 0.5));
                density += contribution[n].weight;
            }
            if (density != 0.0 && density != 1.0) {
                density = 1.0 / density;
                for (int i2 = 0; i2 < n; ++i2) {
                    contribution[i2].weight *= density;
                }
            }
            int tmp3 = x * channel;
            int tmp5 = ((int)((double)start - center) + (int)center) * channel;
            if (channel == 3) {
                for (y = 0; y < dstHeight; ++y) {
                    pixel[0] = 0.0;
                    pixel[1] = 0.0;
                    pixel[2] = 0.0;
                    tmp6 = tmp5;
                    for (i = 0; i < n; ++i) {
                        pixel[0] = pixel[0] + (double)(srcDataArrays[0][tmp6++] & 0xFF) * contribution[i].weight;
                        pixel[1] = pixel[1] + (double)(srcDataArrays[1][tmp6++] & 0xFF) * contribution[i].weight;
                        pixel[2] = pixel[2] + (double)(srcDataArrays[2][tmp6++] & 0xFF) * contribution[i].weight;
                    }
                    tmp4 = tmp3;
                    dstDataArrays[0][tmp4++] = ImageUtils.clampRoundByte(pixel[0]);
                    dstDataArrays[1][tmp4++] = ImageUtils.clampRoundByte(pixel[1]);
                    dstDataArrays[2][tmp4] = ImageUtils.clampRoundByte(pixel[2]);
                    tmp3 += dstScanlineStride;
                    tmp5 += srcScanlineStride;
                }
                continue;
            }
            if (channel == 1) {
                for (y = 0; y < dstHeight; ++y) {
                    pixel[0] = 0.0;
                    tmp6 = tmp5;
                    for (i = 0; i < n; ++i) {
                        pixel[0] = pixel[0] + (double)(srcDataArrays[0][tmp6++] & 0xFF) * contribution[i].weight;
                    }
                    dstDataArrays[0][tmp3] = ImageUtils.clampRoundByte(pixel[0]);
                    tmp3 += dstScanlineStride;
                    tmp5 += srcScanlineStride;
                }
                continue;
            }
            if (channel == 4) {
                for (y = 0; y < dstHeight; ++y) {
                    pixel[0] = 0.0;
                    pixel[1] = 0.0;
                    pixel[2] = 0.0;
                    pixel[3] = 0.0;
                    tmp6 = tmp5;
                    for (i = 0; i < n; ++i) {
                        pixel[0] = pixel[0] + (double)(srcDataArrays[0][tmp6++] & 0xFF) * contribution[i].weight;
                        pixel[1] = pixel[1] + (double)(srcDataArrays[1][tmp6++] & 0xFF) * contribution[i].weight;
                        pixel[2] = pixel[2] + (double)(srcDataArrays[2][tmp6++] & 0xFF) * contribution[i].weight;
                        pixel[3] = pixel[3] + (double)(srcDataArrays[3][tmp6++] & 0xFF) * contribution[i].weight;
                    }
                    tmp4 = tmp3;
                    dstDataArrays[0][tmp4++] = ImageUtils.clampRoundByte(pixel[0]);
                    dstDataArrays[1][tmp4++] = ImageUtils.clampRoundByte(pixel[1]);
                    dstDataArrays[2][tmp4++] = ImageUtils.clampRoundByte(pixel[2]);
                    dstDataArrays[3][tmp4] = ImageUtils.clampRoundByte(pixel[3]);
                    tmp3 += dstScanlineStride;
                    tmp5 += srcScanlineStride;
                }
                continue;
            }
            throw new IllegalArgumentException("Unsupported channels num : " + channel);
        }
    }

    private void lanczosVerticalFilterByte(RasterAccessor src, RasterAccessor dst) {
        double scale = Math.max(1.0 / this.scaleY, 1.0);
        double support = scale * this.filter.getSupport() * this.filter.getBlur();
        if (support < 0.5) {
            support = 0.5;
            scale = 1.0;
        }
        scale = 1.0 / scale;
        byte[][] srcDataArrays = src.getByteDataArrays();
        byte[][] dstDataArrays = dst.getByteDataArrays();
        double[] pixel = new double[]{0.0, 0.0, 0.0, 0.0};
        int channel = dst.getNumBands();
        int contributionNums = (int)(2.0 * support + 3.0);
        LanczosContributionInfo[] contribution = new LanczosContributionInfo[contributionNums];
        for (int t = 0; t < contributionNums; ++t) {
            contribution[t] = new LanczosContributionInfo();
        }
        int dstHeight = dst.getHeight();
        int dstWidth = dst.getWidth();
        int srcHeight = src.getHeight();
        int srcScanlineStride = src.getScanlineStride();
        int dstScanlineStride = dst.getScanlineStride();
        for (int y = 0; y < dstHeight; ++y) {
            int tmp7;
            int i;
            int tmp6;
            int x;
            int n;
            double center = ((double)y + 0.5) / this.scaleY;
            double t1 = center - support + 0.5;
            double t2 = center + support + 0.5;
            int start = (int)(t1 > 0.0 ? t1 : 0.0);
            int stop = (int)(t2 < (double)srcHeight ? t2 : (double)srcHeight);
            double density = 0.0;
            for (n = 0; n < stop - start; ++n) {
                contribution[n].pixel = start + n;
                contribution[n].weight = this.getLanczosResizeFilterWeight(scale * ((double)(start + n) - center + 0.5));
                density += contribution[n].weight;
            }
            if (density != 0.0 && density != 1.0) {
                density = 1.0 / density;
                for (int i2 = 0; i2 < n; ++i2) {
                    contribution[i2].weight *= density;
                }
            }
            int tmp3 = y * dstScanlineStride;
            int tmp5 = (int)center * srcScanlineStride + (int)((double)start - center) * srcScanlineStride;
            if (channel == 3) {
                for (x = 0; x < dstWidth; ++x) {
                    pixel[0] = 0.0;
                    pixel[1] = 0.0;
                    pixel[2] = 0.0;
                    tmp6 = tmp5;
                    for (i = 0; i < n; ++i) {
                        tmp7 = tmp6;
                        pixel[0] = pixel[0] + (double)(srcDataArrays[0][tmp7++] & 0xFF) * contribution[i].weight;
                        pixel[1] = pixel[1] + (double)(srcDataArrays[1][tmp7++] & 0xFF) * contribution[i].weight;
                        pixel[2] = pixel[2] + (double)(srcDataArrays[2][tmp7] & 0xFF) * contribution[i].weight;
                        tmp6 += srcScanlineStride;
                    }
                    dstDataArrays[0][tmp3++] = ImageUtils.clampRoundByte(pixel[0]);
                    dstDataArrays[1][tmp3++] = ImageUtils.clampRoundByte(pixel[1]);
                    dstDataArrays[2][tmp3++] = ImageUtils.clampRoundByte(pixel[2]);
                    tmp5 += channel;
                }
                continue;
            }
            if (channel == 1) {
                for (x = 0; x < dstWidth; ++x) {
                    pixel[0] = 0.0;
                    tmp6 = tmp5;
                    for (i = 0; i < n; ++i) {
                        pixel[0] = pixel[0] + (double)(srcDataArrays[0][tmp6] & 0xFF) * contribution[i].weight;
                        tmp6 += srcScanlineStride;
                    }
                    dstDataArrays[0][tmp3++] = ImageUtils.clampRoundByte(pixel[0]);
                    tmp5 += channel;
                }
                continue;
            }
            if (channel == 4) {
                for (x = 0; x < dstWidth; ++x) {
                    pixel[0] = 0.0;
                    pixel[1] = 0.0;
                    pixel[2] = 0.0;
                    pixel[3] = 0.0;
                    tmp6 = tmp5;
                    for (i = 0; i < n; ++i) {
                        tmp7 = tmp6;
                        pixel[0] = pixel[0] + (double)(srcDataArrays[0][tmp7++] & 0xFF) * contribution[i].weight;
                        pixel[1] = pixel[1] + (double)(srcDataArrays[1][tmp7++] & 0xFF) * contribution[i].weight;
                        pixel[2] = pixel[2] + (double)(srcDataArrays[2][tmp7++] & 0xFF) * contribution[i].weight;
                        pixel[3] = pixel[3] + (double)(srcDataArrays[3][tmp7] & 0xFF) * contribution[i].weight;
                        tmp6 += srcScanlineStride;
                    }
                    dstDataArrays[0][tmp3++] = ImageUtils.clampRoundByte(pixel[0]);
                    dstDataArrays[1][tmp3++] = ImageUtils.clampRoundByte(pixel[1]);
                    dstDataArrays[2][tmp3++] = ImageUtils.clampRoundByte(pixel[2]);
                    dstDataArrays[3][tmp3++] = ImageUtils.clampRoundByte(pixel[3]);
                    tmp5 += channel;
                }
                continue;
            }
            throw new IllegalArgumentException("Unsupported channels num : " + channel);
        }
    }

    private void lanczosHorizontalFilterUShort(RasterAccessor src, RasterAccessor dst) {
        double scale = Math.max(1.0 / this.scaleX, 1.0);
        double support = scale * this.filter.getSupport() * this.filter.getBlur();
        if (support < 0.5) {
            support = 0.5;
            scale = 1.0;
        }
        short[][] srcDataArrays = src.getShortDataArrays();
        short[][] dstDataArrays = dst.getShortDataArrays();
        double[] pixel = new double[]{0.0, 0.0, 0.0, 0.0};
        int channel = src.getNumBands();
        scale = 1.0 / scale;
        int contributionsNum = (int)(2.0 * support + 3.0);
        LanczosContributionInfo[] contribution = new LanczosContributionInfo[contributionsNum];
        for (int t = 0; t < contributionsNum; ++t) {
            contribution[t] = new LanczosContributionInfo();
        }
        int dstWidth = dst.getWidth();
        int dstHeight = dst.getHeight();
        int srcWidth = src.getWidth();
        int dstScanlineStride = dst.getScanlineStride();
        int srcScanlineStride = src.getScanlineStride();
        for (int x = 0; x < dstWidth; ++x) {
            int tmp4;
            int i;
            int tmp6;
            int y;
            int n;
            double center = ((double)x + 0.5) / this.scaleX;
            double t1 = center - support + 0.5;
            double t2 = center + support + 0.5;
            int start = (int)(t1 > 0.0 ? t1 : 0.0);
            int stop = (int)(t2 < (double)srcWidth ? t2 : (double)srcWidth);
            double density = 0.0;
            for (n = 0; n < stop - start; ++n) {
                contribution[n].pixel = start + n;
                contribution[n].weight = this.getLanczosResizeFilterWeight(scale * ((double)(start + n) - center + 0.5));
                density += contribution[n].weight;
            }
            if (density != 0.0 && density != 1.0) {
                density = 1.0 / density;
                for (int i2 = 0; i2 < n; ++i2) {
                    contribution[i2].weight *= density;
                }
            }
            int tmp3 = x * channel;
            int tmp5 = ((int)((double)start - center) + (int)center) * channel;
            if (channel == 3) {
                for (y = 0; y < dstHeight; ++y) {
                    pixel[0] = 0.0;
                    pixel[1] = 0.0;
                    pixel[2] = 0.0;
                    tmp6 = tmp5;
                    for (i = 0; i < n; ++i) {
                        pixel[0] = pixel[0] + (double)(srcDataArrays[0][tmp6++] & 0xFFFF) * contribution[i].weight;
                        pixel[1] = pixel[1] + (double)(srcDataArrays[1][tmp6++] & 0xFFFF) * contribution[i].weight;
                        pixel[2] = pixel[2] + (double)(srcDataArrays[2][tmp6++] & 0xFFFF) * contribution[i].weight;
                    }
                    tmp4 = tmp3;
                    dstDataArrays[0][tmp4++] = ImageUtils.clampRoundUShort(pixel[0]);
                    dstDataArrays[1][tmp4++] = ImageUtils.clampRoundUShort(pixel[1]);
                    dstDataArrays[2][tmp4] = ImageUtils.clampRoundUShort(pixel[2]);
                    tmp3 += dstScanlineStride;
                    tmp5 += srcScanlineStride;
                }
                continue;
            }
            if (channel == 1) {
                for (y = 0; y < dstHeight; ++y) {
                    pixel[0] = 0.0;
                    tmp6 = tmp5;
                    for (i = 0; i < n; ++i) {
                        pixel[0] = pixel[0] + (double)(srcDataArrays[0][tmp6++] & 0xFFFF) * contribution[i].weight;
                    }
                    dstDataArrays[0][tmp3] = ImageUtils.clampRoundUShort(pixel[0]);
                    tmp3 += dstScanlineStride;
                    tmp5 += srcScanlineStride;
                }
                continue;
            }
            if (channel == 4) {
                for (y = 0; y < dstHeight; ++y) {
                    pixel[0] = 0.0;
                    pixel[1] = 0.0;
                    pixel[2] = 0.0;
                    pixel[3] = 0.0;
                    tmp6 = tmp5;
                    for (i = 0; i < n; ++i) {
                        pixel[0] = pixel[0] + (double)(srcDataArrays[0][tmp6++] & 0xFFFF) * contribution[i].weight;
                        pixel[1] = pixel[1] + (double)(srcDataArrays[1][tmp6++] & 0xFFFF) * contribution[i].weight;
                        pixel[2] = pixel[2] + (double)(srcDataArrays[2][tmp6++] & 0xFFFF) * contribution[i].weight;
                        pixel[3] = pixel[3] + (double)(srcDataArrays[3][tmp6++] & 0xFFFF) * contribution[i].weight;
                    }
                    tmp4 = tmp3;
                    dstDataArrays[0][tmp4++] = ImageUtils.clampRoundUShort(pixel[0]);
                    dstDataArrays[1][tmp4++] = ImageUtils.clampRoundUShort(pixel[1]);
                    dstDataArrays[2][tmp4++] = ImageUtils.clampRoundUShort(pixel[2]);
                    dstDataArrays[3][tmp4] = ImageUtils.clampRoundUShort(pixel[3]);
                    tmp3 += dstScanlineStride;
                    tmp5 += srcScanlineStride;
                }
                continue;
            }
            throw new IllegalArgumentException("Unsupported channels num : " + channel);
        }
    }

    private void lanczosVerticalFilterUShort(RasterAccessor src, RasterAccessor dst) {
        double scale = Math.max(1.0 / this.scaleY, 1.0);
        double support = scale * this.filter.getSupport() * this.filter.getBlur();
        if (support < 0.5) {
            support = 0.5;
            scale = 1.0;
        }
        scale = 1.0 / scale;
        short[][] srcDataArrays = src.getShortDataArrays();
        short[][] dstDataArrays = dst.getShortDataArrays();
        double[] pixel = new double[]{0.0, 0.0, 0.0, 0.0};
        int channel = dst.getNumBands();
        int contributionNums = (int)(2.0 * support + 3.0);
        LanczosContributionInfo[] contribution = new LanczosContributionInfo[contributionNums];
        for (int t = 0; t < contributionNums; ++t) {
            contribution[t] = new LanczosContributionInfo();
        }
        int dstHeight = dst.getHeight();
        int dstWidth = dst.getWidth();
        int srcHeight = src.getHeight();
        int srcScanlineStride = src.getScanlineStride();
        int dstScanlineStride = dst.getScanlineStride();
        for (int y = 0; y < dstHeight; ++y) {
            int tmp7;
            int i;
            int tmp6;
            int x;
            int n;
            double center = ((double)y + 0.5) / this.scaleY;
            double t1 = center - support + 0.5;
            double t2 = center + support + 0.5;
            int start = (int)(t1 > 0.0 ? t1 : 0.0);
            int stop = (int)(t2 < (double)srcHeight ? t2 : (double)srcHeight);
            double density = 0.0;
            for (n = 0; n < stop - start; ++n) {
                contribution[n].pixel = start + n;
                contribution[n].weight = this.getLanczosResizeFilterWeight(scale * ((double)(start + n) - center + 0.5));
                density += contribution[n].weight;
            }
            if (density != 0.0 && density != 1.0) {
                density = 1.0 / density;
                for (int i2 = 0; i2 < n; ++i2) {
                    contribution[i2].weight *= density;
                }
            }
            int tmp3 = y * dstScanlineStride;
            int tmp5 = (int)center * srcScanlineStride + (int)((double)start - center) * srcScanlineStride;
            if (channel == 3) {
                for (x = 0; x < dstWidth; ++x) {
                    pixel[0] = 0.0;
                    pixel[1] = 0.0;
                    pixel[2] = 0.0;
                    tmp6 = tmp5;
                    for (i = 0; i < n; ++i) {
                        tmp7 = tmp6;
                        pixel[0] = pixel[0] + (double)(srcDataArrays[0][tmp7++] & 0xFFFF) * contribution[i].weight;
                        pixel[1] = pixel[1] + (double)(srcDataArrays[1][tmp7++] & 0xFFFF) * contribution[i].weight;
                        pixel[2] = pixel[2] + (double)(srcDataArrays[2][tmp7] & 0xFFFF) * contribution[i].weight;
                        tmp6 += srcScanlineStride;
                    }
                    dstDataArrays[0][tmp3++] = ImageUtils.clampRoundUShort(pixel[0]);
                    dstDataArrays[1][tmp3++] = ImageUtils.clampRoundUShort(pixel[1]);
                    dstDataArrays[2][tmp3++] = ImageUtils.clampRoundUShort(pixel[2]);
                    tmp5 += channel;
                }
                continue;
            }
            if (channel == 1) {
                for (x = 0; x < dstWidth; ++x) {
                    pixel[0] = 0.0;
                    tmp6 = tmp5;
                    for (i = 0; i < n; ++i) {
                        pixel[0] = pixel[0] + (double)(srcDataArrays[0][tmp6] & 0xFFFF) * contribution[i].weight;
                        tmp6 += srcScanlineStride;
                    }
                    dstDataArrays[0][tmp3++] = ImageUtils.clampRoundUShort(pixel[0]);
                    tmp5 += channel;
                }
                continue;
            }
            if (channel == 4) {
                for (x = 0; x < dstWidth; ++x) {
                    pixel[0] = 0.0;
                    pixel[1] = 0.0;
                    pixel[2] = 0.0;
                    pixel[3] = 0.0;
                    tmp6 = tmp5;
                    for (i = 0; i < n; ++i) {
                        tmp7 = tmp6;
                        pixel[0] = pixel[0] + (double)(srcDataArrays[0][tmp7++] & 0xFFFF) * contribution[i].weight;
                        pixel[1] = pixel[1] + (double)(srcDataArrays[1][tmp7++] & 0xFFFF) * contribution[i].weight;
                        pixel[2] = pixel[2] + (double)(srcDataArrays[2][tmp7++] & 0xFFFF) * contribution[i].weight;
                        pixel[3] = pixel[3] + (double)(srcDataArrays[3][tmp7] & 0xFFFF) * contribution[i].weight;
                        tmp6 += srcScanlineStride;
                    }
                    dstDataArrays[0][tmp3++] = ImageUtils.clampRoundUShort(pixel[0]);
                    dstDataArrays[1][tmp3++] = ImageUtils.clampRoundUShort(pixel[1]);
                    dstDataArrays[2][tmp3++] = ImageUtils.clampRoundUShort(pixel[2]);
                    dstDataArrays[3][tmp3++] = ImageUtils.clampRoundUShort(pixel[3]);
                    tmp5 += channel;
                }
                continue;
            }
            throw new IllegalArgumentException("Unsupported channels num : " + channel);
        }
    }

    private void lanczosHorizontalFilterShort(RasterAccessor src, RasterAccessor dst) {
        double scale = Math.max(1.0 / this.scaleX, 1.0);
        double support = scale * this.filter.getSupport() * this.filter.getBlur();
        if (support < 0.5) {
            support = 0.5;
            scale = 1.0;
        }
        short[][] srcDataArrays = src.getShortDataArrays();
        short[][] dstDataArrays = dst.getShortDataArrays();
        double[] pixel = new double[]{0.0, 0.0, 0.0, 0.0};
        int channel = src.getNumBands();
        scale = 1.0 / scale;
        int contributionsNum = (int)(2.0 * support + 3.0);
        LanczosContributionInfo[] contribution = new LanczosContributionInfo[contributionsNum];
        for (int t = 0; t < contributionsNum; ++t) {
            contribution[t] = new LanczosContributionInfo();
        }
        int dstWidth = dst.getWidth();
        int dstHeight = dst.getHeight();
        int srcWidth = src.getWidth();
        int dstScanlineStride = dst.getScanlineStride();
        int srcScanlineStride = src.getScanlineStride();
        for (int x = 0; x < dstWidth; ++x) {
            int tmp4;
            int i;
            int tmp6;
            int y;
            int n;
            double center = ((double)x + 0.5) / this.scaleX;
            double t1 = center - support + 0.5;
            double t2 = center + support + 0.5;
            int start = (int)(t1 > 0.0 ? t1 : 0.0);
            int stop = (int)(t2 < (double)srcWidth ? t2 : (double)srcWidth);
            double density = 0.0;
            for (n = 0; n < stop - start; ++n) {
                contribution[n].pixel = start + n;
                contribution[n].weight = this.getLanczosResizeFilterWeight(scale * ((double)(start + n) - center + 0.5));
                density += contribution[n].weight;
            }
            if (density != 0.0 && density != 1.0) {
                density = 1.0 / density;
                for (int i2 = 0; i2 < n; ++i2) {
                    contribution[i2].weight *= density;
                }
            }
            int tmp3 = x * channel;
            int tmp5 = ((int)((double)start - center) + (int)center) * channel;
            if (channel == 3) {
                for (y = 0; y < dstHeight; ++y) {
                    pixel[0] = 0.0;
                    pixel[1] = 0.0;
                    pixel[2] = 0.0;
                    tmp6 = tmp5;
                    for (i = 0; i < n; ++i) {
                        pixel[0] = pixel[0] + (double)srcDataArrays[0][tmp6++] * contribution[i].weight;
                        pixel[1] = pixel[1] + (double)srcDataArrays[1][tmp6++] * contribution[i].weight;
                        pixel[2] = pixel[2] + (double)srcDataArrays[2][tmp6++] * contribution[i].weight;
                    }
                    tmp4 = tmp3;
                    dstDataArrays[0][tmp4++] = ImageUtils.clampRoundShort(pixel[0]);
                    dstDataArrays[1][tmp4++] = ImageUtils.clampRoundShort(pixel[1]);
                    dstDataArrays[2][tmp4] = ImageUtils.clampRoundShort(pixel[2]);
                    tmp3 += dstScanlineStride;
                    tmp5 += srcScanlineStride;
                }
                continue;
            }
            if (channel == 1) {
                for (y = 0; y < dstHeight; ++y) {
                    pixel[0] = 0.0;
                    tmp6 = tmp5;
                    for (i = 0; i < n; ++i) {
                        pixel[0] = pixel[0] + (double)srcDataArrays[0][tmp6++] * contribution[i].weight;
                    }
                    dstDataArrays[0][tmp3] = ImageUtils.clampRoundShort(pixel[0]);
                    tmp3 += dstScanlineStride;
                    tmp5 += srcScanlineStride;
                }
                continue;
            }
            if (channel == 4) {
                for (y = 0; y < dstHeight; ++y) {
                    pixel[0] = 0.0;
                    pixel[1] = 0.0;
                    pixel[2] = 0.0;
                    pixel[3] = 0.0;
                    tmp6 = tmp5;
                    for (i = 0; i < n; ++i) {
                        pixel[0] = pixel[0] + (double)srcDataArrays[0][tmp6++] * contribution[i].weight;
                        pixel[1] = pixel[1] + (double)srcDataArrays[1][tmp6++] * contribution[i].weight;
                        pixel[2] = pixel[2] + (double)srcDataArrays[2][tmp6++] * contribution[i].weight;
                        pixel[3] = pixel[3] + (double)srcDataArrays[3][tmp6++] * contribution[i].weight;
                    }
                    tmp4 = tmp3;
                    dstDataArrays[0][tmp4++] = ImageUtils.clampRoundShort(pixel[0]);
                    dstDataArrays[1][tmp4++] = ImageUtils.clampRoundShort(pixel[1]);
                    dstDataArrays[2][tmp4++] = ImageUtils.clampRoundShort(pixel[2]);
                    dstDataArrays[3][tmp4] = ImageUtils.clampRoundShort(pixel[3]);
                    tmp3 += dstScanlineStride;
                    tmp5 += srcScanlineStride;
                }
                continue;
            }
            throw new IllegalArgumentException("Unsupported channels num : " + channel);
        }
    }

    private void lanczosVerticalFilterShort(RasterAccessor src, RasterAccessor dst) {
        double scale = Math.max(1.0 / this.scaleY, 1.0);
        double support = scale * this.filter.getSupport() * this.filter.getBlur();
        if (support < 0.5) {
            support = 0.5;
            scale = 1.0;
        }
        scale = 1.0 / scale;
        short[][] srcDataArrays = src.getShortDataArrays();
        short[][] dstDataArrays = dst.getShortDataArrays();
        double[] pixel = new double[]{0.0, 0.0, 0.0, 0.0};
        int channel = dst.getNumBands();
        int contributionNums = (int)(2.0 * support + 3.0);
        LanczosContributionInfo[] contribution = new LanczosContributionInfo[contributionNums];
        for (int t = 0; t < contributionNums; ++t) {
            contribution[t] = new LanczosContributionInfo();
        }
        int dstHeight = dst.getHeight();
        int dstWidth = dst.getWidth();
        int srcHeight = src.getHeight();
        int srcScanlineStride = src.getScanlineStride();
        int dstScanlineStride = dst.getScanlineStride();
        for (int y = 0; y < dstHeight; ++y) {
            int tmp7;
            int i;
            int tmp6;
            int x;
            int n;
            double center = ((double)y + 0.5) / this.scaleY;
            double t1 = center - support + 0.5;
            double t2 = center + support + 0.5;
            int start = (int)(t1 > 0.0 ? t1 : 0.0);
            int stop = (int)(t2 < (double)srcHeight ? t2 : (double)srcHeight);
            double density = 0.0;
            for (n = 0; n < stop - start; ++n) {
                contribution[n].pixel = start + n;
                contribution[n].weight = this.getLanczosResizeFilterWeight(scale * ((double)(start + n) - center + 0.5));
                density += contribution[n].weight;
            }
            if (density != 0.0 && density != 1.0) {
                density = 1.0 / density;
                for (int i2 = 0; i2 < n; ++i2) {
                    contribution[i2].weight *= density;
                }
            }
            int tmp3 = y * dstScanlineStride;
            int tmp5 = (int)center * srcScanlineStride + (int)((double)start - center) * srcScanlineStride;
            if (channel == 3) {
                for (x = 0; x < dstWidth; ++x) {
                    pixel[0] = 0.0;
                    pixel[1] = 0.0;
                    pixel[2] = 0.0;
                    tmp6 = tmp5;
                    for (i = 0; i < n; ++i) {
                        tmp7 = tmp6;
                        pixel[0] = pixel[0] + (double)srcDataArrays[0][tmp7++] * contribution[i].weight;
                        pixel[1] = pixel[1] + (double)srcDataArrays[1][tmp7++] * contribution[i].weight;
                        pixel[2] = pixel[2] + (double)srcDataArrays[2][tmp7] * contribution[i].weight;
                        tmp6 += srcScanlineStride;
                    }
                    dstDataArrays[0][tmp3++] = ImageUtils.clampRoundShort(pixel[0]);
                    dstDataArrays[1][tmp3++] = ImageUtils.clampRoundShort(pixel[1]);
                    dstDataArrays[2][tmp3++] = ImageUtils.clampRoundShort(pixel[2]);
                    tmp5 += channel;
                }
                continue;
            }
            if (channel == 1) {
                for (x = 0; x < dstWidth; ++x) {
                    pixel[0] = 0.0;
                    tmp6 = tmp5;
                    for (i = 0; i < n; ++i) {
                        pixel[0] = pixel[0] + (double)srcDataArrays[0][tmp6] * contribution[i].weight;
                        tmp6 += srcScanlineStride;
                    }
                    dstDataArrays[0][tmp3++] = ImageUtils.clampRoundShort(pixel[0]);
                    tmp5 += channel;
                }
                continue;
            }
            if (channel == 4) {
                for (x = 0; x < dstWidth; ++x) {
                    pixel[0] = 0.0;
                    pixel[1] = 0.0;
                    pixel[2] = 0.0;
                    pixel[3] = 0.0;
                    tmp6 = tmp5;
                    for (i = 0; i < n; ++i) {
                        tmp7 = tmp6;
                        pixel[0] = pixel[0] + (double)srcDataArrays[0][tmp7++] * contribution[i].weight;
                        pixel[1] = pixel[1] + (double)srcDataArrays[1][tmp7++] * contribution[i].weight;
                        pixel[2] = pixel[2] + (double)srcDataArrays[2][tmp7++] * contribution[i].weight;
                        pixel[3] = pixel[3] + (double)srcDataArrays[3][tmp7] * contribution[i].weight;
                        tmp6 += srcScanlineStride;
                    }
                    dstDataArrays[0][tmp3++] = ImageUtils.clampRoundShort(pixel[0]);
                    dstDataArrays[1][tmp3++] = ImageUtils.clampRoundShort(pixel[1]);
                    dstDataArrays[2][tmp3++] = ImageUtils.clampRoundShort(pixel[2]);
                    dstDataArrays[3][tmp3++] = ImageUtils.clampRoundShort(pixel[3]);
                    tmp5 += channel;
                }
                continue;
            }
            throw new IllegalArgumentException("Unsupported channels num : " + channel);
        }
    }

    private void lanczosHorizontalFilterInt(RasterAccessor src, RasterAccessor dst) {
        double scale = Math.max(1.0 / this.scaleX, 1.0);
        double support = scale * this.filter.getSupport() * this.filter.getBlur();
        if (support < 0.5) {
            support = 0.5;
            scale = 1.0;
        }
        int[][] srcDataArrays = src.getIntDataArrays();
        int[][] dstDataArrays = dst.getIntDataArrays();
        double[] pixel = new double[]{0.0, 0.0, 0.0, 0.0};
        int channel = src.getNumBands();
        scale = 1.0 / scale;
        int contributionsNum = (int)(2.0 * support + 3.0);
        LanczosContributionInfo[] contribution = new LanczosContributionInfo[contributionsNum];
        for (int t = 0; t < contributionsNum; ++t) {
            contribution[t] = new LanczosContributionInfo();
        }
        int dstWidth = dst.getWidth();
        int dstHeight = dst.getHeight();
        int srcWidth = src.getWidth();
        int dstScanlineStride = dst.getScanlineStride();
        int srcScanlineStride = src.getScanlineStride();
        for (int x = 0; x < dstWidth; ++x) {
            int tmp4;
            int i;
            int tmp6;
            int y;
            int n;
            double center = ((double)x + 0.5) / this.scaleX;
            double t1 = center - support + 0.5;
            double t2 = center + support + 0.5;
            int start = (int)(t1 > 0.0 ? t1 : 0.0);
            int stop = (int)(t2 < (double)srcWidth ? t2 : (double)srcWidth);
            double density = 0.0;
            for (n = 0; n < stop - start; ++n) {
                contribution[n].pixel = start + n;
                contribution[n].weight = this.getLanczosResizeFilterWeight(scale * ((double)(start + n) - center + 0.5));
                density += contribution[n].weight;
            }
            if (density != 0.0 && density != 1.0) {
                density = 1.0 / density;
                for (int i2 = 0; i2 < n; ++i2) {
                    contribution[i2].weight *= density;
                }
            }
            int tmp3 = x * channel;
            int tmp5 = ((int)((double)start - center) + (int)center) * channel;
            if (channel == 3) {
                for (y = 0; y < dstHeight; ++y) {
                    pixel[0] = 0.0;
                    pixel[1] = 0.0;
                    pixel[2] = 0.0;
                    tmp6 = tmp5;
                    for (i = 0; i < n; ++i) {
                        pixel[0] = pixel[0] + (double)srcDataArrays[0][tmp6++] * contribution[i].weight;
                        pixel[1] = pixel[1] + (double)srcDataArrays[1][tmp6++] * contribution[i].weight;
                        pixel[2] = pixel[2] + (double)srcDataArrays[2][tmp6++] * contribution[i].weight;
                    }
                    tmp4 = tmp3;
                    dstDataArrays[0][tmp4++] = ImageUtils.clampRoundInt(pixel[0]);
                    dstDataArrays[1][tmp4++] = ImageUtils.clampRoundInt(pixel[1]);
                    dstDataArrays[2][tmp4] = ImageUtils.clampRoundInt(pixel[2]);
                    tmp3 += dstScanlineStride;
                    tmp5 += srcScanlineStride;
                }
                continue;
            }
            if (channel == 1) {
                for (y = 0; y < dstHeight; ++y) {
                    pixel[0] = 0.0;
                    tmp6 = tmp5;
                    for (i = 0; i < n; ++i) {
                        pixel[0] = pixel[0] + (double)srcDataArrays[0][tmp6++] * contribution[i].weight;
                    }
                    dstDataArrays[0][tmp3] = ImageUtils.clampRoundInt(pixel[0]);
                    tmp3 += dstScanlineStride;
                    tmp5 += srcScanlineStride;
                }
                continue;
            }
            if (channel == 4) {
                for (y = 0; y < dstHeight; ++y) {
                    pixel[0] = 0.0;
                    pixel[1] = 0.0;
                    pixel[2] = 0.0;
                    pixel[3] = 0.0;
                    tmp6 = tmp5;
                    for (i = 0; i < n; ++i) {
                        pixel[0] = pixel[0] + (double)srcDataArrays[0][tmp6++] * contribution[i].weight;
                        pixel[1] = pixel[1] + (double)srcDataArrays[1][tmp6++] * contribution[i].weight;
                        pixel[2] = pixel[2] + (double)srcDataArrays[2][tmp6++] * contribution[i].weight;
                        pixel[3] = pixel[3] + (double)srcDataArrays[3][tmp6++] * contribution[i].weight;
                    }
                    tmp4 = tmp3;
                    dstDataArrays[0][tmp4++] = ImageUtils.clampRoundInt(pixel[0]);
                    dstDataArrays[1][tmp4++] = ImageUtils.clampRoundInt(pixel[1]);
                    dstDataArrays[2][tmp4++] = ImageUtils.clampRoundInt(pixel[2]);
                    dstDataArrays[3][tmp4] = ImageUtils.clampRoundInt(pixel[3]);
                    tmp3 += dstScanlineStride;
                    tmp5 += srcScanlineStride;
                }
                continue;
            }
            throw new IllegalArgumentException("Unsupported channels num : " + channel);
        }
    }

    private void lanczosVerticalFilterInt(RasterAccessor src, RasterAccessor dst) {
        double scale = Math.max(1.0 / this.scaleY, 1.0);
        double support = scale * this.filter.getSupport() * this.filter.getBlur();
        if (support < 0.5) {
            support = 0.5;
            scale = 1.0;
        }
        scale = 1.0 / scale;
        int[][] srcDataArrays = src.getIntDataArrays();
        int[][] dstDataArrays = dst.getIntDataArrays();
        double[] pixel = new double[]{0.0, 0.0, 0.0, 0.0};
        int channel = dst.getNumBands();
        int contributionNums = (int)(2.0 * support + 3.0);
        LanczosContributionInfo[] contribution = new LanczosContributionInfo[contributionNums];
        for (int t = 0; t < contributionNums; ++t) {
            contribution[t] = new LanczosContributionInfo();
        }
        int dstHeight = dst.getHeight();
        int dstWidth = dst.getWidth();
        int srcHeight = src.getHeight();
        int srcScanlineStride = src.getScanlineStride();
        int dstScanlineStride = dst.getScanlineStride();
        for (int y = 0; y < dstHeight; ++y) {
            int tmp7;
            int i;
            int tmp6;
            int x;
            int n;
            double center = ((double)y + 0.5) / this.scaleY;
            double t1 = center - support + 0.5;
            double t2 = center + support + 0.5;
            int start = (int)(t1 > 0.0 ? t1 : 0.0);
            int stop = (int)(t2 < (double)srcHeight ? t2 : (double)srcHeight);
            double density = 0.0;
            for (n = 0; n < stop - start; ++n) {
                contribution[n].pixel = start + n;
                contribution[n].weight = this.getLanczosResizeFilterWeight(scale * ((double)(start + n) - center + 0.5));
                density += contribution[n].weight;
            }
            if (density != 0.0 && density != 1.0) {
                density = 1.0 / density;
                for (int i2 = 0; i2 < n; ++i2) {
                    contribution[i2].weight *= density;
                }
            }
            int tmp3 = y * dstScanlineStride;
            int tmp5 = (int)center * srcScanlineStride + (int)((double)start - center) * srcScanlineStride;
            if (channel == 3) {
                for (x = 0; x < dstWidth; ++x) {
                    pixel[0] = 0.0;
                    pixel[1] = 0.0;
                    pixel[2] = 0.0;
                    tmp6 = tmp5;
                    for (i = 0; i < n; ++i) {
                        tmp7 = tmp6;
                        pixel[0] = pixel[0] + (double)srcDataArrays[0][tmp7++] * contribution[i].weight;
                        pixel[1] = pixel[1] + (double)srcDataArrays[1][tmp7++] * contribution[i].weight;
                        pixel[2] = pixel[2] + (double)srcDataArrays[2][tmp7] * contribution[i].weight;
                        tmp6 += srcScanlineStride;
                    }
                    dstDataArrays[0][tmp3++] = ImageUtils.clampRoundInt(pixel[0]);
                    dstDataArrays[1][tmp3++] = ImageUtils.clampRoundInt(pixel[1]);
                    dstDataArrays[2][tmp3++] = ImageUtils.clampRoundInt(pixel[2]);
                    tmp5 += channel;
                }
                continue;
            }
            if (channel == 1) {
                for (x = 0; x < dstWidth; ++x) {
                    pixel[0] = 0.0;
                    tmp6 = tmp5;
                    for (i = 0; i < n; ++i) {
                        pixel[0] = pixel[0] + (double)srcDataArrays[0][tmp6] * contribution[i].weight;
                        tmp6 += srcScanlineStride;
                    }
                    dstDataArrays[0][tmp3++] = ImageUtils.clampRoundInt(pixel[0]);
                    tmp5 += channel;
                }
                continue;
            }
            if (channel == 4) {
                for (x = 0; x < dstWidth; ++x) {
                    pixel[0] = 0.0;
                    pixel[1] = 0.0;
                    pixel[2] = 0.0;
                    pixel[3] = 0.0;
                    tmp6 = tmp5;
                    for (i = 0; i < n; ++i) {
                        tmp7 = tmp6;
                        pixel[0] = pixel[0] + (double)srcDataArrays[0][tmp7++] * contribution[i].weight;
                        pixel[1] = pixel[1] + (double)srcDataArrays[1][tmp7++] * contribution[i].weight;
                        pixel[2] = pixel[2] + (double)srcDataArrays[2][tmp7++] * contribution[i].weight;
                        pixel[3] = pixel[3] + (double)srcDataArrays[3][tmp7] * contribution[i].weight;
                        tmp6 += srcScanlineStride;
                    }
                    dstDataArrays[0][tmp3++] = ImageUtils.clampRoundInt(pixel[0]);
                    dstDataArrays[1][tmp3++] = ImageUtils.clampRoundInt(pixel[1]);
                    dstDataArrays[2][tmp3++] = ImageUtils.clampRoundInt(pixel[2]);
                    dstDataArrays[3][tmp3++] = ImageUtils.clampRoundInt(pixel[3]);
                    tmp5 += channel;
                }
                continue;
            }
            throw new IllegalArgumentException("Unsupported channels num : " + channel);
        }
    }

    private void lanczosHorizontalFilterFloat(RasterAccessor src, RasterAccessor dst) {
        double scale = Math.max(1.0 / this.scaleX, 1.0);
        double support = scale * this.filter.getSupport() * this.filter.getBlur();
        if (support < 0.5) {
            support = 0.5;
            scale = 1.0;
        }
        float[][] srcDataArrays = src.getFloatDataArrays();
        float[][] dstDataArrays = dst.getFloatDataArrays();
        double[] pixel = new double[]{0.0, 0.0, 0.0, 0.0};
        int channel = src.getNumBands();
        scale = 1.0 / scale;
        int contributionsNum = (int)(2.0 * support + 3.0);
        LanczosContributionInfo[] contribution = new LanczosContributionInfo[contributionsNum];
        for (int t = 0; t < contributionsNum; ++t) {
            contribution[t] = new LanczosContributionInfo();
        }
        int dstWidth = dst.getWidth();
        int dstHeight = dst.getHeight();
        int srcWidth = src.getWidth();
        int dstScanlineStride = dst.getScanlineStride();
        int srcScanlineStride = src.getScanlineStride();
        for (int x = 0; x < dstWidth; ++x) {
            int tmp4;
            int i;
            int tmp6;
            int y;
            int n;
            double center = ((double)x + 0.5) / this.scaleX;
            double t1 = center - support + 0.5;
            double t2 = center + support + 0.5;
            int start = (int)(t1 > 0.0 ? t1 : 0.0);
            int stop = (int)(t2 < (double)srcWidth ? t2 : (double)srcWidth);
            double density = 0.0;
            for (n = 0; n < stop - start; ++n) {
                contribution[n].pixel = start + n;
                contribution[n].weight = this.getLanczosResizeFilterWeight(scale * ((double)(start + n) - center + 0.5));
                density += contribution[n].weight;
            }
            if (density != 0.0 && density != 1.0) {
                density = 1.0 / density;
                for (int i2 = 0; i2 < n; ++i2) {
                    contribution[i2].weight *= density;
                }
            }
            int tmp3 = x * channel;
            int tmp5 = ((int)((double)start - center) + (int)center) * channel;
            if (channel == 3) {
                for (y = 0; y < dstHeight; ++y) {
                    pixel[0] = 0.0;
                    pixel[1] = 0.0;
                    pixel[2] = 0.0;
                    tmp6 = tmp5;
                    for (i = 0; i < n; ++i) {
                        pixel[0] = pixel[0] + (double)srcDataArrays[0][tmp6++] * contribution[i].weight;
                        pixel[1] = pixel[1] + (double)srcDataArrays[1][tmp6++] * contribution[i].weight;
                        pixel[2] = pixel[2] + (double)srcDataArrays[2][tmp6++] * contribution[i].weight;
                    }
                    tmp4 = tmp3;
                    dstDataArrays[0][tmp4++] = ImageUtils.clampFloat(pixel[0]);
                    dstDataArrays[1][tmp4++] = ImageUtils.clampFloat(pixel[1]);
                    dstDataArrays[2][tmp4] = ImageUtils.clampFloat(pixel[2]);
                    tmp3 += dstScanlineStride;
                    tmp5 += srcScanlineStride;
                }
                continue;
            }
            if (channel == 1) {
                for (y = 0; y < dstHeight; ++y) {
                    pixel[0] = 0.0;
                    tmp6 = tmp5;
                    for (i = 0; i < n; ++i) {
                        pixel[0] = pixel[0] + (double)srcDataArrays[0][tmp6++] * contribution[i].weight;
                    }
                    dstDataArrays[0][tmp3] = ImageUtils.clampFloat(pixel[0]);
                    tmp3 += dstScanlineStride;
                    tmp5 += srcScanlineStride;
                }
                continue;
            }
            if (channel == 4) {
                for (y = 0; y < dstHeight; ++y) {
                    pixel[0] = 0.0;
                    pixel[1] = 0.0;
                    pixel[2] = 0.0;
                    pixel[3] = 0.0;
                    tmp6 = tmp5;
                    for (i = 0; i < n; ++i) {
                        pixel[0] = pixel[0] + (double)srcDataArrays[0][tmp6++] * contribution[i].weight;
                        pixel[1] = pixel[1] + (double)srcDataArrays[1][tmp6++] * contribution[i].weight;
                        pixel[2] = pixel[2] + (double)srcDataArrays[2][tmp6++] * contribution[i].weight;
                        pixel[3] = pixel[3] + (double)srcDataArrays[3][tmp6++] * contribution[i].weight;
                    }
                    tmp4 = tmp3;
                    dstDataArrays[0][tmp4++] = ImageUtils.clampFloat(pixel[0]);
                    dstDataArrays[1][tmp4++] = ImageUtils.clampFloat(pixel[1]);
                    dstDataArrays[2][tmp4++] = ImageUtils.clampFloat(pixel[2]);
                    dstDataArrays[3][tmp4] = ImageUtils.clampFloat(pixel[3]);
                    tmp3 += dstScanlineStride;
                    tmp5 += srcScanlineStride;
                }
                continue;
            }
            throw new IllegalArgumentException("Unsupported channels num : " + channel);
        }
    }

    private void lanczosVerticalFilterFloat(RasterAccessor src, RasterAccessor dst) {
        double scale = Math.max(1.0 / this.scaleY, 1.0);
        double support = scale * this.filter.getSupport() * this.filter.getBlur();
        if (support < 0.5) {
            support = 0.5;
            scale = 1.0;
        }
        scale = 1.0 / scale;
        float[][] srcDataArrays = src.getFloatDataArrays();
        float[][] dstDataArrays = dst.getFloatDataArrays();
        double[] pixel = new double[]{0.0, 0.0, 0.0, 0.0};
        int channel = dst.getNumBands();
        int contributionNums = (int)(2.0 * support + 3.0);
        LanczosContributionInfo[] contribution = new LanczosContributionInfo[contributionNums];
        for (int t = 0; t < contributionNums; ++t) {
            contribution[t] = new LanczosContributionInfo();
        }
        int dstHeight = dst.getHeight();
        int dstWidth = dst.getWidth();
        int srcHeight = src.getHeight();
        int srcScanlineStride = src.getScanlineStride();
        int dstScanlineStride = dst.getScanlineStride();
        for (int y = 0; y < dstHeight; ++y) {
            int tmp7;
            int i;
            int tmp6;
            int x;
            int n;
            double center = ((double)y + 0.5) / this.scaleY;
            double t1 = center - support + 0.5;
            double t2 = center + support + 0.5;
            int start = (int)(t1 > 0.0 ? t1 : 0.0);
            int stop = (int)(t2 < (double)srcHeight ? t2 : (double)srcHeight);
            double density = 0.0;
            for (n = 0; n < stop - start; ++n) {
                contribution[n].pixel = start + n;
                contribution[n].weight = this.getLanczosResizeFilterWeight(scale * ((double)(start + n) - center + 0.5));
                density += contribution[n].weight;
            }
            if (density != 0.0 && density != 1.0) {
                density = 1.0 / density;
                for (int i2 = 0; i2 < n; ++i2) {
                    contribution[i2].weight *= density;
                }
            }
            int tmp3 = y * dstScanlineStride;
            int tmp5 = (int)center * srcScanlineStride + (int)((double)start - center) * srcScanlineStride;
            if (channel == 3) {
                for (x = 0; x < dstWidth; ++x) {
                    pixel[0] = 0.0;
                    pixel[1] = 0.0;
                    pixel[2] = 0.0;
                    tmp6 = tmp5;
                    for (i = 0; i < n; ++i) {
                        tmp7 = tmp6;
                        pixel[0] = pixel[0] + (double)srcDataArrays[0][tmp7++] * contribution[i].weight;
                        pixel[1] = pixel[1] + (double)srcDataArrays[1][tmp7++] * contribution[i].weight;
                        pixel[2] = pixel[2] + (double)srcDataArrays[2][tmp7] * contribution[i].weight;
                        tmp6 += srcScanlineStride;
                    }
                    dstDataArrays[0][tmp3++] = ImageUtils.clampFloat(pixel[0]);
                    dstDataArrays[1][tmp3++] = ImageUtils.clampFloat(pixel[1]);
                    dstDataArrays[2][tmp3++] = ImageUtils.clampFloat(pixel[2]);
                    tmp5 += channel;
                }
                continue;
            }
            if (channel == 1) {
                for (x = 0; x < dstWidth; ++x) {
                    pixel[0] = 0.0;
                    tmp6 = tmp5;
                    for (i = 0; i < n; ++i) {
                        pixel[0] = pixel[0] + (double)srcDataArrays[0][tmp6] * contribution[i].weight;
                        tmp6 += srcScanlineStride;
                    }
                    dstDataArrays[0][tmp3++] = ImageUtils.clampFloat(pixel[0]);
                    tmp5 += channel;
                }
                continue;
            }
            if (channel == 4) {
                for (x = 0; x < dstWidth; ++x) {
                    pixel[0] = 0.0;
                    pixel[1] = 0.0;
                    pixel[2] = 0.0;
                    pixel[3] = 0.0;
                    tmp6 = tmp5;
                    for (i = 0; i < n; ++i) {
                        tmp7 = tmp6;
                        pixel[0] = pixel[0] + (double)srcDataArrays[0][tmp7++] * contribution[i].weight;
                        pixel[1] = pixel[1] + (double)srcDataArrays[1][tmp7++] * contribution[i].weight;
                        pixel[2] = pixel[2] + (double)srcDataArrays[2][tmp7++] * contribution[i].weight;
                        pixel[3] = pixel[3] + (double)srcDataArrays[3][tmp7] * contribution[i].weight;
                        tmp6 += srcScanlineStride;
                    }
                    dstDataArrays[0][tmp3++] = ImageUtils.clampFloat(pixel[0]);
                    dstDataArrays[1][tmp3++] = ImageUtils.clampFloat(pixel[1]);
                    dstDataArrays[2][tmp3++] = ImageUtils.clampFloat(pixel[2]);
                    dstDataArrays[3][tmp3++] = ImageUtils.clampFloat(pixel[3]);
                    tmp5 += channel;
                }
                continue;
            }
            throw new IllegalArgumentException("Unsupported channels num : " + channel);
        }
    }

    private void lanczosHorizontalFilterDouble(RasterAccessor src, RasterAccessor dst) {
        double scale = Math.max(1.0 / this.scaleX, 1.0);
        double support = scale * this.filter.getSupport() * this.filter.getBlur();
        if (support < 0.5) {
            support = 0.5;
            scale = 1.0;
        }
        double[][] srcDataArrays = src.getDoubleDataArrays();
        double[][] dstDataArrays = dst.getDoubleDataArrays();
        double[] pixel = new double[]{0.0, 0.0, 0.0, 0.0};
        int channel = src.getNumBands();
        scale = 1.0 / scale;
        int contributionsNum = (int)(2.0 * support + 3.0);
        LanczosContributionInfo[] contribution = new LanczosContributionInfo[contributionsNum];
        for (int t = 0; t < contributionsNum; ++t) {
            contribution[t] = new LanczosContributionInfo();
        }
        int dstWidth = dst.getWidth();
        int dstHeight = dst.getHeight();
        int srcWidth = src.getWidth();
        int dstScanlineStride = dst.getScanlineStride();
        int srcScanlineStride = src.getScanlineStride();
        for (int x = 0; x < dstWidth; ++x) {
            int tmp4;
            int i;
            int tmp6;
            int y;
            int n;
            double center = ((double)x + 0.5) / this.scaleX;
            double t1 = center - support + 0.5;
            double t2 = center + support + 0.5;
            int start = (int)(t1 > 0.0 ? t1 : 0.0);
            int stop = (int)(t2 < (double)srcWidth ? t2 : (double)srcWidth);
            double density = 0.0;
            for (n = 0; n < stop - start; ++n) {
                contribution[n].pixel = start + n;
                contribution[n].weight = this.getLanczosResizeFilterWeight(scale * ((double)(start + n) - center + 0.5));
                density += contribution[n].weight;
            }
            if (density != 0.0 && density != 1.0) {
                density = 1.0 / density;
                for (int i2 = 0; i2 < n; ++i2) {
                    contribution[i2].weight *= density;
                }
            }
            int tmp3 = x * channel;
            int tmp5 = ((int)((double)start - center) + (int)center) * channel;
            if (channel == 3) {
                for (y = 0; y < dstHeight; ++y) {
                    pixel[0] = 0.0;
                    pixel[1] = 0.0;
                    pixel[2] = 0.0;
                    tmp6 = tmp5;
                    for (i = 0; i < n; ++i) {
                        pixel[0] = pixel[0] + srcDataArrays[0][tmp6++] * contribution[i].weight;
                        pixel[1] = pixel[1] + srcDataArrays[1][tmp6++] * contribution[i].weight;
                        pixel[2] = pixel[2] + srcDataArrays[2][tmp6++] * contribution[i].weight;
                    }
                    tmp4 = tmp3;
                    dstDataArrays[0][tmp4++] = pixel[0];
                    dstDataArrays[1][tmp4++] = pixel[1];
                    dstDataArrays[2][tmp4] = pixel[2];
                    tmp3 += dstScanlineStride;
                    tmp5 += srcScanlineStride;
                }
                continue;
            }
            if (channel == 1) {
                for (y = 0; y < dstHeight; ++y) {
                    pixel[0] = 0.0;
                    tmp6 = tmp5;
                    for (i = 0; i < n; ++i) {
                        pixel[0] = pixel[0] + srcDataArrays[0][tmp6++] * contribution[i].weight;
                    }
                    dstDataArrays[0][tmp3] = pixel[0];
                    tmp3 += dstScanlineStride;
                    tmp5 += srcScanlineStride;
                }
                continue;
            }
            if (channel == 4) {
                for (y = 0; y < dstHeight; ++y) {
                    pixel[0] = 0.0;
                    pixel[1] = 0.0;
                    pixel[2] = 0.0;
                    pixel[3] = 0.0;
                    tmp6 = tmp5;
                    for (i = 0; i < n; ++i) {
                        pixel[0] = pixel[0] + srcDataArrays[0][tmp6++] * contribution[i].weight;
                        pixel[1] = pixel[1] + srcDataArrays[1][tmp6++] * contribution[i].weight;
                        pixel[2] = pixel[2] + srcDataArrays[2][tmp6++] * contribution[i].weight;
                        pixel[3] = pixel[3] + srcDataArrays[3][tmp6++] * contribution[i].weight;
                    }
                    tmp4 = tmp3;
                    dstDataArrays[0][tmp4++] = pixel[0];
                    dstDataArrays[1][tmp4++] = pixel[1];
                    dstDataArrays[2][tmp4++] = pixel[2];
                    dstDataArrays[3][tmp4] = pixel[3];
                    tmp3 += dstScanlineStride;
                    tmp5 += srcScanlineStride;
                }
                continue;
            }
            throw new IllegalArgumentException("Unsupported channels num : " + channel);
        }
    }

    private void lanczosVerticalFilterDouble(RasterAccessor src, RasterAccessor dst) {
        double scale = Math.max(1.0 / this.scaleY, 1.0);
        double support = scale * this.filter.getSupport() * this.filter.getBlur();
        if (support < 0.5) {
            support = 0.5;
            scale = 1.0;
        }
        scale = 1.0 / scale;
        double[][] srcDataArrays = src.getDoubleDataArrays();
        double[][] dstDataArrays = dst.getDoubleDataArrays();
        double[] pixel = new double[]{0.0, 0.0, 0.0, 0.0};
        int channel = dst.getNumBands();
        int contributionNums = (int)(2.0 * support + 3.0);
        LanczosContributionInfo[] contribution = new LanczosContributionInfo[contributionNums];
        for (int t = 0; t < contributionNums; ++t) {
            contribution[t] = new LanczosContributionInfo();
        }
        int dstHeight = dst.getHeight();
        int dstWidth = dst.getWidth();
        int srcHeight = src.getHeight();
        int srcScanlineStride = src.getScanlineStride();
        int dstScanlineStride = dst.getScanlineStride();
        for (int y = 0; y < dstHeight; ++y) {
            int tmp7;
            int i;
            int tmp6;
            int x;
            int n;
            double center = ((double)y + 0.5) / this.scaleY;
            double t1 = center - support + 0.5;
            double t2 = center + support + 0.5;
            int start = (int)(t1 > 0.0 ? t1 : 0.0);
            int stop = (int)(t2 < (double)srcHeight ? t2 : (double)srcHeight);
            double density = 0.0;
            for (n = 0; n < stop - start; ++n) {
                contribution[n].pixel = start + n;
                contribution[n].weight = this.getLanczosResizeFilterWeight(scale * ((double)(start + n) - center + 0.5));
                density += contribution[n].weight;
            }
            if (density != 0.0 && density != 1.0) {
                density = 1.0 / density;
                for (int i2 = 0; i2 < n; ++i2) {
                    contribution[i2].weight *= density;
                }
            }
            int tmp3 = y * dstScanlineStride;
            int tmp5 = (int)center * srcScanlineStride + (int)((double)start - center) * srcScanlineStride;
            if (channel == 3) {
                for (x = 0; x < dstWidth; ++x) {
                    pixel[0] = 0.0;
                    pixel[1] = 0.0;
                    pixel[2] = 0.0;
                    tmp6 = tmp5;
                    for (i = 0; i < n; ++i) {
                        tmp7 = tmp6;
                        pixel[0] = pixel[0] + srcDataArrays[0][tmp7++] * contribution[i].weight;
                        pixel[1] = pixel[1] + srcDataArrays[1][tmp7++] * contribution[i].weight;
                        pixel[2] = pixel[2] + srcDataArrays[2][tmp7] * contribution[i].weight;
                        tmp6 += srcScanlineStride;
                    }
                    dstDataArrays[0][tmp3++] = pixel[0];
                    dstDataArrays[1][tmp3++] = pixel[1];
                    dstDataArrays[2][tmp3++] = pixel[2];
                    tmp5 += channel;
                }
                continue;
            }
            if (channel == 1) {
                for (x = 0; x < dstWidth; ++x) {
                    pixel[0] = 0.0;
                    tmp6 = tmp5;
                    for (i = 0; i < n; ++i) {
                        pixel[0] = pixel[0] + srcDataArrays[0][tmp6] * contribution[i].weight;
                        tmp6 += srcScanlineStride;
                    }
                    dstDataArrays[0][tmp3++] = pixel[0];
                    tmp5 += channel;
                }
                continue;
            }
            if (channel == 4) {
                for (x = 0; x < dstWidth; ++x) {
                    pixel[0] = 0.0;
                    pixel[1] = 0.0;
                    pixel[2] = 0.0;
                    pixel[3] = 0.0;
                    tmp6 = tmp5;
                    for (i = 0; i < n; ++i) {
                        tmp7 = tmp6;
                        pixel[0] = pixel[0] + srcDataArrays[0][tmp7++] * contribution[i].weight;
                        pixel[1] = pixel[1] + srcDataArrays[1][tmp7++] * contribution[i].weight;
                        pixel[2] = pixel[2] + srcDataArrays[2][tmp7++] * contribution[i].weight;
                        pixel[3] = pixel[3] + srcDataArrays[3][tmp7] * contribution[i].weight;
                        tmp6 += srcScanlineStride;
                    }
                    dstDataArrays[0][tmp3++] = pixel[0];
                    dstDataArrays[1][tmp3++] = pixel[1];
                    dstDataArrays[2][tmp3++] = pixel[2];
                    dstDataArrays[3][tmp3++] = pixel[3];
                    tmp5 += channel;
                }
                continue;
            }
            throw new IllegalArgumentException("Unsupported channels num : " + channel);
        }
    }

    private double getLanczosResizeFilterWeight(double x) {
        double blur = Math.abs(x) / this.filter.getBlur();
        double scale = this.filter.getScale() / this.filter.getWindowSupport();
        scale = this.filter.window(blur * scale);
        return scale * this.filter.filter(blur);
    }
}

