/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.simpleimage.render;

import com.alibaba.simpleimage.render.FixDrawTextItem;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import org.apache.commons.lang.StringUtils;

public class CornerDrawTextItem
extends FixDrawTextItem {
    static final float DEFAULT_CORNER_TEXT_WIDTH_PER = 0.5f;

    public CornerDrawTextItem(String text) {
        super(text, FONT_COLOR, FONT_SHADOW_COLOR, FONT, 10, null, 0.5f);
    }

    public CornerDrawTextItem(String text, float textWidthPercent) {
        super(text, FONT_COLOR, FONT_SHADOW_COLOR, FONT, 10, null, textWidthPercent);
    }

    public CornerDrawTextItem(String text, Color fontColor, Color fontShadowColor, Font font, int minFontSize, float textWidthPercent) {
        super(text, fontColor, fontShadowColor, font, minFontSize, null, textWidthPercent);
    }

    public void drawText(Graphics2D graphics, int width, int height) {
        if (StringUtils.isBlank((String)this.text)) {
            return;
        }
        int x = 0;
        int y = 0;
        int textLength = (int)((float)width * this.textWidthPercent);
        int fontsize = textLength / this.text.length();
        if (fontsize < this.minFontSize) {
            return;
        }
        float fsize = fontsize;
        Font font = this.defaultFont.deriveFont(fsize);
        graphics.setFont(font);
        FontRenderContext context = graphics.getFontRenderContext();
        int sw = (int)font.getStringBounds(this.text, context).getWidth();
        y = width > height ? height / 4 : width / 4;
        int halflen = sw / 2;
        x = halflen <= y - fontsize ? y - halflen : fontsize;
        if (x <= 0 || y <= 0) {
            return;
        }
        if (this.fontShadowColor != null) {
            graphics.setColor(this.fontShadowColor);
            graphics.drawString(this.text, x + this.getShadowTranslation(fontsize), y + this.getShadowTranslation(fontsize));
        }
        graphics.setColor(this.fontColor);
        graphics.drawString(this.text, x, y);
        y = width > height ? height - height / 4 : height - width / 4;
        halflen = sw / 2;
        x = halflen <= height - y - fontsize ? width - (height - y) - halflen : width - sw - fontsize;
        if (x <= 0 || y <= 0) {
            return;
        }
        if (this.fontShadowColor != null) {
            graphics.setColor(this.fontShadowColor);
            graphics.drawString(this.text, x + this.getShadowTranslation(fontsize), y + this.getShadowTranslation(fontsize));
        }
        graphics.setColor(this.fontColor);
        graphics.drawString(this.text, x, y);
    }
}

