/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.simpleimage.render;

import com.alibaba.simpleimage.ImageRender;
import com.alibaba.simpleimage.ImageWrapper;
import com.alibaba.simpleimage.SimpleImageException;
import com.alibaba.simpleimage.util.ImageColorConvertHelper;
import com.alibaba.simpleimage.util.ImageReadHelper;
import java.io.InputStream;
import javax.media.jai.PlanarImage;

public class ReadRender
extends ImageRender {
    protected InputStream inStream;
    protected boolean tosRGBColorSpace = true;
    protected boolean needClean = false;

    public ReadRender(InputStream input, boolean tosRGBColorSpace) {
        super(null);
        this.inStream = input;
        this.tosRGBColorSpace = tosRGBColorSpace;
    }

    public ReadRender(InputStream input) {
        this(input, true);
    }

    public ImageWrapper render() throws SimpleImageException {
        try {
            if (this.inStream == null) {
                throw new SimpleImageException("No input set");
            }
            ImageWrapper imgWrapper = ImageReadHelper.read(this.inStream);
            if (this.tosRGBColorSpace) {
                for (int i = 0; i < imgWrapper.getNumOfImages(); ++i) {
                    PlanarImage img = ImageColorConvertHelper.convert2sRGB(imgWrapper.getAsPlanarImage(i));
                    imgWrapper.setImage(i, img);
                }
            }
            return imgWrapper;
        }
        catch (Exception e) {
            throw new SimpleImageException(e);
        }
    }

    public void dispose() throws SimpleImageException {
        super.dispose();
    }
}

