/*
 * Decompiled with CFR 0.152.
 */
package com.assaydepot;

import com.assaydepot.conf.Configuration;
import com.assaydepot.result.BaseResult;
import com.assaydepot.result.Provider;
import com.assaydepot.result.ProviderRef;
import com.assaydepot.result.ProviderResult;
import com.assaydepot.result.Results;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonToken;

public class AssayDepotImpl {
    private static final String BASE_URL_STRING = "https://www.assaydepot.com/api/providers.json";
    private Configuration conf;

    AssayDepotImpl(Configuration conf) {
        this.conf = conf;
    }

    public Results getProviderRefs(String query) throws JsonParseException, IOException {
        StringBuilder urlBuilder = new StringBuilder(BASE_URL_STRING);
        if (query != null) {
            urlBuilder.append("?q=").append(query);
        }
        if (this.conf.getApiToken() != null) {
            urlBuilder.append("&auth_token=").append(this.conf.getApiToken());
        }
        URL url = new URL(urlBuilder.toString());
        JsonFactory f = new JsonFactory();
        JsonParser jp = f.createJsonParser(url.openStream());
        Results results = new Results();
        results.setProviderRefs(new ArrayList<ProviderRef>());
        results.setFacets(new HashMap<String, Map<String, String>>());
        jp.nextToken();
        while (jp.nextToken() != JsonToken.END_OBJECT) {
            String fieldName = jp.getCurrentName();
            jp.nextToken();
            if ("total".equals(fieldName)) {
                results.setTotal(jp.getIntValue());
                continue;
            }
            if ("page".equals(fieldName)) {
                results.setPage(jp.getIntValue());
                continue;
            }
            if ("per_page".equals(fieldName)) {
                results.setPerPage(jp.getIntValue());
                continue;
            }
            if ("query_time".equals(fieldName)) {
                results.setQueryTime(jp.getDoubleValue());
                continue;
            }
            if ("facets".equals(fieldName)) {
                HashMap facetMap = null;
                while (jp.nextToken() != JsonToken.END_OBJECT) {
                    fieldName = jp.getCurrentName();
                    facetMap = new HashMap();
                    results.getFacets().put(fieldName, facetMap);
                    JsonToken token = jp.nextToken();
                    while (token != JsonToken.END_OBJECT) {
                        if (token != JsonToken.START_OBJECT || (token = jp.nextToken()) != JsonToken.END_OBJECT) continue;
                        token = jp.nextToken();
                    }
                    System.out.println("token1 = [" + token + "]");
                    token = jp.nextToken();
                    System.out.println("token2 = [" + token + "]");
                    System.out.println("token3 = [" + jp.getText() + "]");
                }
                continue;
            }
            if ("providerRefs".equals(fieldName)) {
                this.parseProviderRefs(jp, results);
                continue;
            }
            System.out.println("Unrecognized field '" + fieldName + "'!");
        }
        Provider provider = new Provider();
        while (jp.nextToken() != JsonToken.END_OBJECT) {
            String fieldName = jp.getCurrentName();
            jp.nextToken();
            if ("total".equals(fieldName)) {
                results.setTotal(jp.getIntValue());
                continue;
            }
            if (!"page".equals(fieldName)) continue;
            results.setPage(jp.getIntValue());
            jp.close();
        }
        return results;
    }

    private void getLocations(JsonParser jp, ProviderResult pResult) throws JsonParseException, IOException {
        HashMap<String, String> locationMap = null;
        while (jp.nextToken() != JsonToken.END_ARRAY) {
            locationMap = new HashMap<String, String>();
            while (jp.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = jp.getCurrentName();
                jp.nextToken();
                locationMap.put(fieldName, jp.getText());
                pResult.getLocations().add(locationMap);
            }
        }
    }

    private void getUrls(JsonParser jp, BaseResult baseResult) throws JsonParseException, IOException {
        baseResult.setUrls(new HashMap<String, String>());
        while (jp.nextToken() != JsonToken.END_ARRAY) {
            String fieldName = jp.getCurrentName();
            jp.nextToken();
            baseResult.getUrls().put(fieldName, jp.getText());
        }
    }

    private void parseProviderRefs(JsonParser jp, Results results) throws JsonParseException, IOException {
        ProviderRef pRef = null;
        String fieldName = null;
        while (jp.nextToken() != JsonToken.END_ARRAY) {
            pRef = new ProviderRef();
            pRef.setLocations(new ArrayList<Map<String, String>>());
            while (jp.nextToken() != JsonToken.END_OBJECT) {
                fieldName = jp.getCurrentName();
                if ("id".equals(fieldName)) {
                    pRef.setId(jp.getText());
                    continue;
                }
                if ("slug".equals(fieldName)) {
                    pRef.setSlug(jp.getText());
                    continue;
                }
                if ("name".equals(fieldName)) {
                    pRef.setName(jp.getText());
                    continue;
                }
                if ("snippet".equals(fieldName)) {
                    pRef.setSnippet(jp.getText());
                    continue;
                }
                if ("permission".equals(fieldName)) {
                    pRef.setPermission(jp.getText());
                    continue;
                }
                if ("score".equals(fieldName)) continue;
                if ("locations".equals(fieldName)) {
                    this.getLocations(jp, pRef);
                    continue;
                }
                if (!"urls".equals(fieldName)) continue;
                this.getUrls(jp, pRef);
            }
            results.getProviderRefs().add(pRef);
        }
    }

    public Results getWares(String query) {
        return null;
    }
}

