/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.amqp.implementation.handler;

import com.azure.core.amqp.exception.AmqpErrorContext;
import com.azure.core.amqp.exception.AmqpException;
import com.azure.core.amqp.exception.SessionErrorContext;
import com.azure.core.amqp.implementation.ExceptionUtil;
import com.azure.core.amqp.implementation.ReactorDispatcher;
import com.azure.core.amqp.implementation.handler.Handler;
import com.azure.core.util.logging.ClientLogger;
import java.io.IOException;
import java.time.Duration;
import java.util.Locale;
import org.apache.qpid.proton.amqp.transport.ErrorCondition;
import org.apache.qpid.proton.engine.EndpointState;
import org.apache.qpid.proton.engine.Event;
import org.apache.qpid.proton.engine.Session;

public class SessionHandler
extends Handler {
    private final String entityName;
    private final Duration openTimeout;
    private final ReactorDispatcher reactorDispatcher;

    public SessionHandler(String connectionId, String hostname, String entityName, ReactorDispatcher reactorDispatcher, Duration openTimeout) {
        super(connectionId, hostname, new ClientLogger(SessionHandler.class));
        this.entityName = entityName;
        this.openTimeout = openTimeout;
        this.reactorDispatcher = reactorDispatcher;
    }

    public AmqpErrorContext getErrorContext() {
        return new SessionErrorContext(this.getHostname(), this.entityName);
    }

    public void onSessionLocalOpen(Event e) {
        this.logger.verbose("onSessionLocalOpen connectionId[{}], entityName[{}], condition[{}]", new Object[]{this.getConnectionId(), this.entityName, e.getSession().getCondition() == null ? "n/a" : e.getSession().getCondition().toString()});
        Session session = e.getSession();
        try {
            this.reactorDispatcher.invoke(this::onSessionTimeout, this.openTimeout);
        }
        catch (IOException ioException) {
            this.logger.warning("onSessionLocalOpen connectionId[{}], entityName[{}], reactorDispatcherError[{}]", new Object[]{this.getConnectionId(), this.entityName, ioException.getMessage()});
            session.close();
            String message = String.format(Locale.US, "onSessionLocalOpen connectionId[%s], entityName[%s], underlying IO of reactorDispatcher faulted with error: %s", this.getConnectionId(), this.entityName, ioException.getMessage());
            AmqpException exception = new AmqpException(false, message, (Throwable)ioException, this.getErrorContext());
            this.onError((Throwable)((Object)exception));
        }
    }

    public void onSessionRemoteOpen(Event e) {
        Session session = e.getSession();
        if (session.getLocalState() == EndpointState.UNINITIALIZED) {
            this.logger.warning("onSessionRemoteOpen connectionId[{}], entityName[{}], sessionIncCapacity[{}], sessionOutgoingWindow[{}] endpoint was uninitialised.", new Object[]{this.getConnectionId(), this.entityName, session.getIncomingCapacity(), session.getOutgoingWindow()});
            session.open();
        } else {
            this.logger.info("onSessionRemoteOpen connectionId[{}], entityName[{}], sessionIncCapacity[{}], sessionOutgoingWindow[{}]", new Object[]{this.getConnectionId(), this.entityName, session.getIncomingCapacity(), session.getOutgoingWindow()});
        }
        this.onNext(EndpointState.ACTIVE);
    }

    public void onSessionLocalClose(Event e) {
        ErrorCondition condition = e != null && e.getSession() != null ? e.getSession().getCondition() : null;
        this.logger.verbose("onSessionLocalClose connectionId[{}], entityName[{}], condition[{}]", new Object[]{this.entityName, this.getConnectionId(), condition == null ? "n/a" : condition.toString()});
    }

    public void onSessionRemoteClose(Event e) {
        ErrorCondition condition;
        Session session = e.getSession();
        this.logger.info("onSessionRemoteClose connectionId[{}], entityName[{}], condition[{}]", new Object[]{this.entityName, this.getConnectionId(), session == null || session.getRemoteCondition() == null ? "n/a" : session.getRemoteCondition().toString()});
        ErrorCondition errorCondition = condition = session != null ? session.getRemoteCondition() : null;
        if (session != null && session.getLocalState() != EndpointState.CLOSED) {
            this.logger.info("onSessionRemoteClose closing a local session for connectionId[{}], entityName[{}], condition[{}], description[{}]", new Object[]{this.getConnectionId(), this.entityName, condition != null ? condition.getCondition() : "n/a", condition != null ? condition.getDescription() : "n/a"});
            session.setCondition(session.getRemoteCondition());
            session.close();
        }
        if (condition == null || condition.getCondition() == null) {
            this.onNext(EndpointState.CLOSED);
        } else {
            String id = this.getConnectionId();
            AmqpErrorContext context = this.getErrorContext();
            Exception exception = ExceptionUtil.toException(condition.getCondition().toString(), String.format(Locale.US, "onSessionRemoteClose connectionId[%s], entityName[%s] condition[%s]", id, this.entityName, condition), context);
            this.onError(exception);
        }
    }

    public void onSessionFinal(Event e) {
        Session session = e.getSession();
        ErrorCondition condition = session != null ? session.getCondition() : null;
        this.logger.info("onSessionFinal connectionId[{}], entityName[{}], condition[{}], description[{}]", new Object[]{this.getConnectionId(), this.entityName, condition != null ? condition.getCondition() : "n/a", condition != null ? condition.getDescription() : "n/a"});
        this.close();
    }

    private void onSessionTimeout() {
    }
}

