/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.monitor.implementation;

import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.monitor.fluent.PrivateLinkResourcesClient;
import com.azure.resourcemanager.monitor.fluent.models.PrivateLinkResourceInner;
import com.azure.resourcemanager.monitor.implementation.MonitorClientImpl;
import com.azure.resourcemanager.monitor.models.PrivateLinkResourceListResult;
import reactor.core.publisher.Mono;

public final class PrivateLinkResourcesClientImpl
implements PrivateLinkResourcesClient {
    private final ClientLogger logger = new ClientLogger(PrivateLinkResourcesClientImpl.class);
    private final PrivateLinkResourcesService service;
    private final MonitorClientImpl client;

    PrivateLinkResourcesClientImpl(MonitorClientImpl client) {
        this.service = (PrivateLinkResourcesService)RestProxy.create(PrivateLinkResourcesService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<PrivateLinkResourceInner>> listByPrivateLinkScopeSinglePageAsync(String resourceGroupName, String scopeName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (scopeName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter scopeName is required and cannot be null."));
        }
        String apiVersion = "2019-10-17-preview";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByPrivateLinkScope(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, "2019-10-17-preview", scopeName, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PrivateLinkResourceListResult)res.getValue()).value(), ((PrivateLinkResourceListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<PrivateLinkResourceInner>> listByPrivateLinkScopeSinglePageAsync(String resourceGroupName, String scopeName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (scopeName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter scopeName is required and cannot be null."));
        }
        String apiVersion = "2019-10-17-preview";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByPrivateLinkScope(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, "2019-10-17-preview", scopeName, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PrivateLinkResourceListResult)res.getValue()).value(), ((PrivateLinkResourceListResult)res.getValue()).nextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<PrivateLinkResourceInner> listByPrivateLinkScopeAsync(String resourceGroupName, String scopeName) {
        return new PagedFlux(() -> this.listByPrivateLinkScopeSinglePageAsync(resourceGroupName, scopeName), nextLink -> this.listByPrivateLinkScopeNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<PrivateLinkResourceInner> listByPrivateLinkScopeAsync(String resourceGroupName, String scopeName, Context context) {
        return new PagedFlux(() -> this.listByPrivateLinkScopeSinglePageAsync(resourceGroupName, scopeName, context), nextLink -> this.listByPrivateLinkScopeNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<PrivateLinkResourceInner> listByPrivateLinkScope(String resourceGroupName, String scopeName) {
        return new PagedIterable(this.listByPrivateLinkScopeAsync(resourceGroupName, scopeName));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<PrivateLinkResourceInner> listByPrivateLinkScope(String resourceGroupName, String scopeName, Context context) {
        return new PagedIterable(this.listByPrivateLinkScopeAsync(resourceGroupName, scopeName, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<PrivateLinkResourceInner>> getWithResponseAsync(String resourceGroupName, String scopeName, String groupName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (scopeName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter scopeName is required and cannot be null."));
        }
        if (groupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupName is required and cannot be null."));
        }
        String apiVersion = "2019-10-17-preview";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, "2019-10-17-preview", scopeName, groupName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<PrivateLinkResourceInner>> getWithResponseAsync(String resourceGroupName, String scopeName, String groupName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (scopeName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter scopeName is required and cannot be null."));
        }
        if (groupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupName is required and cannot be null."));
        }
        String apiVersion = "2019-10-17-preview";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, "2019-10-17-preview", scopeName, groupName, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PrivateLinkResourceInner> getAsync(String resourceGroupName, String scopeName, String groupName) {
        return this.getWithResponseAsync(resourceGroupName, scopeName, groupName).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((PrivateLinkResourceInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public PrivateLinkResourceInner get(String resourceGroupName, String scopeName, String groupName) {
        return (PrivateLinkResourceInner)((Object)this.getAsync(resourceGroupName, scopeName, groupName).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<PrivateLinkResourceInner> getWithResponse(String resourceGroupName, String scopeName, String groupName, Context context) {
        return (Response)this.getWithResponseAsync(resourceGroupName, scopeName, groupName, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<PrivateLinkResourceInner>> listByPrivateLinkScopeNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByPrivateLinkScopeNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PrivateLinkResourceListResult)res.getValue()).value(), ((PrivateLinkResourceListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<PrivateLinkResourceInner>> listByPrivateLinkScopeNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByPrivateLinkScopeNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PrivateLinkResourceListResult)res.getValue()).value(), ((PrivateLinkResourceListResult)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="MonitorClientPrivate")
    private static interface PrivateLinkResourcesService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/privateLinkScopes/{scopeName}/privateLinkResources")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<PrivateLinkResourceListResult>> listByPrivateLinkScope(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @QueryParam(value="api-version") String var4, @PathParam(value="scopeName") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/privateLinkScopes/{scopeName}/privateLinkResources/{groupName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<PrivateLinkResourceInner>> get(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @QueryParam(value="api-version") String var4, @PathParam(value="scopeName") String var5, @PathParam(value="groupName") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<PrivateLinkResourceListResult>> listByPrivateLinkScopeNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

