/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.monitor.fluent.models;

import com.azure.core.annotation.JsonFlatten;
import com.azure.core.management.Resource;
import com.azure.core.management.SystemData;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.monitor.models.DataCollectionRuleDataSources;
import com.azure.resourcemanager.monitor.models.DataCollectionRuleDestinations;
import com.azure.resourcemanager.monitor.models.DataFlow;
import com.azure.resourcemanager.monitor.models.KnownDataCollectionRuleProvisioningState;
import com.azure.resourcemanager.monitor.models.KnownDataCollectionRuleResourceKind;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;

@JsonFlatten
public class DataCollectionRuleResourceInner
extends Resource {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(DataCollectionRuleResourceInner.class);
    @JsonProperty(value="kind")
    private KnownDataCollectionRuleResourceKind kind;
    @JsonProperty(value="etag", access=JsonProperty.Access.WRITE_ONLY)
    private String etag;
    @JsonProperty(value="systemData", access=JsonProperty.Access.WRITE_ONLY)
    private SystemData systemData;
    @JsonProperty(value="properties.description")
    private String description;
    @JsonProperty(value="properties.immutableId", access=JsonProperty.Access.WRITE_ONLY)
    private String immutableId;
    @JsonProperty(value="properties.dataSources")
    private DataCollectionRuleDataSources dataSources;
    @JsonProperty(value="properties.destinations")
    private DataCollectionRuleDestinations destinations;
    @JsonProperty(value="properties.dataFlows")
    private List<DataFlow> dataFlows;
    @JsonProperty(value="properties.provisioningState", access=JsonProperty.Access.WRITE_ONLY)
    private KnownDataCollectionRuleProvisioningState provisioningState;

    public KnownDataCollectionRuleResourceKind kind() {
        return this.kind;
    }

    public DataCollectionRuleResourceInner withKind(KnownDataCollectionRuleResourceKind kind) {
        this.kind = kind;
        return this;
    }

    public String etag() {
        return this.etag;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public String description() {
        return this.description;
    }

    public DataCollectionRuleResourceInner withDescription(String description) {
        this.description = description;
        return this;
    }

    public String immutableId() {
        return this.immutableId;
    }

    public DataCollectionRuleDataSources dataSources() {
        return this.dataSources;
    }

    public DataCollectionRuleResourceInner withDataSources(DataCollectionRuleDataSources dataSources) {
        this.dataSources = dataSources;
        return this;
    }

    public DataCollectionRuleDestinations destinations() {
        return this.destinations;
    }

    public DataCollectionRuleResourceInner withDestinations(DataCollectionRuleDestinations destinations) {
        this.destinations = destinations;
        return this;
    }

    public List<DataFlow> dataFlows() {
        return this.dataFlows;
    }

    public DataCollectionRuleResourceInner withDataFlows(List<DataFlow> dataFlows) {
        this.dataFlows = dataFlows;
        return this;
    }

    public KnownDataCollectionRuleProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public DataCollectionRuleResourceInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public DataCollectionRuleResourceInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public void validate() {
        if (this.dataSources() != null) {
            this.dataSources().validate();
        }
        if (this.destinations() != null) {
            this.destinations().validate();
        }
        if (this.dataFlows() != null) {
            this.dataFlows().forEach(e -> e.validate());
        }
    }
}

