/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.monitor.fluent.models;

import com.azure.core.annotation.JsonFlatten;
import com.azure.core.management.Resource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.monitor.models.RetentionPolicy;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;

@JsonFlatten
public class LogProfileResourceInner
extends Resource {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(LogProfileResourceInner.class);
    @JsonProperty(value="properties.storageAccountId")
    private String storageAccountId;
    @JsonProperty(value="properties.serviceBusRuleId")
    private String serviceBusRuleId;
    @JsonProperty(value="properties.locations", required=true)
    private List<String> locations;
    @JsonProperty(value="properties.categories", required=true)
    private List<String> categories;
    @JsonProperty(value="properties.retentionPolicy", required=true)
    private RetentionPolicy retentionPolicy;

    public String storageAccountId() {
        return this.storageAccountId;
    }

    public LogProfileResourceInner withStorageAccountId(String storageAccountId) {
        this.storageAccountId = storageAccountId;
        return this;
    }

    public String serviceBusRuleId() {
        return this.serviceBusRuleId;
    }

    public LogProfileResourceInner withServiceBusRuleId(String serviceBusRuleId) {
        this.serviceBusRuleId = serviceBusRuleId;
        return this;
    }

    public List<String> locations() {
        return this.locations;
    }

    public LogProfileResourceInner withLocations(List<String> locations) {
        this.locations = locations;
        return this;
    }

    public List<String> categories() {
        return this.categories;
    }

    public LogProfileResourceInner withCategories(List<String> categories) {
        this.categories = categories;
        return this;
    }

    public RetentionPolicy retentionPolicy() {
        return this.retentionPolicy;
    }

    public LogProfileResourceInner withRetentionPolicy(RetentionPolicy retentionPolicy) {
        this.retentionPolicy = retentionPolicy;
        return this;
    }

    public LogProfileResourceInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public LogProfileResourceInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public void validate() {
        if (this.locations() == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property locations in model LogProfileResourceInner"));
        }
        if (this.categories() == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property categories in model LogProfileResourceInner"));
        }
        if (this.retentionPolicy() == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property retentionPolicy in model LogProfileResourceInner"));
        }
        this.retentionPolicy().validate();
    }
}

