/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.sql.fluent.DatabaseThreatDetectionPoliciesClient;
import com.azure.resourcemanager.sql.fluent.models.DatabaseSecurityAlertPolicyInner;
import com.azure.resourcemanager.sql.implementation.SqlManagementClientImpl;
import com.azure.resourcemanager.sql.models.SecurityAlertPolicyName;
import reactor.core.publisher.Mono;

public final class DatabaseThreatDetectionPoliciesClientImpl
implements DatabaseThreatDetectionPoliciesClient {
    private final ClientLogger logger = new ClientLogger(DatabaseThreatDetectionPoliciesClientImpl.class);
    private final DatabaseThreatDetectionPoliciesService service;
    private final SqlManagementClientImpl client;

    DatabaseThreatDetectionPoliciesClientImpl(SqlManagementClientImpl client) {
        this.service = (DatabaseThreatDetectionPoliciesService)RestProxy.create(DatabaseThreatDetectionPoliciesService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<DatabaseSecurityAlertPolicyInner>> getWithResponseAsync(String resourceGroupName, String serverName, String databaseName, SecurityAlertPolicyName securityAlertPolicyName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (securityAlertPolicyName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter securityAlertPolicyName is required and cannot be null."));
        }
        String apiVersion = "2014-04-01";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, serverName, databaseName, securityAlertPolicyName, "2014-04-01", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<DatabaseSecurityAlertPolicyInner>> getWithResponseAsync(String resourceGroupName, String serverName, String databaseName, SecurityAlertPolicyName securityAlertPolicyName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (securityAlertPolicyName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter securityAlertPolicyName is required and cannot be null."));
        }
        String apiVersion = "2014-04-01";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, serverName, databaseName, securityAlertPolicyName, "2014-04-01", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<DatabaseSecurityAlertPolicyInner> getAsync(String resourceGroupName, String serverName, String databaseName, SecurityAlertPolicyName securityAlertPolicyName) {
        return this.getWithResponseAsync(resourceGroupName, serverName, databaseName, securityAlertPolicyName).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((DatabaseSecurityAlertPolicyInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public DatabaseSecurityAlertPolicyInner get(String resourceGroupName, String serverName, String databaseName, SecurityAlertPolicyName securityAlertPolicyName) {
        return (DatabaseSecurityAlertPolicyInner)((Object)this.getAsync(resourceGroupName, serverName, databaseName, securityAlertPolicyName).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<DatabaseSecurityAlertPolicyInner> getWithResponse(String resourceGroupName, String serverName, String databaseName, SecurityAlertPolicyName securityAlertPolicyName, Context context) {
        return (Response)this.getWithResponseAsync(resourceGroupName, serverName, databaseName, securityAlertPolicyName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<DatabaseSecurityAlertPolicyInner>> createOrUpdateWithResponseAsync(String resourceGroupName, String serverName, String databaseName, SecurityAlertPolicyName securityAlertPolicyName, DatabaseSecurityAlertPolicyInner parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (securityAlertPolicyName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter securityAlertPolicyName is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String apiVersion = "2014-04-01";
        return FluxUtil.withContext(context -> this.service.createOrUpdate(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, serverName, databaseName, securityAlertPolicyName, "2014-04-01", parameters, (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<DatabaseSecurityAlertPolicyInner>> createOrUpdateWithResponseAsync(String resourceGroupName, String serverName, String databaseName, SecurityAlertPolicyName securityAlertPolicyName, DatabaseSecurityAlertPolicyInner parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (securityAlertPolicyName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter securityAlertPolicyName is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String apiVersion = "2014-04-01";
        context = this.client.mergeContext(context);
        return this.service.createOrUpdate(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, serverName, databaseName, securityAlertPolicyName, "2014-04-01", parameters, context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<DatabaseSecurityAlertPolicyInner> createOrUpdateAsync(String resourceGroupName, String serverName, String databaseName, SecurityAlertPolicyName securityAlertPolicyName, DatabaseSecurityAlertPolicyInner parameters) {
        return this.createOrUpdateWithResponseAsync(resourceGroupName, serverName, databaseName, securityAlertPolicyName, parameters).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((DatabaseSecurityAlertPolicyInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public DatabaseSecurityAlertPolicyInner createOrUpdate(String resourceGroupName, String serverName, String databaseName, SecurityAlertPolicyName securityAlertPolicyName, DatabaseSecurityAlertPolicyInner parameters) {
        return (DatabaseSecurityAlertPolicyInner)((Object)this.createOrUpdateAsync(resourceGroupName, serverName, databaseName, securityAlertPolicyName, parameters).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<DatabaseSecurityAlertPolicyInner> createOrUpdateWithResponse(String resourceGroupName, String serverName, String databaseName, SecurityAlertPolicyName securityAlertPolicyName, DatabaseSecurityAlertPolicyInner parameters, Context context) {
        return (Response)this.createOrUpdateWithResponseAsync(resourceGroupName, serverName, databaseName, securityAlertPolicyName, parameters, context).block();
    }

    @Host(value="{$host}")
    @ServiceInterface(name="SqlManagementClientD")
    private static interface DatabaseThreatDetectionPoliciesService {
        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/securityAlertPolicies/{securityAlertPolicyName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<DatabaseSecurityAlertPolicyInner>> get(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="serverName") String var4, @PathParam(value="databaseName") String var5, @PathParam(value="securityAlertPolicyName") SecurityAlertPolicyName var6, @QueryParam(value="api-version") String var7, Context var8);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/securityAlertPolicies/{securityAlertPolicyName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<DatabaseSecurityAlertPolicyInner>> createOrUpdate(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="serverName") String var4, @PathParam(value="databaseName") String var5, @PathParam(value="securityAlertPolicyName") SecurityAlertPolicyName var6, @QueryParam(value="api-version") String var7, @BodyParam(value="application/json") DatabaseSecurityAlertPolicyInner var8, Context var9);
    }
}

