/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.sql.fluent.SyncMembersClient;
import com.azure.resourcemanager.sql.fluent.models.SyncFullSchemaPropertiesInner;
import com.azure.resourcemanager.sql.fluent.models.SyncMemberInner;
import com.azure.resourcemanager.sql.implementation.SqlManagementClientImpl;
import com.azure.resourcemanager.sql.models.SyncFullSchemaPropertiesListResult;
import com.azure.resourcemanager.sql.models.SyncMemberListResult;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class SyncMembersClientImpl
implements SyncMembersClient {
    private final ClientLogger logger = new ClientLogger(SyncMembersClientImpl.class);
    private final SyncMembersService service;
    private final SqlManagementClientImpl client;

    SyncMembersClientImpl(SqlManagementClientImpl client) {
        this.service = (SyncMembersService)RestProxy.create(SyncMembersService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SyncMemberInner>> getWithResponseAsync(String resourceGroupName, String serverName, String databaseName, String syncGroupName, String syncMemberName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (syncGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter syncGroupName is required and cannot be null."));
        }
        if (syncMemberName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter syncMemberName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2015-05-01-preview";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), resourceGroupName, serverName, databaseName, syncGroupName, syncMemberName, this.client.getSubscriptionId(), "2015-05-01-preview", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<SyncMemberInner>> getWithResponseAsync(String resourceGroupName, String serverName, String databaseName, String syncGroupName, String syncMemberName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (syncGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter syncGroupName is required and cannot be null."));
        }
        if (syncMemberName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter syncMemberName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2015-05-01-preview";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), resourceGroupName, serverName, databaseName, syncGroupName, syncMemberName, this.client.getSubscriptionId(), "2015-05-01-preview", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SyncMemberInner> getAsync(String resourceGroupName, String serverName, String databaseName, String syncGroupName, String syncMemberName) {
        return this.getWithResponseAsync(resourceGroupName, serverName, databaseName, syncGroupName, syncMemberName).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((SyncMemberInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SyncMemberInner get(String resourceGroupName, String serverName, String databaseName, String syncGroupName, String syncMemberName) {
        return (SyncMemberInner)((Object)this.getAsync(resourceGroupName, serverName, databaseName, syncGroupName, syncMemberName).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SyncMemberInner> getWithResponse(String resourceGroupName, String serverName, String databaseName, String syncGroupName, String syncMemberName, Context context) {
        return (Response)this.getWithResponseAsync(resourceGroupName, serverName, databaseName, syncGroupName, syncMemberName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName, String serverName, String databaseName, String syncGroupName, String syncMemberName, SyncMemberInner parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (syncGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter syncGroupName is required and cannot be null."));
        }
        if (syncMemberName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter syncMemberName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String apiVersion = "2015-05-01-preview";
        return FluxUtil.withContext(context -> this.service.createOrUpdate(this.client.getEndpoint(), resourceGroupName, serverName, databaseName, syncGroupName, syncMemberName, this.client.getSubscriptionId(), "2015-05-01-preview", parameters, (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName, String serverName, String databaseName, String syncGroupName, String syncMemberName, SyncMemberInner parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (syncGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter syncGroupName is required and cannot be null."));
        }
        if (syncMemberName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter syncMemberName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String apiVersion = "2015-05-01-preview";
        context = this.client.mergeContext(context);
        return this.service.createOrUpdate(this.client.getEndpoint(), resourceGroupName, serverName, databaseName, syncGroupName, syncMemberName, this.client.getSubscriptionId(), "2015-05-01-preview", parameters, context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public PollerFlux<PollResult<SyncMemberInner>, SyncMemberInner> beginCreateOrUpdateAsync(String resourceGroupName, String serverName, String databaseName, String syncGroupName, String syncMemberName, SyncMemberInner parameters) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateWithResponseAsync(resourceGroupName, serverName, databaseName, syncGroupName, syncMemberName, parameters);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)SyncMemberInner.class), (Type)((Object)SyncMemberInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PollerFlux<PollResult<SyncMemberInner>, SyncMemberInner> beginCreateOrUpdateAsync(String resourceGroupName, String serverName, String databaseName, String syncGroupName, String syncMemberName, SyncMemberInner parameters, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateWithResponseAsync(resourceGroupName, serverName, databaseName, syncGroupName, syncMemberName, parameters, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)SyncMemberInner.class), (Type)((Object)SyncMemberInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SyncPoller<PollResult<SyncMemberInner>, SyncMemberInner> beginCreateOrUpdate(String resourceGroupName, String serverName, String databaseName, String syncGroupName, String syncMemberName, SyncMemberInner parameters) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, serverName, databaseName, syncGroupName, syncMemberName, parameters).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SyncPoller<PollResult<SyncMemberInner>, SyncMemberInner> beginCreateOrUpdate(String resourceGroupName, String serverName, String databaseName, String syncGroupName, String syncMemberName, SyncMemberInner parameters, Context context) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, serverName, databaseName, syncGroupName, syncMemberName, parameters, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SyncMemberInner> createOrUpdateAsync(String resourceGroupName, String serverName, String databaseName, String syncGroupName, String syncMemberName, SyncMemberInner parameters) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, serverName, databaseName, syncGroupName, syncMemberName, parameters).last().flatMap(arg_0 -> ((SqlManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<SyncMemberInner> createOrUpdateAsync(String resourceGroupName, String serverName, String databaseName, String syncGroupName, String syncMemberName, SyncMemberInner parameters, Context context) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, serverName, databaseName, syncGroupName, syncMemberName, parameters, context).last().flatMap(arg_0 -> ((SqlManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SyncMemberInner createOrUpdate(String resourceGroupName, String serverName, String databaseName, String syncGroupName, String syncMemberName, SyncMemberInner parameters) {
        return (SyncMemberInner)((Object)this.createOrUpdateAsync(resourceGroupName, serverName, databaseName, syncGroupName, syncMemberName, parameters).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SyncMemberInner createOrUpdate(String resourceGroupName, String serverName, String databaseName, String syncGroupName, String syncMemberName, SyncMemberInner parameters, Context context) {
        return (SyncMemberInner)((Object)this.createOrUpdateAsync(resourceGroupName, serverName, databaseName, syncGroupName, syncMemberName, parameters, context).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String serverName, String databaseName, String syncGroupName, String syncMemberName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (syncGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter syncGroupName is required and cannot be null."));
        }
        if (syncMemberName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter syncMemberName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2015-05-01-preview";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), resourceGroupName, serverName, databaseName, syncGroupName, syncMemberName, this.client.getSubscriptionId(), "2015-05-01-preview", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String serverName, String databaseName, String syncGroupName, String syncMemberName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (syncGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter syncGroupName is required and cannot be null."));
        }
        if (syncMemberName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter syncMemberName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2015-05-01-preview";
        context = this.client.mergeContext(context);
        return this.service.delete(this.client.getEndpoint(), resourceGroupName, serverName, databaseName, syncGroupName, syncMemberName, this.client.getSubscriptionId(), "2015-05-01-preview", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String serverName, String databaseName, String syncGroupName, String syncMemberName) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, serverName, databaseName, syncGroupName, syncMemberName);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String serverName, String databaseName, String syncGroupName, String syncMemberName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, serverName, databaseName, syncGroupName, syncMemberName, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String serverName, String databaseName, String syncGroupName, String syncMemberName) {
        return this.beginDeleteAsync(resourceGroupName, serverName, databaseName, syncGroupName, syncMemberName).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String serverName, String databaseName, String syncGroupName, String syncMemberName, Context context) {
        return this.beginDeleteAsync(resourceGroupName, serverName, databaseName, syncGroupName, syncMemberName, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteAsync(String resourceGroupName, String serverName, String databaseName, String syncGroupName, String syncMemberName) {
        return this.beginDeleteAsync(resourceGroupName, serverName, databaseName, syncGroupName, syncMemberName).last().flatMap(arg_0 -> ((SqlManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String resourceGroupName, String serverName, String databaseName, String syncGroupName, String syncMemberName, Context context) {
        return this.beginDeleteAsync(resourceGroupName, serverName, databaseName, syncGroupName, syncMemberName, context).last().flatMap(arg_0 -> ((SqlManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String serverName, String databaseName, String syncGroupName, String syncMemberName) {
        this.deleteAsync(resourceGroupName, serverName, databaseName, syncGroupName, syncMemberName).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String serverName, String databaseName, String syncGroupName, String syncMemberName, Context context) {
        this.deleteAsync(resourceGroupName, serverName, databaseName, syncGroupName, syncMemberName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(String resourceGroupName, String serverName, String databaseName, String syncGroupName, String syncMemberName, SyncMemberInner parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (syncGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter syncGroupName is required and cannot be null."));
        }
        if (syncMemberName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter syncMemberName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String apiVersion = "2015-05-01-preview";
        return FluxUtil.withContext(context -> this.service.update(this.client.getEndpoint(), resourceGroupName, serverName, databaseName, syncGroupName, syncMemberName, this.client.getSubscriptionId(), "2015-05-01-preview", parameters, (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(String resourceGroupName, String serverName, String databaseName, String syncGroupName, String syncMemberName, SyncMemberInner parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (syncGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter syncGroupName is required and cannot be null."));
        }
        if (syncMemberName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter syncMemberName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String apiVersion = "2015-05-01-preview";
        context = this.client.mergeContext(context);
        return this.service.update(this.client.getEndpoint(), resourceGroupName, serverName, databaseName, syncGroupName, syncMemberName, this.client.getSubscriptionId(), "2015-05-01-preview", parameters, context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public PollerFlux<PollResult<SyncMemberInner>, SyncMemberInner> beginUpdateAsync(String resourceGroupName, String serverName, String databaseName, String syncGroupName, String syncMemberName, SyncMemberInner parameters) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.updateWithResponseAsync(resourceGroupName, serverName, databaseName, syncGroupName, syncMemberName, parameters);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)SyncMemberInner.class), (Type)((Object)SyncMemberInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PollerFlux<PollResult<SyncMemberInner>, SyncMemberInner> beginUpdateAsync(String resourceGroupName, String serverName, String databaseName, String syncGroupName, String syncMemberName, SyncMemberInner parameters, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.updateWithResponseAsync(resourceGroupName, serverName, databaseName, syncGroupName, syncMemberName, parameters, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)SyncMemberInner.class), (Type)((Object)SyncMemberInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SyncPoller<PollResult<SyncMemberInner>, SyncMemberInner> beginUpdate(String resourceGroupName, String serverName, String databaseName, String syncGroupName, String syncMemberName, SyncMemberInner parameters) {
        return this.beginUpdateAsync(resourceGroupName, serverName, databaseName, syncGroupName, syncMemberName, parameters).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SyncPoller<PollResult<SyncMemberInner>, SyncMemberInner> beginUpdate(String resourceGroupName, String serverName, String databaseName, String syncGroupName, String syncMemberName, SyncMemberInner parameters, Context context) {
        return this.beginUpdateAsync(resourceGroupName, serverName, databaseName, syncGroupName, syncMemberName, parameters, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SyncMemberInner> updateAsync(String resourceGroupName, String serverName, String databaseName, String syncGroupName, String syncMemberName, SyncMemberInner parameters) {
        return this.beginUpdateAsync(resourceGroupName, serverName, databaseName, syncGroupName, syncMemberName, parameters).last().flatMap(arg_0 -> ((SqlManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<SyncMemberInner> updateAsync(String resourceGroupName, String serverName, String databaseName, String syncGroupName, String syncMemberName, SyncMemberInner parameters, Context context) {
        return this.beginUpdateAsync(resourceGroupName, serverName, databaseName, syncGroupName, syncMemberName, parameters, context).last().flatMap(arg_0 -> ((SqlManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SyncMemberInner update(String resourceGroupName, String serverName, String databaseName, String syncGroupName, String syncMemberName, SyncMemberInner parameters) {
        return (SyncMemberInner)((Object)this.updateAsync(resourceGroupName, serverName, databaseName, syncGroupName, syncMemberName, parameters).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SyncMemberInner update(String resourceGroupName, String serverName, String databaseName, String syncGroupName, String syncMemberName, SyncMemberInner parameters, Context context) {
        return (SyncMemberInner)((Object)this.updateAsync(resourceGroupName, serverName, databaseName, syncGroupName, syncMemberName, parameters, context).block());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<SyncMemberInner>> listBySyncGroupSinglePageAsync(String resourceGroupName, String serverName, String databaseName, String syncGroupName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (syncGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter syncGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2015-05-01-preview";
        return FluxUtil.withContext(context -> this.service.listBySyncGroup(this.client.getEndpoint(), resourceGroupName, serverName, databaseName, syncGroupName, this.client.getSubscriptionId(), "2015-05-01-preview", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SyncMemberListResult)res.getValue()).value(), ((SyncMemberListResult)res.getValue()).nextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<SyncMemberInner>> listBySyncGroupSinglePageAsync(String resourceGroupName, String serverName, String databaseName, String syncGroupName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (syncGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter syncGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2015-05-01-preview";
        context = this.client.mergeContext(context);
        return this.service.listBySyncGroup(this.client.getEndpoint(), resourceGroupName, serverName, databaseName, syncGroupName, this.client.getSubscriptionId(), "2015-05-01-preview", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SyncMemberListResult)res.getValue()).value(), ((SyncMemberListResult)res.getValue()).nextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<SyncMemberInner> listBySyncGroupAsync(String resourceGroupName, String serverName, String databaseName, String syncGroupName) {
        return new PagedFlux(() -> this.listBySyncGroupSinglePageAsync(resourceGroupName, serverName, databaseName, syncGroupName), nextLink -> this.listBySyncGroupNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<SyncMemberInner> listBySyncGroupAsync(String resourceGroupName, String serverName, String databaseName, String syncGroupName, Context context) {
        return new PagedFlux(() -> this.listBySyncGroupSinglePageAsync(resourceGroupName, serverName, databaseName, syncGroupName, context), nextLink -> this.listBySyncGroupNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<SyncMemberInner> listBySyncGroup(String resourceGroupName, String serverName, String databaseName, String syncGroupName) {
        return new PagedIterable(this.listBySyncGroupAsync(resourceGroupName, serverName, databaseName, syncGroupName));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<SyncMemberInner> listBySyncGroup(String resourceGroupName, String serverName, String databaseName, String syncGroupName, Context context) {
        return new PagedIterable(this.listBySyncGroupAsync(resourceGroupName, serverName, databaseName, syncGroupName, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<SyncFullSchemaPropertiesInner>> listMemberSchemasSinglePageAsync(String resourceGroupName, String serverName, String databaseName, String syncGroupName, String syncMemberName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (syncGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter syncGroupName is required and cannot be null."));
        }
        if (syncMemberName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter syncMemberName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2015-05-01-preview";
        return FluxUtil.withContext(context -> this.service.listMemberSchemas(this.client.getEndpoint(), resourceGroupName, serverName, databaseName, syncGroupName, syncMemberName, this.client.getSubscriptionId(), "2015-05-01-preview", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SyncFullSchemaPropertiesListResult)res.getValue()).value(), ((SyncFullSchemaPropertiesListResult)res.getValue()).nextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<SyncFullSchemaPropertiesInner>> listMemberSchemasSinglePageAsync(String resourceGroupName, String serverName, String databaseName, String syncGroupName, String syncMemberName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (syncGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter syncGroupName is required and cannot be null."));
        }
        if (syncMemberName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter syncMemberName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2015-05-01-preview";
        context = this.client.mergeContext(context);
        return this.service.listMemberSchemas(this.client.getEndpoint(), resourceGroupName, serverName, databaseName, syncGroupName, syncMemberName, this.client.getSubscriptionId(), "2015-05-01-preview", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SyncFullSchemaPropertiesListResult)res.getValue()).value(), ((SyncFullSchemaPropertiesListResult)res.getValue()).nextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<SyncFullSchemaPropertiesInner> listMemberSchemasAsync(String resourceGroupName, String serverName, String databaseName, String syncGroupName, String syncMemberName) {
        return new PagedFlux(() -> this.listMemberSchemasSinglePageAsync(resourceGroupName, serverName, databaseName, syncGroupName, syncMemberName), nextLink -> this.listMemberSchemasNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<SyncFullSchemaPropertiesInner> listMemberSchemasAsync(String resourceGroupName, String serverName, String databaseName, String syncGroupName, String syncMemberName, Context context) {
        return new PagedFlux(() -> this.listMemberSchemasSinglePageAsync(resourceGroupName, serverName, databaseName, syncGroupName, syncMemberName, context), nextLink -> this.listMemberSchemasNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<SyncFullSchemaPropertiesInner> listMemberSchemas(String resourceGroupName, String serverName, String databaseName, String syncGroupName, String syncMemberName) {
        return new PagedIterable(this.listMemberSchemasAsync(resourceGroupName, serverName, databaseName, syncGroupName, syncMemberName));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<SyncFullSchemaPropertiesInner> listMemberSchemas(String resourceGroupName, String serverName, String databaseName, String syncGroupName, String syncMemberName, Context context) {
        return new PagedIterable(this.listMemberSchemasAsync(resourceGroupName, serverName, databaseName, syncGroupName, syncMemberName, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> refreshMemberSchemaWithResponseAsync(String resourceGroupName, String serverName, String databaseName, String syncGroupName, String syncMemberName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (syncGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter syncGroupName is required and cannot be null."));
        }
        if (syncMemberName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter syncMemberName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2015-05-01-preview";
        return FluxUtil.withContext(context -> this.service.refreshMemberSchema(this.client.getEndpoint(), resourceGroupName, serverName, databaseName, syncGroupName, syncMemberName, this.client.getSubscriptionId(), "2015-05-01-preview", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> refreshMemberSchemaWithResponseAsync(String resourceGroupName, String serverName, String databaseName, String syncGroupName, String syncMemberName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (syncGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter syncGroupName is required and cannot be null."));
        }
        if (syncMemberName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter syncMemberName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2015-05-01-preview";
        context = this.client.mergeContext(context);
        return this.service.refreshMemberSchema(this.client.getEndpoint(), resourceGroupName, serverName, databaseName, syncGroupName, syncMemberName, this.client.getSubscriptionId(), "2015-05-01-preview", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public PollerFlux<PollResult<Void>, Void> beginRefreshMemberSchemaAsync(String resourceGroupName, String serverName, String databaseName, String syncGroupName, String syncMemberName) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.refreshMemberSchemaWithResponseAsync(resourceGroupName, serverName, databaseName, syncGroupName, syncMemberName);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PollerFlux<PollResult<Void>, Void> beginRefreshMemberSchemaAsync(String resourceGroupName, String serverName, String databaseName, String syncGroupName, String syncMemberName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.refreshMemberSchemaWithResponseAsync(resourceGroupName, serverName, databaseName, syncGroupName, syncMemberName, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SyncPoller<PollResult<Void>, Void> beginRefreshMemberSchema(String resourceGroupName, String serverName, String databaseName, String syncGroupName, String syncMemberName) {
        return this.beginRefreshMemberSchemaAsync(resourceGroupName, serverName, databaseName, syncGroupName, syncMemberName).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SyncPoller<PollResult<Void>, Void> beginRefreshMemberSchema(String resourceGroupName, String serverName, String databaseName, String syncGroupName, String syncMemberName, Context context) {
        return this.beginRefreshMemberSchemaAsync(resourceGroupName, serverName, databaseName, syncGroupName, syncMemberName, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> refreshMemberSchemaAsync(String resourceGroupName, String serverName, String databaseName, String syncGroupName, String syncMemberName) {
        return this.beginRefreshMemberSchemaAsync(resourceGroupName, serverName, databaseName, syncGroupName, syncMemberName).last().flatMap(arg_0 -> ((SqlManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> refreshMemberSchemaAsync(String resourceGroupName, String serverName, String databaseName, String syncGroupName, String syncMemberName, Context context) {
        return this.beginRefreshMemberSchemaAsync(resourceGroupName, serverName, databaseName, syncGroupName, syncMemberName, context).last().flatMap(arg_0 -> ((SqlManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void refreshMemberSchema(String resourceGroupName, String serverName, String databaseName, String syncGroupName, String syncMemberName) {
        this.refreshMemberSchemaAsync(resourceGroupName, serverName, databaseName, syncGroupName, syncMemberName).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void refreshMemberSchema(String resourceGroupName, String serverName, String databaseName, String syncGroupName, String syncMemberName, Context context) {
        this.refreshMemberSchemaAsync(resourceGroupName, serverName, databaseName, syncGroupName, syncMemberName, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<SyncMemberInner>> listBySyncGroupNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.listBySyncGroupNext(nextLink, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SyncMemberListResult)res.getValue()).value(), ((SyncMemberListResult)res.getValue()).nextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<SyncMemberInner>> listBySyncGroupNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.listBySyncGroupNext(nextLink, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SyncMemberListResult)res.getValue()).value(), ((SyncMemberListResult)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<SyncFullSchemaPropertiesInner>> listMemberSchemasNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.listMemberSchemasNext(nextLink, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SyncFullSchemaPropertiesListResult)res.getValue()).value(), ((SyncFullSchemaPropertiesListResult)res.getValue()).nextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<SyncFullSchemaPropertiesInner>> listMemberSchemasNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.listMemberSchemasNext(nextLink, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SyncFullSchemaPropertiesListResult)res.getValue()).value(), ((SyncFullSchemaPropertiesListResult)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="SqlManagementClientS")
    private static interface SyncMembersService {
        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/syncGroups/{syncGroupName}/syncMembers/{syncMemberName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<SyncMemberInner>> get(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="serverName") String var3, @PathParam(value="databaseName") String var4, @PathParam(value="syncGroupName") String var5, @PathParam(value="syncMemberName") String var6, @PathParam(value="subscriptionId") String var7, @QueryParam(value="api-version") String var8, Context var9);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/syncGroups/{syncGroupName}/syncMembers/{syncMemberName}")
        @ExpectedResponses(value={200, 201, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> createOrUpdate(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="serverName") String var3, @PathParam(value="databaseName") String var4, @PathParam(value="syncGroupName") String var5, @PathParam(value="syncMemberName") String var6, @PathParam(value="subscriptionId") String var7, @QueryParam(value="api-version") String var8, @BodyParam(value="application/json") SyncMemberInner var9, Context var10);

        @Headers(value={"Accept: application/json;q=0.9", "Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/syncGroups/{syncGroupName}/syncMembers/{syncMemberName}")
        @ExpectedResponses(value={200, 202, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> delete(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="serverName") String var3, @PathParam(value="databaseName") String var4, @PathParam(value="syncGroupName") String var5, @PathParam(value="syncMemberName") String var6, @PathParam(value="subscriptionId") String var7, @QueryParam(value="api-version") String var8, Context var9);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Patch(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/syncGroups/{syncGroupName}/syncMembers/{syncMemberName}")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> update(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="serverName") String var3, @PathParam(value="databaseName") String var4, @PathParam(value="syncGroupName") String var5, @PathParam(value="syncMemberName") String var6, @PathParam(value="subscriptionId") String var7, @QueryParam(value="api-version") String var8, @BodyParam(value="application/json") SyncMemberInner var9, Context var10);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/syncGroups/{syncGroupName}/syncMembers")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<SyncMemberListResult>> listBySyncGroup(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="serverName") String var3, @PathParam(value="databaseName") String var4, @PathParam(value="syncGroupName") String var5, @PathParam(value="subscriptionId") String var6, @QueryParam(value="api-version") String var7, Context var8);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/syncGroups/{syncGroupName}/syncMembers/{syncMemberName}/schemas")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<SyncFullSchemaPropertiesListResult>> listMemberSchemas(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="serverName") String var3, @PathParam(value="databaseName") String var4, @PathParam(value="syncGroupName") String var5, @PathParam(value="syncMemberName") String var6, @PathParam(value="subscriptionId") String var7, @QueryParam(value="api-version") String var8, Context var9);

        @Headers(value={"Accept: application/json;q=0.9", "Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/syncGroups/{syncGroupName}/syncMembers/{syncMemberName}/refreshSchema")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> refreshMemberSchema(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="serverName") String var3, @PathParam(value="databaseName") String var4, @PathParam(value="syncGroupName") String var5, @PathParam(value="syncMemberName") String var6, @PathParam(value="subscriptionId") String var7, @QueryParam(value="api-version") String var8, Context var9);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<SyncMemberListResult>> listBySyncGroupNext(@PathParam(value="nextLink", encoded=true) String var1, Context var2);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<SyncFullSchemaPropertiesListResult>> listMemberSchemasNext(@PathParam(value="nextLink", encoded=true) String var1, Context var2);
    }
}

