/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.servicebus.stream.binder;

import com.azure.spring.integration.core.DefaultMessageHandler;
import com.azure.spring.integration.core.api.CheckpointConfig;
import com.azure.spring.integration.core.api.SendOperation;
import com.azure.spring.integration.servicebus.ServiceBusClientConfig;
import com.azure.spring.servicebus.stream.binder.properties.ServiceBusConsumerProperties;
import com.azure.spring.servicebus.stream.binder.properties.ServiceBusExtendedBindingProperties;
import com.azure.spring.servicebus.stream.binder.properties.ServiceBusProducerProperties;
import com.azure.spring.servicebus.stream.binder.provisioning.ServiceBusChannelProvisioner;
import java.util.Optional;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.cloud.stream.binder.AbstractMessageChannelBinder;
import org.springframework.cloud.stream.binder.BinderSpecificPropertiesProvider;
import org.springframework.cloud.stream.binder.ExtendedConsumerProperties;
import org.springframework.cloud.stream.binder.ExtendedProducerProperties;
import org.springframework.cloud.stream.binder.ExtendedPropertiesBinder;
import org.springframework.cloud.stream.provisioning.ProducerDestination;
import org.springframework.cloud.stream.provisioning.ProvisioningProvider;
import org.springframework.expression.Expression;
import org.springframework.integration.expression.FunctionExpression;
import org.springframework.integration.support.DefaultErrorMessageStrategy;
import org.springframework.integration.support.ErrorMessageStrategy;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.MessageHandler;

public abstract class ServiceBusMessageChannelBinder<T extends ServiceBusExtendedBindingProperties>
extends AbstractMessageChannelBinder<ExtendedConsumerProperties<ServiceBusConsumerProperties>, ExtendedProducerProperties<ServiceBusProducerProperties>, ServiceBusChannelProvisioner>
implements ExtendedPropertiesBinder<MessageChannel, ServiceBusConsumerProperties, ServiceBusProducerProperties> {
    protected T bindingProperties;
    private static final DefaultErrorMessageStrategy DEFAULT_ERROR_MESSAGE_STRATEGY = new DefaultErrorMessageStrategy();
    protected static final String EXCEPTION_MESSAGE = "exception-message";

    public ServiceBusMessageChannelBinder(String[] headersToEmbed, ServiceBusChannelProvisioner provisioningProvider) {
        super(headersToEmbed, (ProvisioningProvider)provisioningProvider);
    }

    protected MessageHandler createProducerMessageHandler(ProducerDestination destination, ExtendedProducerProperties<ServiceBusProducerProperties> producerProperties, MessageChannel errorChannel) {
        DefaultMessageHandler handler = new DefaultMessageHandler(destination.getName(), this.getSendOperation());
        handler.setBeanFactory((BeanFactory)this.getBeanFactory());
        handler.setSync(((ServiceBusProducerProperties)producerProperties.getExtension()).isSync());
        handler.setSendTimeout(((ServiceBusProducerProperties)producerProperties.getExtension()).getSendTimeout());
        handler.setSendFailureChannel(errorChannel);
        if (producerProperties.isPartitioned()) {
            handler.setPartitionKeyExpressionString("'partitionKey-' + headers['scst_partition']");
        } else {
            handler.setPartitionKeyExpression((Expression)new FunctionExpression(m -> m.getPayload().hashCode()));
        }
        return handler;
    }

    public ServiceBusConsumerProperties getExtendedConsumerProperties(String channelName) {
        return ((ServiceBusExtendedBindingProperties)this.bindingProperties).getExtendedConsumerProperties(channelName);
    }

    public ServiceBusProducerProperties getExtendedProducerProperties(String channelName) {
        return ((ServiceBusExtendedBindingProperties)this.bindingProperties).getExtendedProducerProperties(channelName);
    }

    public String getDefaultsPrefix() {
        return this.bindingProperties.getDefaultsPrefix();
    }

    public Class<? extends BinderSpecificPropertiesProvider> getExtendedPropertiesEntryClass() {
        return ((ServiceBusExtendedBindingProperties)this.bindingProperties).getExtendedPropertiesEntryClass();
    }

    protected ErrorMessageStrategy getErrorMessageStrategy() {
        return DEFAULT_ERROR_MESSAGE_STRATEGY;
    }

    public void setBindingProperties(T bindingProperties) {
        this.bindingProperties = bindingProperties;
    }

    protected CheckpointConfig buildCheckpointConfig(ExtendedConsumerProperties<ServiceBusConsumerProperties> properties) {
        return CheckpointConfig.builder().checkpointMode(((ServiceBusConsumerProperties)properties.getExtension()).getCheckpointMode()).build();
    }

    protected ServiceBusClientConfig buildClientConfig(ExtendedConsumerProperties<ServiceBusConsumerProperties> properties) {
        ServiceBusConsumerProperties consumerProperties = (ServiceBusConsumerProperties)properties.getExtension();
        return ServiceBusClientConfig.builder().setPrefetchCount(consumerProperties.getPrefetchCount()).setConcurrency(consumerProperties.getConcurrency()).setSessionsEnabled(consumerProperties.isSessionsEnabled()).setMaxConcurrentCalls(Optional.ofNullable(consumerProperties.getMaxConcurrentCalls()).orElse(consumerProperties.isSessionsEnabled() ? 1 : consumerProperties.getConcurrency()).intValue()).setMaxConcurrentSessions(Optional.ofNullable(consumerProperties.getMaxConcurrentSessions()).orElse(consumerProperties.isSessionsEnabled() ? consumerProperties.getConcurrency() : 1).intValue()).setServiceBusReceiveMode(consumerProperties.getServiceBusReceiveMode()).setEnableAutoComplete(consumerProperties.isEnableAutoComplete()).build();
    }

    abstract SendOperation getSendOperation();
}

