/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.servicebus.stream.binder.properties;

import com.azure.spring.servicebus.stream.binder.properties.ServiceBusBindingProperties;
import com.azure.spring.servicebus.stream.binder.properties.ServiceBusConsumerProperties;
import com.azure.spring.servicebus.stream.binder.properties.ServiceBusProducerProperties;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.cloud.stream.binder.BinderSpecificPropertiesProvider;
import org.springframework.cloud.stream.binder.ExtendedBindingProperties;

public abstract class ServiceBusExtendedBindingProperties
implements ExtendedBindingProperties<ServiceBusConsumerProperties, ServiceBusProducerProperties> {
    private final Map<String, ServiceBusBindingProperties> bindings = new ConcurrentHashMap<String, ServiceBusBindingProperties>();

    public ServiceBusConsumerProperties getExtendedConsumerProperties(String channelName) {
        return this.bindings.computeIfAbsent(channelName, key -> new ServiceBusBindingProperties()).getConsumer();
    }

    public ServiceBusProducerProperties getExtendedProducerProperties(String channelName) {
        return this.bindings.computeIfAbsent(channelName, key -> new ServiceBusBindingProperties()).getProducer();
    }

    public Class<? extends BinderSpecificPropertiesProvider> getExtendedPropertiesEntryClass() {
        return ServiceBusBindingProperties.class;
    }

    public Map<String, ServiceBusBindingProperties> getBindings() {
        return this.bindings;
    }
}

